@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin

import com.pulumi.aws.fms.kotlin.outputs.PolicyExcludeMap
import com.pulumi.aws.fms.kotlin.outputs.PolicyIncludeMap
import com.pulumi.aws.fms.kotlin.outputs.PolicySecurityServicePolicyData
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.fms.kotlin.outputs.PolicyExcludeMap.Companion.toKotlin as policyExcludeMapToKotlin
import com.pulumi.aws.fms.kotlin.outputs.PolicyIncludeMap.Companion.toKotlin as policyIncludeMapToKotlin
import com.pulumi.aws.fms.kotlin.outputs.PolicySecurityServicePolicyData.Companion.toKotlin as policySecurityServicePolicyDataToKotlin

/**
 * Builder for [Policy].
 */
@PulumiTagMarker
public class PolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: PolicyArgs = PolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend PolicyArgsBuilder.() -> Unit) {
        val builder = PolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Policy {
        val builtJavaResource = com.pulumi.aws.fms.Policy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Policy(builtJavaResource)
    }
}

/**
 * Provides a resource to create an AWS Firewall Manager policy. You need to be using AWS organizations and have enabled the Firewall Manager administrator account.
 * > **NOTE:** Due to limitations with testing, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleRuleGroup = new aws.wafregional.RuleGroup("example", {
 *     metricName: "WAFRuleGroupExample",
 *     name: "WAF-Rule-Group-Example",
 * });
 * const example = new aws.fms.Policy("example", {
 *     name: "FMS-Policy-Example",
 *     excludeResourceTags: false,
 *     remediationEnabled: false,
 *     resourceType: "AWS::ElasticLoadBalancingV2::LoadBalancer",
 *     securityServicePolicyData: {
 *         type: "WAF",
 *         managedServiceData: pulumi.jsonStringify({
 *             type: "WAF",
 *             ruleGroups: [{
 *                 id: exampleRuleGroup.id,
 *                 overrideAction: {
 *                     type: "COUNT",
 *                 },
 *             }],
 *             defaultAction: {
 *                 type: "BLOCK",
 *             },
 *             overrideCustomerWebACLAssociation: false,
 *         }),
 *     },
 *     tags: {
 *         Name: "example-fms-policy",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example_rule_group = aws.wafregional.RuleGroup("example",
 *     metric_name="WAFRuleGroupExample",
 *     name="WAF-Rule-Group-Example")
 * example = aws.fms.Policy("example",
 *     name="FMS-Policy-Example",
 *     exclude_resource_tags=False,
 *     remediation_enabled=False,
 *     resource_type="AWS::ElasticLoadBalancingV2::LoadBalancer",
 *     security_service_policy_data={
 *         "type": "WAF",
 *         "managed_service_data": pulumi.Output.json_dumps({
 *             "type": "WAF",
 *             "rule_groups": [{
 *                 "id": example_rule_group.id,
 *                 "override_action": {
 *                     "type": "COUNT",
 *                 },
 *             }],
 *             "default_action": {
 *                 "type": "BLOCK",
 *             },
 *             "override_customer_web_aclassociation": False,
 *         }),
 *     },
 *     tags={
 *         "Name": "example-fms-policy",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleRuleGroup = new Aws.WafRegional.RuleGroup("example", new()
 *     {
 *         MetricName = "WAFRuleGroupExample",
 *         Name = "WAF-Rule-Group-Example",
 *     });
 *     var example = new Aws.Fms.Policy("example", new()
 *     {
 *         Name = "FMS-Policy-Example",
 *         ExcludeResourceTags = false,
 *         RemediationEnabled = false,
 *         ResourceType = "AWS::ElasticLoadBalancingV2::LoadBalancer",
 *         SecurityServicePolicyData = new Aws.Fms.Inputs.PolicySecurityServicePolicyDataArgs
 *         {
 *             Type = "WAF",
 *             ManagedServiceData = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *             {
 *                 ["type"] = "WAF",
 *                 ["ruleGroups"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["id"] = exampleRuleGroup.Id,
 *                         ["overrideAction"] = new Dictionary<string, object?>
 *                         {
 *                             ["type"] = "COUNT",
 *                         },
 *                     },
 *                 },
 *                 ["defaultAction"] = new Dictionary<string, object?>
 *                 {
 *                     ["type"] = "BLOCK",
 *                 },
 *                 ["overrideCustomerWebACLAssociation"] = false,
 *             })),
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-fms-policy" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleRuleGroup, err := wafregional.NewRuleGroup(ctx, "example", &wafregional.RuleGroupArgs{
 * 			MetricName: pulumi.String("WAFRuleGroupExample"),
 * 			Name:       pulumi.String("WAF-Rule-Group-Example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fms.NewPolicy(ctx, "example", &fms.PolicyArgs{
 * 			Name:                pulumi.String("FMS-Policy-Example"),
 * 			ExcludeResourceTags: pulumi.Bool(false),
 * 			RemediationEnabled:  pulumi.Bool(false),
 * 			ResourceType:        pulumi.String("AWS::ElasticLoadBalancingV2::LoadBalancer"),
 * 			SecurityServicePolicyData: &fms.PolicySecurityServicePolicyDataArgs{
 * 				Type: pulumi.String("WAF"),
 * 				ManagedServiceData: exampleRuleGroup.ID().ApplyT(func(id string) (pulumi.String, error) {
 * 					var _zero pulumi.String
 * 					tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 						"type": "WAF",
 * 						"ruleGroups": []map[string]interface{}{
 * 							map[string]interface{}{
 * 								"id": id,
 * 								"overrideAction": map[string]interface{}{
 * 									"type": "COUNT",
 * 								},
 * 							},
 * 						},
 * 						"defaultAction": map[string]interface{}{
 * 							"type": "BLOCK",
 * 						},
 * 						"overrideCustomerWebACLAssociation": false,
 * 					})
 * 					if err != nil {
 * 						return _zero, err
 * 					}
 * 					json0 := string(tmpJSON0)
 * 					return pulumi.String(json0), nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-fms-policy"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.RuleGroup;
 * import com.pulumi.aws.wafregional.RuleGroupArgs;
 * import com.pulumi.aws.fms.Policy;
 * import com.pulumi.aws.fms.PolicyArgs;
 * import com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRuleGroup = new RuleGroup("exampleRuleGroup", RuleGroupArgs.builder()
 *             .metricName("WAFRuleGroupExample")
 *             .name("WAF-Rule-Group-Example")
 *             .build());
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .name("FMS-Policy-Example")
 *             .excludeResourceTags(false)
 *             .remediationEnabled(false)
 *             .resourceType("AWS::ElasticLoadBalancingV2::LoadBalancer")
 *             .securityServicePolicyData(PolicySecurityServicePolicyDataArgs.builder()
 *                 .type("WAF")
 *                 .managedServiceData(exampleRuleGroup.id().applyValue(id -> serializeJson(
 *                     jsonObject(
 *                         jsonProperty("type", "WAF"),
 *                         jsonProperty("ruleGroups", jsonArray(jsonObject(
 *                             jsonProperty("id", id),
 *                             jsonProperty("overrideAction", jsonObject(
 *                                 jsonProperty("type", "COUNT")
 *                             ))
 *                         ))),
 *                         jsonProperty("defaultAction", jsonObject(
 *                             jsonProperty("type", "BLOCK")
 *                         )),
 *                         jsonProperty("overrideCustomerWebACLAssociation", false)
 *                     ))))
 *                 .build())
 *             .tags(Map.of("Name", "example-fms-policy"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fms:Policy
 *     properties:
 *       name: FMS-Policy-Example
 *       excludeResourceTags: false
 *       remediationEnabled: false
 *       resourceType: AWS::ElasticLoadBalancingV2::LoadBalancer
 *       securityServicePolicyData:
 *         type: WAF
 *         managedServiceData:
 *           fn::toJSON:
 *             type: WAF
 *             ruleGroups:
 *               - id: ${exampleRuleGroup.id}
 *                 overrideAction:
 *                   type: COUNT
 *             defaultAction:
 *               type: BLOCK
 *             overrideCustomerWebACLAssociation: false
 *       tags:
 *         Name: example-fms-policy
 *   exampleRuleGroup:
 *     type: aws:wafregional:RuleGroup
 *     name: example
 *     properties:
 *       metricName: WAFRuleGroupExample
 *       name: WAF-Rule-Group-Example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Firewall Manager policies using the policy ID. For example:
 * ```sh
 * $ pulumi import aws:fms/policy:Policy example 5be49585-a7e3-4c49-dde1-a179fe4a619a
 * ```
 */
public class Policy internal constructor(
    override val javaResource: com.pulumi.aws.fms.Policy,
) : KotlinCustomResource(javaResource, PolicyMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
     */
    public val deleteAllPolicyResources: Output<Boolean>?
        get() = javaResource.deleteAllPolicyResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
     */
    public val deleteUnusedFmManagedResources: Output<Boolean>?
        get() = javaResource.deleteUnusedFmManagedResources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The description of the AWS Network Firewall firewall policy.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of lists of accounts and OU's to exclude from the policy.
     */
    public val excludeMap: Output<PolicyExcludeMap>?
        get() = javaResource.excludeMap().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    policyExcludeMapToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
     */
    public val excludeResourceTags: Output<Boolean>
        get() = javaResource.excludeResourceTags().applyValue({ args0 -> args0 })

    /**
     * A map of lists of accounts and OU's to include in the policy.
     */
    public val includeMap: Output<PolicyIncludeMap>?
        get() = javaResource.includeMap().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    policyIncludeMapToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The friendly name of the AWS Firewall Manager Policy.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A unique identifier for each update to the policy.
     */
    public val policyUpdateToken: Output<String>
        get() = javaResource.policyUpdateToken().applyValue({ args0 -> args0 })

    /**
     * A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
     */
    public val remediationEnabled: Output<Boolean>?
        get() = javaResource.remediationEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val resourceSetIds: Output<List<String>>
        get() = javaResource.resourceSetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
     */
    public val resourceTags: Output<Map<String, String>>?
        get() = javaResource.resourceTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
     */
    public val resourceType: Output<String>
        get() = javaResource.resourceType().applyValue({ args0 -> args0 })

    /**
     * A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
     */
    public val resourceTypeLists: Output<List<String>>
        get() = javaResource.resourceTypeLists().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The objects to include in Security Service Policy Data. Documented below.
     */
    public val securityServicePolicyData: Output<PolicySecurityServicePolicyData>
        get() = javaResource.securityServicePolicyData().applyValue({ args0 ->
            args0.let({ args0 ->
                policySecurityServicePolicyDataToKotlin(args0)
            })
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object PolicyMapper : ResourceMapper<Policy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fms.Policy::class == javaResource::class

    override fun map(javaResource: Resource): Policy = Policy(
        javaResource as
            com.pulumi.aws.fms.Policy,
    )
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Policy].
 */
public suspend fun policy(name: String, block: suspend PolicyResourceBuilder.() -> Unit): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Policy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun policy(name: String): Policy {
    val builder = PolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
