@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin

import com.pulumi.aws.fms.PolicyArgs.builder
import com.pulumi.aws.fms.kotlin.inputs.PolicyExcludeMapArgs
import com.pulumi.aws.fms.kotlin.inputs.PolicyExcludeMapArgsBuilder
import com.pulumi.aws.fms.kotlin.inputs.PolicyIncludeMapArgs
import com.pulumi.aws.fms.kotlin.inputs.PolicyIncludeMapArgsBuilder
import com.pulumi.aws.fms.kotlin.inputs.PolicySecurityServicePolicyDataArgs
import com.pulumi.aws.fms.kotlin.inputs.PolicySecurityServicePolicyDataArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to create an AWS Firewall Manager policy. You need to be using AWS organizations and have enabled the Firewall Manager administrator account.
 * > **NOTE:** Due to limitations with testing, we provide it as best effort. If you find it useful, and have the ability to help test or notice issues, consider reaching out to us on GitHub.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleRuleGroup = new aws.wafregional.RuleGroup("example", {
 *     metricName: "WAFRuleGroupExample",
 *     name: "WAF-Rule-Group-Example",
 * });
 * const example = new aws.fms.Policy("example", {
 *     name: "FMS-Policy-Example",
 *     excludeResourceTags: false,
 *     remediationEnabled: false,
 *     resourceType: "AWS::ElasticLoadBalancingV2::LoadBalancer",
 *     securityServicePolicyData: {
 *         type: "WAF",
 *         managedServiceData: pulumi.jsonStringify({
 *             type: "WAF",
 *             ruleGroups: [{
 *                 id: exampleRuleGroup.id,
 *                 overrideAction: {
 *                     type: "COUNT",
 *                 },
 *             }],
 *             defaultAction: {
 *                 type: "BLOCK",
 *             },
 *             overrideCustomerWebACLAssociation: false,
 *         }),
 *     },
 *     tags: {
 *         Name: "example-fms-policy",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example_rule_group = aws.wafregional.RuleGroup("example",
 *     metric_name="WAFRuleGroupExample",
 *     name="WAF-Rule-Group-Example")
 * example = aws.fms.Policy("example",
 *     name="FMS-Policy-Example",
 *     exclude_resource_tags=False,
 *     remediation_enabled=False,
 *     resource_type="AWS::ElasticLoadBalancingV2::LoadBalancer",
 *     security_service_policy_data={
 *         "type": "WAF",
 *         "managed_service_data": pulumi.Output.json_dumps({
 *             "type": "WAF",
 *             "rule_groups": [{
 *                 "id": example_rule_group.id,
 *                 "override_action": {
 *                     "type": "COUNT",
 *                 },
 *             }],
 *             "default_action": {
 *                 "type": "BLOCK",
 *             },
 *             "override_customer_web_aclassociation": False,
 *         }),
 *     },
 *     tags={
 *         "Name": "example-fms-policy",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleRuleGroup = new Aws.WafRegional.RuleGroup("example", new()
 *     {
 *         MetricName = "WAFRuleGroupExample",
 *         Name = "WAF-Rule-Group-Example",
 *     });
 *     var example = new Aws.Fms.Policy("example", new()
 *     {
 *         Name = "FMS-Policy-Example",
 *         ExcludeResourceTags = false,
 *         RemediationEnabled = false,
 *         ResourceType = "AWS::ElasticLoadBalancingV2::LoadBalancer",
 *         SecurityServicePolicyData = new Aws.Fms.Inputs.PolicySecurityServicePolicyDataArgs
 *         {
 *             Type = "WAF",
 *             ManagedServiceData = Output.JsonSerialize(Output.Create(new Dictionary<string, object?>
 *             {
 *                 ["type"] = "WAF",
 *                 ["ruleGroups"] = new[]
 *                 {
 *                     new Dictionary<string, object?>
 *                     {
 *                         ["id"] = exampleRuleGroup.Id,
 *                         ["overrideAction"] = new Dictionary<string, object?>
 *                         {
 *                             ["type"] = "COUNT",
 *                         },
 *                     },
 *                 },
 *                 ["defaultAction"] = new Dictionary<string, object?>
 *                 {
 *                     ["type"] = "BLOCK",
 *                 },
 *                 ["overrideCustomerWebACLAssociation"] = false,
 *             })),
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-fms-policy" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fms"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/wafregional"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleRuleGroup, err := wafregional.NewRuleGroup(ctx, "example", &wafregional.RuleGroupArgs{
 * 			MetricName: pulumi.String("WAFRuleGroupExample"),
 * 			Name:       pulumi.String("WAF-Rule-Group-Example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fms.NewPolicy(ctx, "example", &fms.PolicyArgs{
 * 			Name:                pulumi.String("FMS-Policy-Example"),
 * 			ExcludeResourceTags: pulumi.Bool(false),
 * 			RemediationEnabled:  pulumi.Bool(false),
 * 			ResourceType:        pulumi.String("AWS::ElasticLoadBalancingV2::LoadBalancer"),
 * 			SecurityServicePolicyData: &fms.PolicySecurityServicePolicyDataArgs{
 * 				Type: pulumi.String("WAF"),
 * 				ManagedServiceData: exampleRuleGroup.ID().ApplyT(func(id string) (pulumi.String, error) {
 * 					var _zero pulumi.String
 * 					tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 						"type": "WAF",
 * 						"ruleGroups": []map[string]interface{}{
 * 							map[string]interface{}{
 * 								"id": id,
 * 								"overrideAction": map[string]interface{}{
 * 									"type": "COUNT",
 * 								},
 * 							},
 * 						},
 * 						"defaultAction": map[string]interface{}{
 * 							"type": "BLOCK",
 * 						},
 * 						"overrideCustomerWebACLAssociation": false,
 * 					})
 * 					if err != nil {
 * 						return _zero, err
 * 					}
 * 					json0 := string(tmpJSON0)
 * 					return pulumi.String(json0), nil
 * 				}).(pulumi.StringOutput),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-fms-policy"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.wafregional.RuleGroup;
 * import com.pulumi.aws.wafregional.RuleGroupArgs;
 * import com.pulumi.aws.fms.Policy;
 * import com.pulumi.aws.fms.PolicyArgs;
 * import com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleRuleGroup = new RuleGroup("exampleRuleGroup", RuleGroupArgs.builder()
 *             .metricName("WAFRuleGroupExample")
 *             .name("WAF-Rule-Group-Example")
 *             .build());
 *         var example = new Policy("example", PolicyArgs.builder()
 *             .name("FMS-Policy-Example")
 *             .excludeResourceTags(false)
 *             .remediationEnabled(false)
 *             .resourceType("AWS::ElasticLoadBalancingV2::LoadBalancer")
 *             .securityServicePolicyData(PolicySecurityServicePolicyDataArgs.builder()
 *                 .type("WAF")
 *                 .managedServiceData(exampleRuleGroup.id().applyValue(id -> serializeJson(
 *                     jsonObject(
 *                         jsonProperty("type", "WAF"),
 *                         jsonProperty("ruleGroups", jsonArray(jsonObject(
 *                             jsonProperty("id", id),
 *                             jsonProperty("overrideAction", jsonObject(
 *                                 jsonProperty("type", "COUNT")
 *                             ))
 *                         ))),
 *                         jsonProperty("defaultAction", jsonObject(
 *                             jsonProperty("type", "BLOCK")
 *                         )),
 *                         jsonProperty("overrideCustomerWebACLAssociation", false)
 *                     ))))
 *                 .build())
 *             .tags(Map.of("Name", "example-fms-policy"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fms:Policy
 *     properties:
 *       name: FMS-Policy-Example
 *       excludeResourceTags: false
 *       remediationEnabled: false
 *       resourceType: AWS::ElasticLoadBalancingV2::LoadBalancer
 *       securityServicePolicyData:
 *         type: WAF
 *         managedServiceData:
 *           fn::toJSON:
 *             type: WAF
 *             ruleGroups:
 *               - id: ${exampleRuleGroup.id}
 *                 overrideAction:
 *                   type: COUNT
 *             defaultAction:
 *               type: BLOCK
 *             overrideCustomerWebACLAssociation: false
 *       tags:
 *         Name: example-fms-policy
 *   exampleRuleGroup:
 *     type: aws:wafregional:RuleGroup
 *     name: example
 *     properties:
 *       metricName: WAFRuleGroupExample
 *       name: WAF-Rule-Group-Example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Firewall Manager policies using the policy ID. For example:
 * ```sh
 * $ pulumi import aws:fms/policy:Policy example 5be49585-a7e3-4c49-dde1-a179fe4a619a
 * ```
 * @property deleteAllPolicyResources If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
 * @property deleteUnusedFmManagedResources If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
 * @property description The description of the AWS Network Firewall firewall policy.
 * @property excludeMap A map of lists of accounts and OU's to exclude from the policy.
 * @property excludeResourceTags A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
 * @property includeMap A map of lists of accounts and OU's to include in the policy.
 * @property name The friendly name of the AWS Firewall Manager Policy.
 * @property remediationEnabled A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
 * @property resourceSetIds
 * @property resourceTags A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
 * @property resourceType A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
 * @property resourceTypeLists A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
 * @property securityServicePolicyData The objects to include in Security Service Policy Data. Documented below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
 */
public data class PolicyArgs(
    public val deleteAllPolicyResources: Output<Boolean>? = null,
    public val deleteUnusedFmManagedResources: Output<Boolean>? = null,
    public val description: Output<String>? = null,
    public val excludeMap: Output<PolicyExcludeMapArgs>? = null,
    public val excludeResourceTags: Output<Boolean>? = null,
    public val includeMap: Output<PolicyIncludeMapArgs>? = null,
    public val name: Output<String>? = null,
    public val remediationEnabled: Output<Boolean>? = null,
    public val resourceSetIds: Output<List<String>>? = null,
    public val resourceTags: Output<Map<String, String>>? = null,
    public val resourceType: Output<String>? = null,
    public val resourceTypeLists: Output<List<String>>? = null,
    public val securityServicePolicyData: Output<PolicySecurityServicePolicyDataArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fms.PolicyArgs> {
    override fun toJava(): com.pulumi.aws.fms.PolicyArgs = com.pulumi.aws.fms.PolicyArgs.builder()
        .deleteAllPolicyResources(deleteAllPolicyResources?.applyValue({ args0 -> args0 }))
        .deleteUnusedFmManagedResources(deleteUnusedFmManagedResources?.applyValue({ args0 -> args0 }))
        .description(description?.applyValue({ args0 -> args0 }))
        .excludeMap(excludeMap?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .excludeResourceTags(excludeResourceTags?.applyValue({ args0 -> args0 }))
        .includeMap(includeMap?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .name(name?.applyValue({ args0 -> args0 }))
        .remediationEnabled(remediationEnabled?.applyValue({ args0 -> args0 }))
        .resourceSetIds(resourceSetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .resourceTags(
            resourceTags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        )
        .resourceType(resourceType?.applyValue({ args0 -> args0 }))
        .resourceTypeLists(resourceTypeLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .securityServicePolicyData(
            securityServicePolicyData?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [PolicyArgs].
 */
@PulumiTagMarker
public class PolicyArgsBuilder internal constructor() {
    private var deleteAllPolicyResources: Output<Boolean>? = null

    private var deleteUnusedFmManagedResources: Output<Boolean>? = null

    private var description: Output<String>? = null

    private var excludeMap: Output<PolicyExcludeMapArgs>? = null

    private var excludeResourceTags: Output<Boolean>? = null

    private var includeMap: Output<PolicyIncludeMapArgs>? = null

    private var name: Output<String>? = null

    private var remediationEnabled: Output<Boolean>? = null

    private var resourceSetIds: Output<List<String>>? = null

    private var resourceTags: Output<Map<String, String>>? = null

    private var resourceType: Output<String>? = null

    private var resourceTypeLists: Output<List<String>>? = null

    private var securityServicePolicyData: Output<PolicySecurityServicePolicyDataArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
     */
    @JvmName("iqiovwprmmrtuihn")
    public suspend fun deleteAllPolicyResources(`value`: Output<Boolean>) {
        this.deleteAllPolicyResources = value
    }

    /**
     * @param value If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
     */
    @JvmName("tnxrsdhqcuhlwolo")
    public suspend fun deleteUnusedFmManagedResources(`value`: Output<Boolean>) {
        this.deleteUnusedFmManagedResources = value
    }

    /**
     * @param value The description of the AWS Network Firewall firewall policy.
     */
    @JvmName("vpuhfaiiendfijbx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A map of lists of accounts and OU's to exclude from the policy.
     */
    @JvmName("hjdcvlhblsiswvmk")
    public suspend fun excludeMap(`value`: Output<PolicyExcludeMapArgs>) {
        this.excludeMap = value
    }

    /**
     * @param value A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
     */
    @JvmName("oajltljglvamsmyc")
    public suspend fun excludeResourceTags(`value`: Output<Boolean>) {
        this.excludeResourceTags = value
    }

    /**
     * @param value A map of lists of accounts and OU's to include in the policy.
     */
    @JvmName("hytmxksijdabftxb")
    public suspend fun includeMap(`value`: Output<PolicyIncludeMapArgs>) {
        this.includeMap = value
    }

    /**
     * @param value The friendly name of the AWS Firewall Manager Policy.
     */
    @JvmName("utxapmjcikifnpqd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
     */
    @JvmName("eriyfsmirkrcdess")
    public suspend fun remediationEnabled(`value`: Output<Boolean>) {
        this.remediationEnabled = value
    }

    /**
     * @param value
     */
    @JvmName("eedmfurrktidfbpq")
    public suspend fun resourceSetIds(`value`: Output<List<String>>) {
        this.resourceSetIds = value
    }

    @JvmName("ocxnpsgttykagxmr")
    public suspend fun resourceSetIds(vararg values: Output<String>) {
        this.resourceSetIds = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("ylovwphvmhvoytut")
    public suspend fun resourceSetIds(values: List<Output<String>>) {
        this.resourceSetIds = Output.all(values)
    }

    /**
     * @param value A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
     */
    @JvmName("rttsnoemwfthqpdx")
    public suspend fun resourceTags(`value`: Output<Map<String, String>>) {
        this.resourceTags = value
    }

    /**
     * @param value A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
     */
    @JvmName("rvrjvevxccjdqawi")
    public suspend fun resourceType(`value`: Output<String>) {
        this.resourceType = value
    }

    /**
     * @param value A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
     */
    @JvmName("fqmhwcipcliosrkf")
    public suspend fun resourceTypeLists(`value`: Output<List<String>>) {
        this.resourceTypeLists = value
    }

    @JvmName("drfwimowmryeirpe")
    public suspend fun resourceTypeLists(vararg values: Output<String>) {
        this.resourceTypeLists = Output.all(values.asList())
    }

    /**
     * @param values A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
     */
    @JvmName("dvshnugpjmbtlnlu")
    public suspend fun resourceTypeLists(values: List<Output<String>>) {
        this.resourceTypeLists = Output.all(values)
    }

    /**
     * @param value The objects to include in Security Service Policy Data. Documented below.
     */
    @JvmName("ceatnjvutmbdkfbm")
    public suspend fun securityServicePolicyData(`value`: Output<PolicySecurityServicePolicyDataArgs>) {
        this.securityServicePolicyData = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("wiipjbtexivcsjpo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value If true, the request will also perform a clean-up process. Defaults to `true`. More information can be found here [AWS Firewall Manager delete policy](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_DeletePolicy.html)
     */
    @JvmName("bqurvpoqdanupklx")
    public suspend fun deleteAllPolicyResources(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteAllPolicyResources = mapped
    }

    /**
     * @param value If true, Firewall Manager will automatically remove protections from resources that leave the policy scope. Defaults to `false`. More information can be found here [AWS Firewall Manager policy contents](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html)
     */
    @JvmName("nrvtybkcwkcweleq")
    public suspend fun deleteUnusedFmManagedResources(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteUnusedFmManagedResources = mapped
    }

    /**
     * @param value The description of the AWS Network Firewall firewall policy.
     */
    @JvmName("miwxqiwpyqenjhiw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A map of lists of accounts and OU's to exclude from the policy.
     */
    @JvmName("iwfraixbtfxvuiqt")
    public suspend fun excludeMap(`value`: PolicyExcludeMapArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeMap = mapped
    }

    /**
     * @param argument A map of lists of accounts and OU's to exclude from the policy.
     */
    @JvmName("wujyhacolcyckqdx")
    public suspend fun excludeMap(argument: suspend PolicyExcludeMapArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyExcludeMapArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.excludeMap = mapped
    }

    /**
     * @param value A boolean value, if true the tags that are specified in the `resource_tags` are not protected by this policy. If set to false and resource_tags are populated, resources that contain tags will be protected by this policy.
     */
    @JvmName("qvbfinswxvkeehoh")
    public suspend fun excludeResourceTags(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludeResourceTags = mapped
    }

    /**
     * @param value A map of lists of accounts and OU's to include in the policy.
     */
    @JvmName("friatmhvrtqwiatx")
    public suspend fun includeMap(`value`: PolicyIncludeMapArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includeMap = mapped
    }

    /**
     * @param argument A map of lists of accounts and OU's to include in the policy.
     */
    @JvmName("pbiaeqxaqlcolbcw")
    public suspend fun includeMap(argument: suspend PolicyIncludeMapArgsBuilder.() -> Unit) {
        val toBeMapped = PolicyIncludeMapArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.includeMap = mapped
    }

    /**
     * @param value The friendly name of the AWS Firewall Manager Policy.
     */
    @JvmName("dfqtrpitddxjnxbt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A boolean value, indicates if the policy should automatically applied to resources that already exist in the account.
     */
    @JvmName("yafugwimnmuurapb")
    public suspend fun remediationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remediationEnabled = mapped
    }

    /**
     * @param value
     */
    @JvmName("rsdbmbgatowrwxua")
    public suspend fun resourceSetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSetIds = mapped
    }

    /**
     * @param values
     */
    @JvmName("nfujlnuppwulcryv")
    public suspend fun resourceSetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceSetIds = mapped
    }

    /**
     * @param value A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
     */
    @JvmName("pwadgtdyjwjkhyrj")
    public suspend fun resourceTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param values A map of resource tags, that if present will filter protections on resources based on the exclude_resource_tags.
     */
    @JvmName("eagimefcouqgywrb")
    public fun resourceTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTags = mapped
    }

    /**
     * @param value A resource type to protect. Conflicts with `resource_type_list`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values.
     */
    @JvmName("cpconwfhsokalirn")
    public suspend fun resourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceType = mapped
    }

    /**
     * @param value A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
     */
    @JvmName("tjtxdmvcxocfalea")
    public suspend fun resourceTypeLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypeLists = mapped
    }

    /**
     * @param values A list of resource types to protect. Conflicts with `resource_type`. See the [FMS API Reference](https://docs.aws.amazon.com/fms/2018-01-01/APIReference/API_Policy.html#fms-Type-Policy-ResourceType) for more information about supported values. Lists with only one element are not supported, instead use `resource_type`.
     */
    @JvmName("xuhdtaocjknhxquc")
    public suspend fun resourceTypeLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypeLists = mapped
    }

    /**
     * @param value The objects to include in Security Service Policy Data. Documented below.
     */
    @JvmName("fjhrlkqehojyodpu")
    public suspend fun securityServicePolicyData(`value`: PolicySecurityServicePolicyDataArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityServicePolicyData = mapped
    }

    /**
     * @param argument The objects to include in Security Service Policy Data. Documented below.
     */
    @JvmName("dpecbckardfjcxbb")
    public suspend fun securityServicePolicyData(argument: suspend PolicySecurityServicePolicyDataArgsBuilder.() -> Unit) {
        val toBeMapped = PolicySecurityServicePolicyDataArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.securityServicePolicyData = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("nbobufvwnhptsawt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level
     */
    @JvmName("jnxtlisyafvykniw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): PolicyArgs = PolicyArgs(
        deleteAllPolicyResources = deleteAllPolicyResources,
        deleteUnusedFmManagedResources = deleteUnusedFmManagedResources,
        description = description,
        excludeMap = excludeMap,
        excludeResourceTags = excludeResourceTags,
        includeMap = includeMap,
        name = name,
        remediationEnabled = remediationEnabled,
        resourceSetIds = resourceSetIds,
        resourceTags = resourceTags,
        resourceType = resourceType,
        resourceTypeLists = resourceTypeLists,
        securityServicePolicyData = securityServicePolicyData,
        tags = tags,
    )
}
