@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin

import com.pulumi.aws.fms.kotlin.outputs.ResourceSetResourceSet
import com.pulumi.aws.fms.kotlin.outputs.ResourceSetTimeouts
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.fms.kotlin.outputs.ResourceSetResourceSet.Companion.toKotlin as resourceSetResourceSetToKotlin
import com.pulumi.aws.fms.kotlin.outputs.ResourceSetTimeouts.Companion.toKotlin as resourceSetTimeoutsToKotlin

/**
 * Builder for [ResourceSet].
 */
@PulumiTagMarker
public class ResourceSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ResourceSetArgs = ResourceSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ResourceSetArgsBuilder.() -> Unit) {
        val builder = ResourceSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ResourceSet {
        val builtJavaResource = com.pulumi.aws.fms.ResourceSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ResourceSet(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS FMS (Firewall Manager) Resource Set.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.fms.ResourceSet("example", {resourceSets: [{
 *     name: "testing",
 *     resourceTypeLists: ["AWS::NetworkFirewall::Firewall"],
 * }]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.fms.ResourceSet("example", resource_sets=[{
 *     "name": "testing",
 *     "resource_type_lists": ["AWS::NetworkFirewall::Firewall"],
 * }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Fms.ResourceSet("example", new()
 *     {
 *         ResourceSets = new[]
 *         {
 *             new Aws.Fms.Inputs.ResourceSetResourceSetArgs
 *             {
 *                 Name = "testing",
 *                 ResourceTypeLists = new[]
 *                 {
 *                     "AWS::NetworkFirewall::Firewall",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fms.NewResourceSet(ctx, "example", &fms.ResourceSetArgs{
 * 			ResourceSets: fms.ResourceSetResourceSetArray{
 * 				&fms.ResourceSetResourceSetArgs{
 * 					Name: pulumi.String("testing"),
 * 					ResourceTypeLists: pulumi.StringArray{
 * 						pulumi.String("AWS::NetworkFirewall::Firewall"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fms.ResourceSet;
 * import com.pulumi.aws.fms.ResourceSetArgs;
 * import com.pulumi.aws.fms.inputs.ResourceSetResourceSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceSet("example", ResourceSetArgs.builder()
 *             .resourceSets(ResourceSetResourceSetArgs.builder()
 *                 .name("testing")
 *                 .resourceTypeLists("AWS::NetworkFirewall::Firewall")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fms:ResourceSet
 *     properties:
 *       resourceSets:
 *         - name: testing
 *           resourceTypeLists:
 *             - AWS::NetworkFirewall::Firewall
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FMS (Firewall Manager) Resource Set using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fms/resourceSet:ResourceSet example resource_set-id-12345678
 * ```
 */
public class ResourceSet internal constructor(
    override val javaResource: com.pulumi.aws.fms.ResourceSet,
) : KotlinCustomResource(javaResource, ResourceSetMapper) {
    /**
     * ARN of the Resource Set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Details about the resource set to be created or updated. See `resource_set` Attribute Reference below.
     */
    public val resourceSets: Output<List<ResourceSetResourceSet>>?
        get() = javaResource.resourceSets().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> resourceSetResourceSetToKotlin(args0) })
                })
            }).orElse(null)
        })

    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<ResourceSetTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    resourceSetTimeoutsToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ResourceSetMapper : ResourceMapper<ResourceSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fms.ResourceSet::class == javaResource::class

    override fun map(javaResource: Resource): ResourceSet = ResourceSet(
        javaResource as
            com.pulumi.aws.fms.ResourceSet,
    )
}

/**
 * @see [ResourceSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ResourceSet].
 */
public suspend fun resourceSet(name: String, block: suspend ResourceSetResourceBuilder.() -> Unit): ResourceSet {
    val builder = ResourceSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ResourceSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun resourceSet(name: String): ResourceSet {
    val builder = ResourceSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
