@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin

import com.pulumi.aws.fms.ResourceSetArgs.builder
import com.pulumi.aws.fms.kotlin.inputs.ResourceSetResourceSetArgs
import com.pulumi.aws.fms.kotlin.inputs.ResourceSetResourceSetArgsBuilder
import com.pulumi.aws.fms.kotlin.inputs.ResourceSetTimeoutsArgs
import com.pulumi.aws.fms.kotlin.inputs.ResourceSetTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS FMS (Firewall Manager) Resource Set.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.fms.ResourceSet("example", {resourceSets: [{
 *     name: "testing",
 *     resourceTypeLists: ["AWS::NetworkFirewall::Firewall"],
 * }]});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.fms.ResourceSet("example", resource_sets=[{
 *     "name": "testing",
 *     "resource_type_lists": ["AWS::NetworkFirewall::Firewall"],
 * }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Fms.ResourceSet("example", new()
 *     {
 *         ResourceSets = new[]
 *         {
 *             new Aws.Fms.Inputs.ResourceSetResourceSetArgs
 *             {
 *                 Name = "testing",
 *                 ResourceTypeLists = new[]
 *                 {
 *                     "AWS::NetworkFirewall::Firewall",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fms"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fms.NewResourceSet(ctx, "example", &fms.ResourceSetArgs{
 * 			ResourceSets: fms.ResourceSetResourceSetArray{
 * 				&fms.ResourceSetResourceSetArgs{
 * 					Name: pulumi.String("testing"),
 * 					ResourceTypeLists: pulumi.StringArray{
 * 						pulumi.String("AWS::NetworkFirewall::Firewall"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fms.ResourceSet;
 * import com.pulumi.aws.fms.ResourceSetArgs;
 * import com.pulumi.aws.fms.inputs.ResourceSetResourceSetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new ResourceSet("example", ResourceSetArgs.builder()
 *             .resourceSets(ResourceSetResourceSetArgs.builder()
 *                 .name("testing")
 *                 .resourceTypeLists("AWS::NetworkFirewall::Firewall")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fms:ResourceSet
 *     properties:
 *       resourceSets:
 *         - name: testing
 *           resourceTypeLists:
 *             - AWS::NetworkFirewall::Firewall
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FMS (Firewall Manager) Resource Set using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fms/resourceSet:ResourceSet example resource_set-id-12345678
 * ```
 * @property resourceSets Details about the resource set to be created or updated. See `resource_set` Attribute Reference below.
 * @property tags
 * @property timeouts
 */
public data class ResourceSetArgs(
    public val resourceSets: Output<List<ResourceSetResourceSetArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<ResourceSetTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.fms.ResourceSetArgs> {
    override fun toJava(): com.pulumi.aws.fms.ResourceSetArgs =
        com.pulumi.aws.fms.ResourceSetArgs.builder()
            .resourceSets(
                resourceSets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourceSetArgs].
 */
@PulumiTagMarker
public class ResourceSetArgsBuilder internal constructor() {
    private var resourceSets: Output<List<ResourceSetResourceSetArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<ResourceSetTimeoutsArgs>? = null

    /**
     * @param value Details about the resource set to be created or updated. See `resource_set` Attribute Reference below.
     */
    @JvmName("vitgkgdabjrglahb")
    public suspend fun resourceSets(`value`: Output<List<ResourceSetResourceSetArgs>>) {
        this.resourceSets = value
    }

    @JvmName("hognxlwetjkktojk")
    public suspend fun resourceSets(vararg values: Output<ResourceSetResourceSetArgs>) {
        this.resourceSets = Output.all(values.asList())
    }

    /**
     * @param values Details about the resource set to be created or updated. See `resource_set` Attribute Reference below.
     */
    @JvmName("uckbkixnylutfhhm")
    public suspend fun resourceSets(values: List<Output<ResourceSetResourceSetArgs>>) {
        this.resourceSets = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("avihpnccscdedhve")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("wsaagguebweyeuri")
    public suspend fun timeouts(`value`: Output<ResourceSetTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value Details about the resource set to be created or updated. See `resource_set` Attribute Reference below.
     */
    @JvmName("dtwbambhiwjkefst")
    public suspend fun resourceSets(`value`: List<ResourceSetResourceSetArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSets = mapped
    }

    /**
     * @param argument Details about the resource set to be created or updated. See `resource_set` Attribute Reference below.
     */
    @JvmName("dcmsaemreojovvkc")
    public suspend fun resourceSets(argument: List<suspend ResourceSetResourceSetArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ResourceSetResourceSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceSets = mapped
    }

    /**
     * @param argument Details about the resource set to be created or updated. See `resource_set` Attribute Reference below.
     */
    @JvmName("klbnvhosjjqwhiso")
    public suspend fun resourceSets(vararg argument: suspend ResourceSetResourceSetArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ResourceSetResourceSetArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.resourceSets = mapped
    }

    /**
     * @param argument Details about the resource set to be created or updated. See `resource_set` Attribute Reference below.
     */
    @JvmName("noaowfyoytoddloj")
    public suspend fun resourceSets(argument: suspend ResourceSetResourceSetArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ResourceSetResourceSetArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.resourceSets = mapped
    }

    /**
     * @param values Details about the resource set to be created or updated. See `resource_set` Attribute Reference below.
     */
    @JvmName("fdxhcpxwoptnuvcs")
    public suspend fun resourceSets(vararg values: ResourceSetResourceSetArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceSets = mapped
    }

    /**
     * @param value
     */
    @JvmName("yvrbgpeavooohkhq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("giysijnlhjyndqkq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("vxajiblknltwqtwn")
    public suspend fun timeouts(`value`: ResourceSetTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qodwxacsbsigsxwb")
    public suspend fun timeouts(argument: suspend ResourceSetTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceSetTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): ResourceSetArgs = ResourceSetArgs(
        resourceSets = resourceSets,
        tags = tags,
        timeouts = timeouts,
    )
}
