@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin.inputs

import com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallDeploymentModel Defines the deployment model to use for the third-party firewall policy. Valid values are `CENTRALIZED` and `DISTRIBUTED`.
 */
public data class PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs(
    public val firewallDeploymentModel: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs> {
    override fun toJava(): com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs =
        com.pulumi.aws.fms.inputs.PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs.builder()
            .firewallDeploymentModel(firewallDeploymentModel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs].
 */
@PulumiTagMarker
public class PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgsBuilder internal constructor() {
    private var firewallDeploymentModel: Output<String>? = null

    /**
     * @param value Defines the deployment model to use for the third-party firewall policy. Valid values are `CENTRALIZED` and `DISTRIBUTED`.
     */
    @JvmName("kkhunftooxknvloo")
    public suspend fun firewallDeploymentModel(`value`: Output<String>) {
        this.firewallDeploymentModel = value
    }

    /**
     * @param value Defines the deployment model to use for the third-party firewall policy. Valid values are `CENTRALIZED` and `DISTRIBUTED`.
     */
    @JvmName("bvpavqkauepwoxuf")
    public suspend fun firewallDeploymentModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallDeploymentModel = mapped
    }

    internal fun build(): PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs =
        PolicySecurityServicePolicyDataPolicyOptionThirdPartyFirewallPolicyArgs(
            firewallDeploymentModel = firewallDeploymentModel,
        )
}
