@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin.inputs

import com.pulumi.aws.fms.inputs.ResourceSetResourceSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property description Description of the resource set.
 * @property id Unique identifier for the resource set. It's returned in the responses to create and list commands. You provide it to operations like update and delete.
 * @property lastUpdateTime Last time that the reosurce set was changed.
 * @property name Descriptive name of the resource set. You can't change the name of a resource set after you create it.
 * @property resourceSetStatus Indicates whether the resource set is in or out of the admin's Region scope. Valid values are `ACTIVE` (Admin can manage and delete the resource set) or `OUT_OF_ADMIN_SCOPE` (Admin can view the resource set, but theyy can't edit or delete the resource set.)
 * @property resourceTypeLists Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.
 * @property updateToken
 */
public data class ResourceSetResourceSetArgs(
    public val description: Output<String>? = null,
    public val id: Output<String>? = null,
    public val lastUpdateTime: Output<String>? = null,
    public val name: Output<String>,
    public val resourceSetStatus: Output<String>? = null,
    public val resourceTypeLists: Output<List<String>>? = null,
    public val updateToken: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fms.inputs.ResourceSetResourceSetArgs> {
    override fun toJava(): com.pulumi.aws.fms.inputs.ResourceSetResourceSetArgs =
        com.pulumi.aws.fms.inputs.ResourceSetResourceSetArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .lastUpdateTime(lastUpdateTime?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .resourceSetStatus(resourceSetStatus?.applyValue({ args0 -> args0 }))
            .resourceTypeLists(resourceTypeLists?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .updateToken(updateToken?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceSetResourceSetArgs].
 */
@PulumiTagMarker
public class ResourceSetResourceSetArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var id: Output<String>? = null

    private var lastUpdateTime: Output<String>? = null

    private var name: Output<String>? = null

    private var resourceSetStatus: Output<String>? = null

    private var resourceTypeLists: Output<List<String>>? = null

    private var updateToken: Output<String>? = null

    /**
     * @param value Description of the resource set.
     */
    @JvmName("kpbybbimaqqqisjh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Unique identifier for the resource set. It's returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    @JvmName("udcuqfuogjloeqns")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Last time that the reosurce set was changed.
     */
    @JvmName("spkmhdvqtjhaluaf")
    public suspend fun lastUpdateTime(`value`: Output<String>) {
        this.lastUpdateTime = value
    }

    /**
     * @param value Descriptive name of the resource set. You can't change the name of a resource set after you create it.
     */
    @JvmName("ehrdddfynlmhqdjk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicates whether the resource set is in or out of the admin's Region scope. Valid values are `ACTIVE` (Admin can manage and delete the resource set) or `OUT_OF_ADMIN_SCOPE` (Admin can view the resource set, but theyy can't edit or delete the resource set.)
     */
    @JvmName("awvmbckylqqyhpse")
    public suspend fun resourceSetStatus(`value`: Output<String>) {
        this.resourceSetStatus = value
    }

    /**
     * @param value Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.
     */
    @JvmName("gcsvdqcfajguiwxi")
    public suspend fun resourceTypeLists(`value`: Output<List<String>>) {
        this.resourceTypeLists = value
    }

    @JvmName("lakyaghwsjiqluhm")
    public suspend fun resourceTypeLists(vararg values: Output<String>) {
        this.resourceTypeLists = Output.all(values.asList())
    }

    /**
     * @param values Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.
     */
    @JvmName("ggtpnxnrcirvuhaj")
    public suspend fun resourceTypeLists(values: List<Output<String>>) {
        this.resourceTypeLists = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("nqvayxdpvkkhnxsn")
    public suspend fun updateToken(`value`: Output<String>) {
        this.updateToken = value
    }

    /**
     * @param value Description of the resource set.
     */
    @JvmName("gesphicoegqprcam")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Unique identifier for the resource set. It's returned in the responses to create and list commands. You provide it to operations like update and delete.
     */
    @JvmName("pcsmnprdpsqraqha")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Last time that the reosurce set was changed.
     */
    @JvmName("pwhwxpsdowqvwmjf")
    public suspend fun lastUpdateTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastUpdateTime = mapped
    }

    /**
     * @param value Descriptive name of the resource set. You can't change the name of a resource set after you create it.
     */
    @JvmName("iyncbfyctvcfjqqo")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicates whether the resource set is in or out of the admin's Region scope. Valid values are `ACTIVE` (Admin can manage and delete the resource set) or `OUT_OF_ADMIN_SCOPE` (Admin can view the resource set, but theyy can't edit or delete the resource set.)
     */
    @JvmName("uydpdaeepssrekiw")
    public suspend fun resourceSetStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceSetStatus = mapped
    }

    /**
     * @param value Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.
     */
    @JvmName("yocpwldrqxcumntv")
    public suspend fun resourceTypeLists(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceTypeLists = mapped
    }

    /**
     * @param values Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.
     */
    @JvmName("umcxjyggknmgudyq")
    public suspend fun resourceTypeLists(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceTypeLists = mapped
    }

    /**
     * @param value
     */
    @JvmName("qkvdrqrxhsmpcoyj")
    public suspend fun updateToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.updateToken = mapped
    }

    internal fun build(): ResourceSetResourceSetArgs = ResourceSetResourceSetArgs(
        description = description,
        id = id,
        lastUpdateTime = lastUpdateTime,
        name = name ?: throw PulumiNullFieldException("name"),
        resourceSetStatus = resourceSetStatus,
        resourceTypeLists = resourceTypeLists,
        updateToken = updateToken,
    )
}
