@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description Description of the resource set.
 * @property id Unique identifier for the resource set. It's returned in the responses to create and list commands. You provide it to operations like update and delete.
 * @property lastUpdateTime Last time that the reosurce set was changed.
 * @property name Descriptive name of the resource set. You can't change the name of a resource set after you create it.
 * @property resourceSetStatus Indicates whether the resource set is in or out of the admin's Region scope. Valid values are `ACTIVE` (Admin can manage and delete the resource set) or `OUT_OF_ADMIN_SCOPE` (Admin can view the resource set, but theyy can't edit or delete the resource set.)
 * @property resourceTypeLists Determines the resources that can be associated to the resource set. Depending on your setting for max results and the number of resource sets, a single call might not return the full list.
 * @property updateToken
 */
public data class ResourceSetResourceSet(
    public val description: String? = null,
    public val id: String? = null,
    public val lastUpdateTime: String? = null,
    public val name: String,
    public val resourceSetStatus: String? = null,
    public val resourceTypeLists: List<String>? = null,
    public val updateToken: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fms.outputs.ResourceSetResourceSet): ResourceSetResourceSet = ResourceSetResourceSet(
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            lastUpdateTime = javaType.lastUpdateTime().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            resourceSetStatus = javaType.resourceSetStatus().map({ args0 -> args0 }).orElse(null),
            resourceTypeLists = javaType.resourceTypeLists().map({ args0 -> args0 }),
            updateToken = javaType.updateToken().map({ args0 -> args0 }).orElse(null),
        )
    }
}
