@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.kotlin.outputs.DataRepositoryAssociationS3
import com.pulumi.aws.fsx.kotlin.outputs.DataRepositoryAssociationS3.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [DataRepositoryAssociation].
 */
@PulumiTagMarker
public class DataRepositoryAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataRepositoryAssociationArgs = DataRepositoryAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataRepositoryAssociationArgsBuilder.() -> Unit) {
        val builder = DataRepositoryAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataRepositoryAssociation {
        val builtJavaResource = com.pulumi.aws.fsx.DataRepositoryAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataRepositoryAssociation(builtJavaResource)
    }
}

/**
 * Manages a FSx for Lustre Data Repository Association. See [Linking your file system to an S3 bucket](https://docs.aws.amazon.com/fsx/latest/LustreGuide/create-dra-linked-data-repo.html) for more information.
 * > **NOTE:** Data Repository Associations are only compatible with AWS FSx for Lustre File Systems and `PERSISTENT_2` deployment type.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.s3.BucketV2("example", {bucket: "my-bucket"});
 * const exampleBucketAclV2 = new aws.s3.BucketAclV2("example", {
 *     bucket: example.id,
 *     acl: "private",
 * });
 * const exampleLustreFileSystem = new aws.fsx.LustreFileSystem("example", {
 *     storageCapacity: 1200,
 *     subnetIds: exampleAwsSubnet.id,
 *     deploymentType: "PERSISTENT_2",
 *     perUnitStorageThroughput: 125,
 * });
 * const exampleDataRepositoryAssociation = new aws.fsx.DataRepositoryAssociation("example", {
 *     fileSystemId: exampleLustreFileSystem.id,
 *     dataRepositoryPath: pulumi.interpolate`s3://${example.id}`,
 *     fileSystemPath: "/my-bucket",
 *     s3: {
 *         autoExportPolicy: {
 *             events: [
 *                 "NEW",
 *                 "CHANGED",
 *                 "DELETED",
 *             ],
 *         },
 *         autoImportPolicy: {
 *             events: [
 *                 "NEW",
 *                 "CHANGED",
 *                 "DELETED",
 *             ],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.s3.BucketV2("example", bucket="my-bucket")
 * example_bucket_acl_v2 = aws.s3.BucketAclV2("example",
 *     bucket=example.id,
 *     acl="private")
 * example_lustre_file_system = aws.fsx.LustreFileSystem("example",
 *     storage_capacity=1200,
 *     subnet_ids=example_aws_subnet["id"],
 *     deployment_type="PERSISTENT_2",
 *     per_unit_storage_throughput=125)
 * example_data_repository_association = aws.fsx.DataRepositoryAssociation("example",
 *     file_system_id=example_lustre_file_system.id,
 *     data_repository_path=example.id.apply(lambda id: f"s3://{id}"),
 *     file_system_path="/my-bucket",
 *     s3={
 *         "auto_export_policy": {
 *             "events": [
 *                 "NEW",
 *                 "CHANGED",
 *                 "DELETED",
 *             ],
 *         },
 *         "auto_import_policy": {
 *             "events": [
 *                 "NEW",
 *                 "CHANGED",
 *                 "DELETED",
 *             ],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.S3.BucketV2("example", new()
 *     {
 *         Bucket = "my-bucket",
 *     });
 *     var exampleBucketAclV2 = new Aws.S3.BucketAclV2("example", new()
 *     {
 *         Bucket = example.Id,
 *         Acl = "private",
 *     });
 *     var exampleLustreFileSystem = new Aws.Fsx.LustreFileSystem("example", new()
 *     {
 *         StorageCapacity = 1200,
 *         SubnetIds = exampleAwsSubnet.Id,
 *         DeploymentType = "PERSISTENT_2",
 *         PerUnitStorageThroughput = 125,
 *     });
 *     var exampleDataRepositoryAssociation = new Aws.Fsx.DataRepositoryAssociation("example", new()
 *     {
 *         FileSystemId = exampleLustreFileSystem.Id,
 *         DataRepositoryPath = example.Id.Apply(id => $"s3://{id}"),
 *         FileSystemPath = "/my-bucket",
 *         S3 = new Aws.Fsx.Inputs.DataRepositoryAssociationS3Args
 *         {
 *             AutoExportPolicy = new Aws.Fsx.Inputs.DataRepositoryAssociationS3AutoExportPolicyArgs
 *             {
 *                 Events = new[]
 *                 {
 *                     "NEW",
 *                     "CHANGED",
 *                     "DELETED",
 *                 },
 *             },
 *             AutoImportPolicy = new Aws.Fsx.Inputs.DataRepositoryAssociationS3AutoImportPolicyArgs
 *             {
 *                 Events = new[]
 *                 {
 *                     "NEW",
 *                     "CHANGED",
 *                     "DELETED",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"fmt"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/s3"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := s3.NewBucketV2(ctx, "example", &s3.BucketV2Args{
 * 			Bucket: pulumi.String("my-bucket"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = s3.NewBucketAclV2(ctx, "example", &s3.BucketAclV2Args{
 * 			Bucket: example.ID(),
 * 			Acl:    pulumi.String("private"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleLustreFileSystem, err := fsx.NewLustreFileSystem(ctx, "example", &fsx.LustreFileSystemArgs{
 * 			StorageCapacity:          pulumi.Int(1200),
 * 			SubnetIds:                pulumi.Any(exampleAwsSubnet.Id),
 * 			DeploymentType:           pulumi.String("PERSISTENT_2"),
 * 			PerUnitStorageThroughput: pulumi.Int(125),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fsx.NewDataRepositoryAssociation(ctx, "example", &fsx.DataRepositoryAssociationArgs{
 * 			FileSystemId: exampleLustreFileSystem.ID(),
 * 			DataRepositoryPath: example.ID().ApplyT(func(id string) (string, error) {
 * 				return fmt.Sprintf("s3://%v", id), nil
 * 			}).(pulumi.StringOutput),
 * 			FileSystemPath: pulumi.String("/my-bucket"),
 * 			S3: &fsx.DataRepositoryAssociationS3Args{
 * 				AutoExportPolicy: &fsx.DataRepositoryAssociationS3AutoExportPolicyArgs{
 * 					Events: pulumi.StringArray{
 * 						pulumi.String("NEW"),
 * 						pulumi.String("CHANGED"),
 * 						pulumi.String("DELETED"),
 * 					},
 * 				},
 * 				AutoImportPolicy: &fsx.DataRepositoryAssociationS3AutoImportPolicyArgs{
 * 					Events: pulumi.StringArray{
 * 						pulumi.String("NEW"),
 * 						pulumi.String("CHANGED"),
 * 						pulumi.String("DELETED"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.s3.BucketV2;
 * import com.pulumi.aws.s3.BucketV2Args;
 * import com.pulumi.aws.s3.BucketAclV2;
 * import com.pulumi.aws.s3.BucketAclV2Args;
 * import com.pulumi.aws.fsx.LustreFileSystem;
 * import com.pulumi.aws.fsx.LustreFileSystemArgs;
 * import com.pulumi.aws.fsx.DataRepositoryAssociation;
 * import com.pulumi.aws.fsx.DataRepositoryAssociationArgs;
 * import com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3Args;
 * import com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3AutoExportPolicyArgs;
 * import com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3AutoImportPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new BucketV2("example", BucketV2Args.builder()
 *             .bucket("my-bucket")
 *             .build());
 *         var exampleBucketAclV2 = new BucketAclV2("exampleBucketAclV2", BucketAclV2Args.builder()
 *             .bucket(example.id())
 *             .acl("private")
 *             .build());
 *         var exampleLustreFileSystem = new LustreFileSystem("exampleLustreFileSystem", LustreFileSystemArgs.builder()
 *             .storageCapacity(1200)
 *             .subnetIds(exampleAwsSubnet.id())
 *             .deploymentType("PERSISTENT_2")
 *             .perUnitStorageThroughput(125)
 *             .build());
 *         var exampleDataRepositoryAssociation = new DataRepositoryAssociation("exampleDataRepositoryAssociation", DataRepositoryAssociationArgs.builder()
 *             .fileSystemId(exampleLustreFileSystem.id())
 *             .dataRepositoryPath(example.id().applyValue(id -> String.format("s3://%s", id)))
 *             .fileSystemPath("/my-bucket")
 *             .s3(DataRepositoryAssociationS3Args.builder()
 *                 .autoExportPolicy(DataRepositoryAssociationS3AutoExportPolicyArgs.builder()
 *                     .events(
 *                         "NEW",
 *                         "CHANGED",
 *                         "DELETED")
 *                     .build())
 *                 .autoImportPolicy(DataRepositoryAssociationS3AutoImportPolicyArgs.builder()
 *                     .events(
 *                         "NEW",
 *                         "CHANGED",
 *                         "DELETED")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:s3:BucketV2
 *     properties:
 *       bucket: my-bucket
 *   exampleBucketAclV2:
 *     type: aws:s3:BucketAclV2
 *     name: example
 *     properties:
 *       bucket: ${example.id}
 *       acl: private
 *   exampleLustreFileSystem:
 *     type: aws:fsx:LustreFileSystem
 *     name: example
 *     properties:
 *       storageCapacity: 1200
 *       subnetIds: ${exampleAwsSubnet.id}
 *       deploymentType: PERSISTENT_2
 *       perUnitStorageThroughput: 125
 *   exampleDataRepositoryAssociation:
 *     type: aws:fsx:DataRepositoryAssociation
 *     name: example
 *     properties:
 *       fileSystemId: ${exampleLustreFileSystem.id}
 *       dataRepositoryPath: s3://${example.id}
 *       fileSystemPath: /my-bucket
 *       s3:
 *         autoExportPolicy:
 *           events:
 *             - NEW
 *             - CHANGED
 *             - DELETED
 *         autoImportPolicy:
 *           events:
 *             - NEW
 *             - CHANGED
 *             - DELETED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx Data Repository Associations using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/dataRepositoryAssociation:DataRepositoryAssociation example dra-0b1cfaeca11088b10
 * ```
 */
public class DataRepositoryAssociation internal constructor(
    override val javaResource: com.pulumi.aws.fsx.DataRepositoryAssociation,
) : KotlinCustomResource(javaResource, DataRepositoryAssociationMapper) {
    /**
     * Amazon Resource Name of the file system.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val associationId: Output<String>
        get() = javaResource.associationId().applyValue({ args0 -> args0 })

    /**
     * Set to true to run an import data repository task to import metadata from the data repository to the file system after the data repository association is created. Defaults to `false`.
     */
    public val batchImportMetaDataOnCreate: Output<Boolean>?
        get() = javaResource.batchImportMetaDataOnCreate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The path to the Amazon S3 data repository that will be linked to the file system. The path must be an S3 bucket s3://myBucket/myPrefix/. This path specifies where in the S3 data repository files will be imported from or exported to. The same S3 bucket cannot be linked more than once to the same file system.
     */
    public val dataRepositoryPath: Output<String>
        get() = javaResource.dataRepositoryPath().applyValue({ args0 -> args0 })

    /**
     * Set to true to delete files from the file system upon deleting this data repository association. Defaults to `false`.
     */
    public val deleteDataInFilesystem: Output<Boolean>?
        get() = javaResource.deleteDataInFilesystem().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the Amazon FSx file system to on which to create a data repository association.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * A path on the file system that points to a high-level directory (such as `/ns1/`) or subdirectory (such as `/ns1/subdir/`) that will be mapped 1-1 with `data_repository_path`. The leading forward slash in the name is required. Two data repository associations cannot have overlapping file system paths. For example, if a data repository is associated with file system path `/ns1/`, then you cannot link another data repository with file system path `/ns1/ns2`. This path specifies where in your file system files will be exported from or imported to. This file system directory can be linked to only one Amazon S3 bucket, and no other S3 bucket can be linked to the directory.
     */
    public val fileSystemPath: Output<String>
        get() = javaResource.fileSystemPath().applyValue({ args0 -> args0 })

    /**
     * For files imported from a data repository, this value determines the stripe count and maximum amount of data per file (in MiB) stored on a single physical disk. The maximum number of disks that a single file can be striped across is limited by the total number of disks that make up the file system.
     */
    public val importedFileChunkSize: Output<Int>
        get() = javaResource.importedFileChunkSize().applyValue({ args0 -> args0 })

    /**
     * See the `s3` configuration block. Max of 1.
     * The configuration for an Amazon S3 data repository linked to an Amazon FSx Lustre file system with a data repository association. The configuration defines which file events (new, changed, or deleted files or directories) are automatically imported from the linked data repository to the file system or automatically exported from the file system to the data repository.
     */
    public val s3: Output<DataRepositoryAssociationS3>
        get() = javaResource.s3().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * A map of tags to assign to the data repository association. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DataRepositoryAssociationMapper : ResourceMapper<DataRepositoryAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fsx.DataRepositoryAssociation::class == javaResource::class

    override fun map(javaResource: Resource): DataRepositoryAssociation =
        DataRepositoryAssociation(javaResource as com.pulumi.aws.fsx.DataRepositoryAssociation)
}

/**
 * @see [DataRepositoryAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataRepositoryAssociation].
 */
public suspend fun dataRepositoryAssociation(
    name: String,
    block: suspend DataRepositoryAssociationResourceBuilder.() -> Unit,
): DataRepositoryAssociation {
    val builder = DataRepositoryAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataRepositoryAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataRepositoryAssociation(name: String): DataRepositoryAssociation {
    val builder = DataRepositoryAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
