@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.kotlin.outputs.FileCacheDataRepositoryAssociation
import com.pulumi.aws.fsx.kotlin.outputs.FileCacheLustreConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.fsx.kotlin.outputs.FileCacheDataRepositoryAssociation.Companion.toKotlin as fileCacheDataRepositoryAssociationToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.FileCacheLustreConfiguration.Companion.toKotlin as fileCacheLustreConfigurationToKotlin

/**
 * Builder for [FileCache].
 */
@PulumiTagMarker
public class FileCacheResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FileCacheArgs = FileCacheArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FileCacheArgsBuilder.() -> Unit) {
        val builder = FileCacheArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FileCache {
        val builtJavaResource = com.pulumi.aws.fsx.FileCache(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FileCache(builtJavaResource)
    }
}

/**
 * Resource for managing an Amazon File Cache cache.
 * See the [Create File Cache](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileCache.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.fsx.FileCache("example", {
 *     dataRepositoryAssociations: [{
 *         dataRepositoryPath: "nfs://filer.domain.com",
 *         dataRepositorySubdirectories: [
 *             "test",
 *             "test2",
 *         ],
 *         fileCachePath: "/ns1",
 *         nfs: [{
 *             dnsIps: [
 *                 "192.168.0.1",
 *                 "192.168.0.2",
 *             ],
 *             version: "NFS3",
 *         }],
 *     }],
 *     fileCacheType: "LUSTRE",
 *     fileCacheTypeVersion: "2.12",
 *     lustreConfigurations: [{
 *         deploymentType: "CACHE_1",
 *         metadataConfigurations: [{
 *             storageCapacity: 2400,
 *         }],
 *         perUnitStorageThroughput: 1000,
 *         weeklyMaintenanceStartTime: "2:05:00",
 *     }],
 *     subnetIds: [test1&#46;id],
 *     storageCapacity: 1200,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.fsx.FileCache("example",
 *     data_repository_associations=[{
 *         "data_repository_path": "nfs://filer.domain.com",
 *         "data_repository_subdirectories": [
 *             "test",
 *             "test2",
 *         ],
 *         "file_cache_path": "/ns1",
 *         "nfs": [{
 *             "dns_ips": [
 *                 "192.168.0.1",
 *                 "192.168.0.2",
 *             ],
 *             "version": "NFS3",
 *         }],
 *     }],
 *     file_cache_type="LUSTRE",
 *     file_cache_type_version="2.12",
 *     lustre_configurations=[{
 *         "deployment_type": "CACHE_1",
 *         "metadata_configurations": [{
 *             "storage_capacity": 2400,
 *         }],
 *         "per_unit_storage_throughput": 1000,
 *         "weekly_maintenance_start_time": "2:05:00",
 *     }],
 *     subnet_ids=[test1["id"]],
 *     storage_capacity=1200)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Fsx.FileCache("example", new()
 *     {
 *         DataRepositoryAssociations = new[]
 *         {
 *             new Aws.Fsx.Inputs.FileCacheDataRepositoryAssociationArgs
 *             {
 *                 DataRepositoryPath = "nfs://filer.domain.com",
 *                 DataRepositorySubdirectories = new[]
 *                 {
 *                     "test",
 *                     "test2",
 *                 },
 *                 FileCachePath = "/ns1",
 *                 Nfs = new[]
 *                 {
 *                     new Aws.Fsx.Inputs.FileCacheDataRepositoryAssociationNfArgs
 *                     {
 *                         DnsIps = new[]
 *                         {
 *                             "192.168.0.1",
 *                             "192.168.0.2",
 *                         },
 *                         Version = "NFS3",
 *                     },
 *                 },
 *             },
 *         },
 *         FileCacheType = "LUSTRE",
 *         FileCacheTypeVersion = "2.12",
 *         LustreConfigurations = new[]
 *         {
 *             new Aws.Fsx.Inputs.FileCacheLustreConfigurationArgs
 *             {
 *                 DeploymentType = "CACHE_1",
 *                 MetadataConfigurations = new[]
 *                 {
 *                     new Aws.Fsx.Inputs.FileCacheLustreConfigurationMetadataConfigurationArgs
 *                     {
 *                         StorageCapacity = 2400,
 *                     },
 *                 },
 *                 PerUnitStorageThroughput = 1000,
 *                 WeeklyMaintenanceStartTime = "2:05:00",
 *             },
 *         },
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *         },
 *         StorageCapacity = 1200,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewFileCache(ctx, "example", &fsx.FileCacheArgs{
 * 			DataRepositoryAssociations: fsx.FileCacheDataRepositoryAssociationArray{
 * 				&fsx.FileCacheDataRepositoryAssociationArgs{
 * 					DataRepositoryPath: pulumi.String("nfs://filer.domain.com"),
 * 					DataRepositorySubdirectories: pulumi.StringArray{
 * 						pulumi.String("test"),
 * 						pulumi.String("test2"),
 * 					},
 * 					FileCachePath: pulumi.String("/ns1"),
 * 					Nfs: fsx.FileCacheDataRepositoryAssociationNfArray{
 * 						&fsx.FileCacheDataRepositoryAssociationNfArgs{
 * 							DnsIps: pulumi.StringArray{
 * 								pulumi.String("192.168.0.1"),
 * 								pulumi.String("192.168.0.2"),
 * 							},
 * 							Version: pulumi.String("NFS3"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			FileCacheType:        pulumi.String("LUSTRE"),
 * 			FileCacheTypeVersion: pulumi.String("2.12"),
 * 			LustreConfigurations: fsx.FileCacheLustreConfigurationArray{
 * 				&fsx.FileCacheLustreConfigurationArgs{
 * 					DeploymentType: pulumi.String("CACHE_1"),
 * 					MetadataConfigurations: fsx.FileCacheLustreConfigurationMetadataConfigurationArray{
 * 						&fsx.FileCacheLustreConfigurationMetadataConfigurationArgs{
 * 							StorageCapacity: pulumi.Int(2400),
 * 						},
 * 					},
 * 					PerUnitStorageThroughput:   pulumi.Int(1000),
 * 					WeeklyMaintenanceStartTime: pulumi.String("2:05:00"),
 * 				},
 * 			},
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 			},
 * 			StorageCapacity: pulumi.Int(1200),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.FileCache;
 * import com.pulumi.aws.fsx.FileCacheArgs;
 * import com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationArgs;
 * import com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FileCache("example", FileCacheArgs.builder()
 *             .dataRepositoryAssociations(FileCacheDataRepositoryAssociationArgs.builder()
 *                 .dataRepositoryPath("nfs://filer.domain.com")
 *                 .dataRepositorySubdirectories(
 *                     "test",
 *                     "test2")
 *                 .fileCachePath("/ns1")
 *                 .nfs(FileCacheDataRepositoryAssociationNfArgs.builder()
 *                     .dnsIps(
 *                         "192.168.0.1",
 *                         "192.168.0.2")
 *                     .version("NFS3")
 *                     .build())
 *                 .build())
 *             .fileCacheType("LUSTRE")
 *             .fileCacheTypeVersion("2.12")
 *             .lustreConfigurations(FileCacheLustreConfigurationArgs.builder()
 *                 .deploymentType("CACHE_1")
 *                 .metadataConfigurations(FileCacheLustreConfigurationMetadataConfigurationArgs.builder()
 *                     .storageCapacity(2400)
 *                     .build())
 *                 .perUnitStorageThroughput(1000)
 *                 .weeklyMaintenanceStartTime("2:05:00")
 *                 .build())
 *             .subnetIds(test1.id())
 *             .storageCapacity(1200)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fsx:FileCache
 *     properties:
 *       dataRepositoryAssociations:
 *         - dataRepositoryPath: nfs://filer.domain.com
 *           dataRepositorySubdirectories:
 *             - test
 *             - test2
 *           fileCachePath: /ns1
 *           nfs:
 *             - dnsIps:
 *                 - 192.168.0.1
 *                 - 192.168.0.2
 *               version: NFS3
 *       fileCacheType: LUSTRE
 *       fileCacheTypeVersion: '2.12'
 *       lustreConfigurations:
 *         - deploymentType: CACHE_1
 *           metadataConfigurations:
 *             - storageCapacity: 2400
 *           perUnitStorageThroughput: 1000
 *           weeklyMaintenanceStartTime: 2:05:00
 *       subnetIds:
 *         - ${test1.id}
 *       storageCapacity: 1200
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon File Cache cache using the resource `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/fileCache:FileCache example fc-8012925589
 * ```
 */
public class FileCache internal constructor(
    override val javaResource: com.pulumi.aws.fsx.FileCache,
) : KotlinCustomResource(javaResource, FileCacheMapper) {
    /**
     * The Amazon Resource Name (ARN) for the resource.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
     */
    public val copyTagsToDataRepositoryAssociations: Output<Boolean>?
        get() = javaResource.copyTagsToDataRepositoryAssociations().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * A list of IDs of data repository associations that are associated with this cache.
     */
    public val dataRepositoryAssociationIds: Output<List<String>>
        get() = javaResource.dataRepositoryAssociationIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            })
        })

    /**
     * See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    public val dataRepositoryAssociations: Output<List<FileCacheDataRepositoryAssociation>>?
        get() = javaResource.dataRepositoryAssociations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        fileCacheDataRepositoryAssociationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The Domain Name System (DNS) name for the cache.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * The system-generated, unique ID of the cache.
     */
    public val fileCacheId: Output<String>
        get() = javaResource.fileCacheId().applyValue({ args0 -> args0 })

    /**
     * The type of cache that you're creating. The only supported value is `LUSTRE`.
     */
    public val fileCacheType: Output<String>
        get() = javaResource.fileCacheType().applyValue({ args0 -> args0 })

    /**
     * The version for the type of cache that you're creating. The only supported value is `2.12`.
     */
    public val fileCacheTypeVersion: Output<String>
        get() = javaResource.fileCacheTypeVersion().applyValue({ args0 -> args0 })

    /**
     * Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    public val lustreConfigurations: Output<List<FileCacheLustreConfiguration>>?
        get() = javaResource.lustreConfigurations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        fileCacheLustreConfigurationToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * A list of network interface IDs.
     */
    public val networkInterfaceIds: Output<List<String>>
        get() = javaResource.networkInterfaceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     */
    public val securityGroupIds: Output<List<String>>?
        get() = javaResource.securityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
     */
    public val storageCapacity: Output<Int>
        get() = javaResource.storageCapacity().applyValue({ args0 -> args0 })

    /**
     * A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * The following arguments are optional:
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of your virtual private cloud (VPC).
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })
}

public object FileCacheMapper : ResourceMapper<FileCache> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fsx.FileCache::class == javaResource::class

    override fun map(javaResource: Resource): FileCache = FileCache(
        javaResource as
            com.pulumi.aws.fsx.FileCache,
    )
}

/**
 * @see [FileCache].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FileCache].
 */
public suspend fun fileCache(name: String, block: suspend FileCacheResourceBuilder.() -> Unit): FileCache {
    val builder = FileCacheResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FileCache].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fileCache(name: String): FileCache {
    val builder = FileCacheResourceBuilder()
    builder.name(name)
    return builder.build()
}
