@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.FileCacheArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.FileCacheDataRepositoryAssociationArgs
import com.pulumi.aws.fsx.kotlin.inputs.FileCacheDataRepositoryAssociationArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.FileCacheLustreConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.FileCacheLustreConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an Amazon File Cache cache.
 * See the [Create File Cache](https://docs.aws.amazon.com/fsx/latest/APIReference/API_CreateFileCache.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.fsx.FileCache("example", {
 *     dataRepositoryAssociations: [{
 *         dataRepositoryPath: "nfs://filer.domain.com",
 *         dataRepositorySubdirectories: [
 *             "test",
 *             "test2",
 *         ],
 *         fileCachePath: "/ns1",
 *         nfs: [{
 *             dnsIps: [
 *                 "192.168.0.1",
 *                 "192.168.0.2",
 *             ],
 *             version: "NFS3",
 *         }],
 *     }],
 *     fileCacheType: "LUSTRE",
 *     fileCacheTypeVersion: "2.12",
 *     lustreConfigurations: [{
 *         deploymentType: "CACHE_1",
 *         metadataConfigurations: [{
 *             storageCapacity: 2400,
 *         }],
 *         perUnitStorageThroughput: 1000,
 *         weeklyMaintenanceStartTime: "2:05:00",
 *     }],
 *     subnetIds: [test1&#46;id],
 *     storageCapacity: 1200,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.fsx.FileCache("example",
 *     data_repository_associations=[{
 *         "data_repository_path": "nfs://filer.domain.com",
 *         "data_repository_subdirectories": [
 *             "test",
 *             "test2",
 *         ],
 *         "file_cache_path": "/ns1",
 *         "nfs": [{
 *             "dns_ips": [
 *                 "192.168.0.1",
 *                 "192.168.0.2",
 *             ],
 *             "version": "NFS3",
 *         }],
 *     }],
 *     file_cache_type="LUSTRE",
 *     file_cache_type_version="2.12",
 *     lustre_configurations=[{
 *         "deployment_type": "CACHE_1",
 *         "metadata_configurations": [{
 *             "storage_capacity": 2400,
 *         }],
 *         "per_unit_storage_throughput": 1000,
 *         "weekly_maintenance_start_time": "2:05:00",
 *     }],
 *     subnet_ids=[test1["id"]],
 *     storage_capacity=1200)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Fsx.FileCache("example", new()
 *     {
 *         DataRepositoryAssociations = new[]
 *         {
 *             new Aws.Fsx.Inputs.FileCacheDataRepositoryAssociationArgs
 *             {
 *                 DataRepositoryPath = "nfs://filer.domain.com",
 *                 DataRepositorySubdirectories = new[]
 *                 {
 *                     "test",
 *                     "test2",
 *                 },
 *                 FileCachePath = "/ns1",
 *                 Nfs = new[]
 *                 {
 *                     new Aws.Fsx.Inputs.FileCacheDataRepositoryAssociationNfArgs
 *                     {
 *                         DnsIps = new[]
 *                         {
 *                             "192.168.0.1",
 *                             "192.168.0.2",
 *                         },
 *                         Version = "NFS3",
 *                     },
 *                 },
 *             },
 *         },
 *         FileCacheType = "LUSTRE",
 *         FileCacheTypeVersion = "2.12",
 *         LustreConfigurations = new[]
 *         {
 *             new Aws.Fsx.Inputs.FileCacheLustreConfigurationArgs
 *             {
 *                 DeploymentType = "CACHE_1",
 *                 MetadataConfigurations = new[]
 *                 {
 *                     new Aws.Fsx.Inputs.FileCacheLustreConfigurationMetadataConfigurationArgs
 *                     {
 *                         StorageCapacity = 2400,
 *                     },
 *                 },
 *                 PerUnitStorageThroughput = 1000,
 *                 WeeklyMaintenanceStartTime = "2:05:00",
 *             },
 *         },
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *         },
 *         StorageCapacity = 1200,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewFileCache(ctx, "example", &fsx.FileCacheArgs{
 * 			DataRepositoryAssociations: fsx.FileCacheDataRepositoryAssociationArray{
 * 				&fsx.FileCacheDataRepositoryAssociationArgs{
 * 					DataRepositoryPath: pulumi.String("nfs://filer.domain.com"),
 * 					DataRepositorySubdirectories: pulumi.StringArray{
 * 						pulumi.String("test"),
 * 						pulumi.String("test2"),
 * 					},
 * 					FileCachePath: pulumi.String("/ns1"),
 * 					Nfs: fsx.FileCacheDataRepositoryAssociationNfArray{
 * 						&fsx.FileCacheDataRepositoryAssociationNfArgs{
 * 							DnsIps: pulumi.StringArray{
 * 								pulumi.String("192.168.0.1"),
 * 								pulumi.String("192.168.0.2"),
 * 							},
 * 							Version: pulumi.String("NFS3"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			FileCacheType:        pulumi.String("LUSTRE"),
 * 			FileCacheTypeVersion: pulumi.String("2.12"),
 * 			LustreConfigurations: fsx.FileCacheLustreConfigurationArray{
 * 				&fsx.FileCacheLustreConfigurationArgs{
 * 					DeploymentType: pulumi.String("CACHE_1"),
 * 					MetadataConfigurations: fsx.FileCacheLustreConfigurationMetadataConfigurationArray{
 * 						&fsx.FileCacheLustreConfigurationMetadataConfigurationArgs{
 * 							StorageCapacity: pulumi.Int(2400),
 * 						},
 * 					},
 * 					PerUnitStorageThroughput:   pulumi.Int(1000),
 * 					WeeklyMaintenanceStartTime: pulumi.String("2:05:00"),
 * 				},
 * 			},
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 			},
 * 			StorageCapacity: pulumi.Int(1200),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.FileCache;
 * import com.pulumi.aws.fsx.FileCacheArgs;
 * import com.pulumi.aws.fsx.inputs.FileCacheDataRepositoryAssociationArgs;
 * import com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FileCache("example", FileCacheArgs.builder()
 *             .dataRepositoryAssociations(FileCacheDataRepositoryAssociationArgs.builder()
 *                 .dataRepositoryPath("nfs://filer.domain.com")
 *                 .dataRepositorySubdirectories(
 *                     "test",
 *                     "test2")
 *                 .fileCachePath("/ns1")
 *                 .nfs(FileCacheDataRepositoryAssociationNfArgs.builder()
 *                     .dnsIps(
 *                         "192.168.0.1",
 *                         "192.168.0.2")
 *                     .version("NFS3")
 *                     .build())
 *                 .build())
 *             .fileCacheType("LUSTRE")
 *             .fileCacheTypeVersion("2.12")
 *             .lustreConfigurations(FileCacheLustreConfigurationArgs.builder()
 *                 .deploymentType("CACHE_1")
 *                 .metadataConfigurations(FileCacheLustreConfigurationMetadataConfigurationArgs.builder()
 *                     .storageCapacity(2400)
 *                     .build())
 *                 .perUnitStorageThroughput(1000)
 *                 .weeklyMaintenanceStartTime("2:05:00")
 *                 .build())
 *             .subnetIds(test1.id())
 *             .storageCapacity(1200)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fsx:FileCache
 *     properties:
 *       dataRepositoryAssociations:
 *         - dataRepositoryPath: nfs://filer.domain.com
 *           dataRepositorySubdirectories:
 *             - test
 *             - test2
 *           fileCachePath: /ns1
 *           nfs:
 *             - dnsIps:
 *                 - 192.168.0.1
 *                 - 192.168.0.2
 *               version: NFS3
 *       fileCacheType: LUSTRE
 *       fileCacheTypeVersion: '2.12'
 *       lustreConfigurations:
 *         - deploymentType: CACHE_1
 *           metadataConfigurations:
 *             - storageCapacity: 2400
 *           perUnitStorageThroughput: 1000
 *           weeklyMaintenanceStartTime: 2:05:00
 *       subnetIds:
 *         - ${test1.id}
 *       storageCapacity: 1200
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Amazon File Cache cache using the resource `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/fileCache:FileCache example fc-8012925589
 * ```
 * @property copyTagsToDataRepositoryAssociations A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
 * @property dataRepositoryAssociations See the `data_repository_association` configuration block. Max of 8.
 * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
 * @property fileCacheType The type of cache that you're creating. The only supported value is `LUSTRE`.
 * @property fileCacheTypeVersion The version for the type of cache that you're creating. The only supported value is `2.12`.
 * @property kmsKeyId Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
 * @property lustreConfigurations See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
 * @property securityGroupIds A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
 * @property storageCapacity The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
 * @property subnetIds A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FileCacheArgs(
    public val copyTagsToDataRepositoryAssociations: Output<Boolean>? = null,
    public val dataRepositoryAssociations: Output<List<FileCacheDataRepositoryAssociationArgs>>? =
        null,
    public val fileCacheType: Output<String>? = null,
    public val fileCacheTypeVersion: Output<String>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val lustreConfigurations: Output<List<FileCacheLustreConfigurationArgs>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val storageCapacity: Output<Int>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.FileCacheArgs> {
    override fun toJava(): com.pulumi.aws.fsx.FileCacheArgs =
        com.pulumi.aws.fsx.FileCacheArgs.builder()
            .copyTagsToDataRepositoryAssociations(
                copyTagsToDataRepositoryAssociations?.applyValue({ args0 ->
                    args0
                }),
            )
            .dataRepositoryAssociations(
                dataRepositoryAssociations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .fileCacheType(fileCacheType?.applyValue({ args0 -> args0 }))
            .fileCacheTypeVersion(fileCacheTypeVersion?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .lustreConfigurations(
                lustreConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageCapacity(storageCapacity?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FileCacheArgs].
 */
@PulumiTagMarker
public class FileCacheArgsBuilder internal constructor() {
    private var copyTagsToDataRepositoryAssociations: Output<Boolean>? = null

    private var dataRepositoryAssociations: Output<List<FileCacheDataRepositoryAssociationArgs>>? =
        null

    private var fileCacheType: Output<String>? = null

    private var fileCacheTypeVersion: Output<String>? = null

    private var kmsKeyId: Output<String>? = null

    private var lustreConfigurations: Output<List<FileCacheLustreConfigurationArgs>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var storageCapacity: Output<Int>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
     */
    @JvmName("lmmarwgxjrudasne")
    public suspend fun copyTagsToDataRepositoryAssociations(`value`: Output<Boolean>) {
        this.copyTagsToDataRepositoryAssociations = value
    }

    /**
     * @param value See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("tnnukmhqhclttyqo")
    public suspend fun dataRepositoryAssociations(`value`: Output<List<FileCacheDataRepositoryAssociationArgs>>) {
        this.dataRepositoryAssociations = value
    }

    @JvmName("etsoibrpydeeunhq")
    public suspend fun dataRepositoryAssociations(vararg values: Output<FileCacheDataRepositoryAssociationArgs>) {
        this.dataRepositoryAssociations = Output.all(values.asList())
    }

    /**
     * @param values See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("gqmvpdssjgcfxbrk")
    public suspend fun dataRepositoryAssociations(values: List<Output<FileCacheDataRepositoryAssociationArgs>>) {
        this.dataRepositoryAssociations = Output.all(values)
    }

    /**
     * @param value The type of cache that you're creating. The only supported value is `LUSTRE`.
     */
    @JvmName("ccyphbsqjeggrkve")
    public suspend fun fileCacheType(`value`: Output<String>) {
        this.fileCacheType = value
    }

    /**
     * @param value The version for the type of cache that you're creating. The only supported value is `2.12`.
     */
    @JvmName("ycusoxlslvibrwku")
    public suspend fun fileCacheTypeVersion(`value`: Output<String>) {
        this.fileCacheTypeVersion = value
    }

    /**
     * @param value Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
     */
    @JvmName("funclelgptnmlklv")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("rmfjvydqdyhuikeo")
    public suspend fun lustreConfigurations(`value`: Output<List<FileCacheLustreConfigurationArgs>>) {
        this.lustreConfigurations = value
    }

    @JvmName("mfyplhitvvpeeuml")
    public suspend fun lustreConfigurations(vararg values: Output<FileCacheLustreConfigurationArgs>) {
        this.lustreConfigurations = Output.all(values.asList())
    }

    /**
     * @param values See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("eeeclgopskcgtbid")
    public suspend fun lustreConfigurations(values: List<Output<FileCacheLustreConfigurationArgs>>) {
        this.lustreConfigurations = Output.all(values)
    }

    /**
     * @param value A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     */
    @JvmName("bshkjnvgratetykw")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("vhbfprbiprwqxodt")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     */
    @JvmName("bcjvviqrdwsyckym")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
     */
    @JvmName("pifigifyxuyboukw")
    public suspend fun storageCapacity(`value`: Output<Int>) {
        this.storageCapacity = value
    }

    /**
     * @param value A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * The following arguments are optional:
     */
    @JvmName("tdbioqexogueqigk")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("lbmlahwcrvwxmwip")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * The following arguments are optional:
     */
    @JvmName("csnwbktpahkjnaxj")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("riiqaascaknubcxm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A boolean flag indicating whether tags for the cache should be copied to data repository associations. This value defaults to false.
     */
    @JvmName("itqcswvbnpyuhuel")
    public suspend fun copyTagsToDataRepositoryAssociations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToDataRepositoryAssociations = mapped
    }

    /**
     * @param value See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("hqhwfilllgcmjlno")
    public suspend fun dataRepositoryAssociations(`value`: List<FileCacheDataRepositoryAssociationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataRepositoryAssociations = mapped
    }

    /**
     * @param argument See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("byyqhqeecqipbdvh")
    public suspend fun dataRepositoryAssociations(argument: List<suspend FileCacheDataRepositoryAssociationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FileCacheDataRepositoryAssociationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataRepositoryAssociations = mapped
    }

    /**
     * @param argument See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("niaspmdtksoayapa")
    public suspend fun dataRepositoryAssociations(vararg argument: suspend FileCacheDataRepositoryAssociationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FileCacheDataRepositoryAssociationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataRepositoryAssociations = mapped
    }

    /**
     * @param argument See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("aiwimaphmrofaunh")
    public suspend fun dataRepositoryAssociations(argument: suspend FileCacheDataRepositoryAssociationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FileCacheDataRepositoryAssociationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataRepositoryAssociations = mapped
    }

    /**
     * @param values See the `data_repository_association` configuration block. Max of 8.
     * A list of up to 8 configurations for data repository associations (DRAs) to be created during the cache creation. The DRAs link the cache to either an Amazon S3 data repository or a Network File System (NFS) data repository that supports the NFSv3 protocol. The DRA configurations must meet the following requirements: 1) All configurations on the list must be of the same data repository type, either all S3 or all NFS. A cache can't link to different data repository types at the same time. 2) An NFS DRA must link to an NFS file system that supports the NFSv3 protocol. DRA automatic import and automatic export is not supported.
     */
    @JvmName("hryninakatgwaeew")
    public suspend fun dataRepositoryAssociations(vararg values: FileCacheDataRepositoryAssociationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataRepositoryAssociations = mapped
    }

    /**
     * @param value The type of cache that you're creating. The only supported value is `LUSTRE`.
     */
    @JvmName("jqjjpvknrfvlefvg")
    public suspend fun fileCacheType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileCacheType = mapped
    }

    /**
     * @param value The version for the type of cache that you're creating. The only supported value is `2.12`.
     */
    @JvmName("usaxpvhswpsmcwwa")
    public suspend fun fileCacheTypeVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileCacheTypeVersion = mapped
    }

    /**
     * @param value Specifies the ID of the AWS Key Management Service (AWS KMS) key to use for encrypting data on an Amazon File Cache. If a KmsKeyId isn't specified, the Amazon FSx-managed AWS KMS key for your account is used.
     */
    @JvmName("uaslbstckrbuohnt")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("lcfqogvhqvuqhbqw")
    public suspend fun lustreConfigurations(`value`: List<FileCacheLustreConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lustreConfigurations = mapped
    }

    /**
     * @param argument See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("churfljjldbwmmfr")
    public suspend fun lustreConfigurations(argument: List<suspend FileCacheLustreConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FileCacheLustreConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lustreConfigurations = mapped
    }

    /**
     * @param argument See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("yillhwisewcdwkiu")
    public suspend fun lustreConfigurations(vararg argument: suspend FileCacheLustreConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FileCacheLustreConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lustreConfigurations = mapped
    }

    /**
     * @param argument See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("inckbdrhapkrehcx")
    public suspend fun lustreConfigurations(argument: suspend FileCacheLustreConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FileCacheLustreConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.lustreConfigurations = mapped
    }

    /**
     * @param values See the `lustre_configuration` block. Required when `file_cache_type` is `LUSTRE`.
     */
    @JvmName("tveyknsixeryuidk")
    public suspend fun lustreConfigurations(vararg values: FileCacheLustreConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lustreConfigurations = mapped
    }

    /**
     * @param value A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     */
    @JvmName("aehvqiesffdmwsqd")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of IDs specifying the security groups to apply to all network interfaces created for Amazon File Cache access.
     */
    @JvmName("aofdaulmxwdbwufv")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The storage capacity of the cache in gibibytes (GiB). Valid values are `1200` GiB, `2400` GiB, and increments of `2400` GiB.
     */
    @JvmName("qcwqdhkdgniiiqbn")
    public suspend fun storageCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacity = mapped
    }

    /**
     * @param value A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * The following arguments are optional:
     */
    @JvmName("hrbphsxokqymqeom")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of subnet IDs that the cache will be accessible from. You can specify only one subnet ID.
     * The following arguments are optional:
     */
    @JvmName("socxwjwdqgmekwtq")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("khvsotptgvbvfwmm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file cache. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hrurdfmwgdgbrtnu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FileCacheArgs = FileCacheArgs(
        copyTagsToDataRepositoryAssociations = copyTagsToDataRepositoryAssociations,
        dataRepositoryAssociations = dataRepositoryAssociations,
        fileCacheType = fileCacheType,
        fileCacheTypeVersion = fileCacheTypeVersion,
        kmsKeyId = kmsKeyId,
        lustreConfigurations = lustreConfigurations,
        securityGroupIds = securityGroupIds,
        storageCapacity = storageCapacity,
        subnetIds = subnetIds,
        tags = tags,
    )
}
