@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.kotlin.outputs.OntapFileSystemDiskIopsConfiguration
import com.pulumi.aws.fsx.kotlin.outputs.OntapFileSystemEndpoint
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.fsx.kotlin.outputs.OntapFileSystemDiskIopsConfiguration.Companion.toKotlin as ontapFileSystemDiskIopsConfigurationToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.OntapFileSystemEndpoint.Companion.toKotlin as ontapFileSystemEndpointToKotlin

/**
 * Builder for [OntapFileSystem].
 */
@PulumiTagMarker
public class OntapFileSystemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OntapFileSystemArgs = OntapFileSystemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OntapFileSystemArgsBuilder.() -> Unit) {
        val builder = OntapFileSystemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OntapFileSystem {
        val builtJavaResource = com.pulumi.aws.fsx.OntapFileSystem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OntapFileSystem(builtJavaResource)
    }
}

/**
 * Manages an Amazon FSx for NetApp ONTAP file system.
 * See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/what-is-fsx-ontap.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OntapFileSystem("test", {
 *     storageCapacity: 1024,
 *     subnetIds: [
 *         test1.id,
 *         test2.id,
 *     ],
 *     deploymentType: "MULTI_AZ_1",
 *     throughputCapacity: 512,
 *     preferredSubnetId: test1.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OntapFileSystem("test",
 *     storage_capacity=1024,
 *     subnet_ids=[
 *         test1["id"],
 *         test2["id"],
 *     ],
 *     deployment_type="MULTI_AZ_1",
 *     throughput_capacity=512,
 *     preferred_subnet_id=test1["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OntapFileSystem("test", new()
 *     {
 *         StorageCapacity = 1024,
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *             test2.Id,
 *         },
 *         DeploymentType = "MULTI_AZ_1",
 *         ThroughputCapacity = 512,
 *         PreferredSubnetId = test1.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapFileSystem(ctx, "test", &fsx.OntapFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(1024),
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 				test2.Id,
 * 			},
 * 			DeploymentType:     pulumi.String("MULTI_AZ_1"),
 * 			ThroughputCapacity: pulumi.Int(512),
 * 			PreferredSubnetId:  pulumi.Any(test1.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapFileSystem;
 * import com.pulumi.aws.fsx.OntapFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapFileSystem("test", OntapFileSystemArgs.builder()
 *             .storageCapacity(1024)
 *             .subnetIds(
 *                 test1.id(),
 *                 test2.id())
 *             .deploymentType("MULTI_AZ_1")
 *             .throughputCapacity(512)
 *             .preferredSubnetId(test1.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OntapFileSystem
 *     properties:
 *       storageCapacity: 1024
 *       subnetIds:
 *         - ${test1.id}
 *         - ${test2.id}
 *       deploymentType: MULTI_AZ_1
 *       throughputCapacity: 512
 *       preferredSubnetId: ${test1.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testhapairs = new aws.fsx.OntapFileSystem("testhapairs", {
 *     storageCapacity: 2048,
 *     subnetIds: [test1&#46;id],
 *     deploymentType: "SINGLE_AZ_1",
 *     haPairs: 2,
 *     throughputCapacityPerHaPair: 128,
 *     preferredSubnetId: test1.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * testhapairs = aws.fsx.OntapFileSystem("testhapairs",
 *     storage_capacity=2048,
 *     subnet_ids=[test1["id"]],
 *     deployment_type="SINGLE_AZ_1",
 *     ha_pairs=2,
 *     throughput_capacity_per_ha_pair=128,
 *     preferred_subnet_id=test1["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testhapairs = new Aws.Fsx.OntapFileSystem("testhapairs", new()
 *     {
 *         StorageCapacity = 2048,
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *         },
 *         DeploymentType = "SINGLE_AZ_1",
 *         HaPairs = 2,
 *         ThroughputCapacityPerHaPair = 128,
 *         PreferredSubnetId = test1.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapFileSystem(ctx, "testhapairs", &fsx.OntapFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(2048),
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 			},
 * 			DeploymentType:              pulumi.String("SINGLE_AZ_1"),
 * 			HaPairs:                     pulumi.Int(2),
 * 			ThroughputCapacityPerHaPair: pulumi.Int(128),
 * 			PreferredSubnetId:           pulumi.Any(test1.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapFileSystem;
 * import com.pulumi.aws.fsx.OntapFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testhapairs = new OntapFileSystem("testhapairs", OntapFileSystemArgs.builder()
 *             .storageCapacity(2048)
 *             .subnetIds(test1.id())
 *             .deploymentType("SINGLE_AZ_1")
 *             .haPairs(2)
 *             .throughputCapacityPerHaPair(128)
 *             .preferredSubnetId(test1.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testhapairs:
 *     type: aws:fsx:OntapFileSystem
 *     properties:
 *       storageCapacity: 2048
 *       subnetIds:
 *         - ${test1.id}
 *       deploymentType: SINGLE_AZ_1
 *       haPairs: 2
 *       throughputCapacityPerHaPair: 128
 *       preferredSubnetId: ${test1.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testsingleazgen2 = new aws.fsx.OntapFileSystem("testsingleazgen2", {
 *     storageCapacity: 4096,
 *     subnetIds: [test1&#46;id],
 *     deploymentType: "SINGLE_AZ_2",
 *     haPairs: 4,
 *     throughputCapacityPerHaPair: 384,
 *     preferredSubnetId: test1.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * testsingleazgen2 = aws.fsx.OntapFileSystem("testsingleazgen2",
 *     storage_capacity=4096,
 *     subnet_ids=[test1["id"]],
 *     deployment_type="SINGLE_AZ_2",
 *     ha_pairs=4,
 *     throughput_capacity_per_ha_pair=384,
 *     preferred_subnet_id=test1["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testsingleazgen2 = new Aws.Fsx.OntapFileSystem("testsingleazgen2", new()
 *     {
 *         StorageCapacity = 4096,
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *         },
 *         DeploymentType = "SINGLE_AZ_2",
 *         HaPairs = 4,
 *         ThroughputCapacityPerHaPair = 384,
 *         PreferredSubnetId = test1.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapFileSystem(ctx, "testsingleazgen2", &fsx.OntapFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(4096),
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 			},
 * 			DeploymentType:              pulumi.String("SINGLE_AZ_2"),
 * 			HaPairs:                     pulumi.Int(4),
 * 			ThroughputCapacityPerHaPair: pulumi.Int(384),
 * 			PreferredSubnetId:           pulumi.Any(test1.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapFileSystem;
 * import com.pulumi.aws.fsx.OntapFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testsingleazgen2 = new OntapFileSystem("testsingleazgen2", OntapFileSystemArgs.builder()
 *             .storageCapacity(4096)
 *             .subnetIds(test1.id())
 *             .deploymentType("SINGLE_AZ_2")
 *             .haPairs(4)
 *             .throughputCapacityPerHaPair(384)
 *             .preferredSubnetId(test1.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testsingleazgen2:
 *     type: aws:fsx:OntapFileSystem
 *     properties:
 *       storageCapacity: 4096
 *       subnetIds:
 *         - ${test1.id}
 *       deploymentType: SINGLE_AZ_2
 *       haPairs: 4
 *       throughputCapacityPerHaPair: 384
 *       preferredSubnetId: ${test1.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testmultiazgen2 = new aws.fsx.OntapFileSystem("testmultiazgen2", {
 *     storageCapacity: 1024,
 *     subnetIds: [
 *         test1.id,
 *         test2.id,
 *     ],
 *     deploymentType: "MULTI_AZ_2",
 *     haPairs: 1,
 *     throughputCapacityPerHaPair: 384,
 *     preferredSubnetId: test1.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * testmultiazgen2 = aws.fsx.OntapFileSystem("testmultiazgen2",
 *     storage_capacity=1024,
 *     subnet_ids=[
 *         test1["id"],
 *         test2["id"],
 *     ],
 *     deployment_type="MULTI_AZ_2",
 *     ha_pairs=1,
 *     throughput_capacity_per_ha_pair=384,
 *     preferred_subnet_id=test1["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testmultiazgen2 = new Aws.Fsx.OntapFileSystem("testmultiazgen2", new()
 *     {
 *         StorageCapacity = 1024,
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *             test2.Id,
 *         },
 *         DeploymentType = "MULTI_AZ_2",
 *         HaPairs = 1,
 *         ThroughputCapacityPerHaPair = 384,
 *         PreferredSubnetId = test1.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapFileSystem(ctx, "testmultiazgen2", &fsx.OntapFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(1024),
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 				test2.Id,
 * 			},
 * 			DeploymentType:              pulumi.String("MULTI_AZ_2"),
 * 			HaPairs:                     pulumi.Int(1),
 * 			ThroughputCapacityPerHaPair: pulumi.Int(384),
 * 			PreferredSubnetId:           pulumi.Any(test1.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapFileSystem;
 * import com.pulumi.aws.fsx.OntapFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testmultiazgen2 = new OntapFileSystem("testmultiazgen2", OntapFileSystemArgs.builder()
 *             .storageCapacity(1024)
 *             .subnetIds(
 *                 test1.id(),
 *                 test2.id())
 *             .deploymentType("MULTI_AZ_2")
 *             .haPairs(1)
 *             .throughputCapacityPerHaPair(384)
 *             .preferredSubnetId(test1.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testmultiazgen2:
 *     type: aws:fsx:OntapFileSystem
 *     properties:
 *       storageCapacity: 1024
 *       subnetIds:
 *         - ${test1.id}
 *         - ${test2.id}
 *       deploymentType: MULTI_AZ_2
 *       haPairs: 1
 *       throughputCapacityPerHaPair: 384
 *       preferredSubnetId: ${test1.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx File Systems using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/ontapFileSystem:OntapFileSystem example fs-543ab12b1ca672f33
 * ```
 * Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 */
public class OntapFileSystem internal constructor(
    override val javaResource: com.pulumi.aws.fsx.OntapFileSystem,
) : KotlinCustomResource(javaResource, OntapFileSystemMapper) {
    /**
     * Amazon Resource Name of the file system.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     */
    public val automaticBackupRetentionDays: Output<Int>?
        get() = javaResource.automaticBackupRetentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     */
    public val dailyAutomaticBackupStartTime: Output<String>
        get() = javaResource.dailyAutomaticBackupStartTime().applyValue({ args0 -> args0 })

    /**
     * The filesystem deployment type. Supports `MULTI_AZ_1`, `MULTI_AZ_2`, `SINGLE_AZ_1`, and `SINGLE_AZ_2`.
     */
    public val deploymentType: Output<String>
        get() = javaResource.deploymentType().applyValue({ args0 -> args0 })

    /**
     * The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
     */
    public val diskIopsConfiguration: Output<OntapFileSystemDiskIopsConfiguration>
        get() = javaResource.diskIopsConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                ontapFileSystemDiskIopsConfigurationToKotlin(args0)
            })
        })

    /**
     * The Domain Name Service (DNS) name for the file system. You can mount your file system using its DNS name.
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
     */
    public val endpointIpAddressRange: Output<String>
        get() = javaResource.endpointIpAddressRange().applyValue({ args0 -> args0 })

    /**
     * The endpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. See Endpoints below.
     */
    public val endpoints: Output<List<OntapFileSystemEndpoint>>
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ontapFileSystemEndpointToKotlin(args0)
                })
            })
        })

    /**
     * The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
     */
    public val fsxAdminPassword: Output<String>?
        get() = javaResource.fsxAdminPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The number of ha_pairs to deploy for the file system. Valid value is 1 for `SINGLE_AZ_1` or `MULTI_AZ_1` and `MULTI_AZ_2`. Valid values are 1 through 12 for `SINGLE_AZ_2`.
     */
    public val haPairs: Output<Int>
        get() = javaResource.haPairs().applyValue({ args0 -> args0 })

    /**
     * ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
     */
    public val networkInterfaceIds: Output<List<String>>
        get() = javaResource.networkInterfaceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * AWS account identifier that created the file system.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
     */
    public val preferredSubnetId: Output<String>
        get() = javaResource.preferredSubnetId().applyValue({ args0 -> args0 })

    /**
     * Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    public val routeTableIds: Output<List<String>>
        get() = javaResource.routeTableIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    public val securityGroupIds: Output<List<String>>?
        get() = javaResource.securityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The storage capacity (GiB) of the file system. Valid values between `1024` and `196608` for file systems with deployment_type `SINGLE_AZ_1` and `MULTI_AZ_1`. Valid values are between `1024` and `524288` for `MULTI_AZ_2`. Valid values between `1024` (`1024` per ha pair) and `1048576` for file systems with deployment_type `SINGLE_AZ_2`. For `SINGLE_AZ_2`, the `1048576` (1PB) maximum is only supported when using 2 or more ha_pairs, the maximum is `524288` (512TB) when using 1 ha_pair.
     */
    public val storageCapacity: Output<Int>
        get() = javaResource.storageCapacity().applyValue({ args0 -> args0 })

    /**
     * The filesystem storage type. defaults to `SSD`.
     */
    public val storageType: Output<String>?
        get() = javaResource.storageType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter is only supported when not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
     */
    public val throughputCapacity: Output<Int>
        get() = javaResource.throughputCapacity().applyValue({ args0 -> args0 })

    /**
     * Sets the per-HA-pair throughput capacity (in MBps) for the file system that you're creating, as opposed to `throughput_capacity` which specifies the total throughput capacity for the file system. Valid value for `MULTI_AZ_1` and `SINGLE_AZ_1` are `128`, `256`, `512`, `1024`, `2048`, and `4096`. Valid values for deployment type `MULTI_AZ_2` and `SINGLE_AZ_2` are `384`,`768`,`1536`,`3072`,`6144` where `ha_pairs` is `1`. Valid values for deployment type `SINGLE_AZ_2` are `1536`, `3072`, and `6144` where `ha_pairs` is greater than 1. This parameter is only supported when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
     */
    public val throughputCapacityPerHaPair: Output<Int>
        get() = javaResource.throughputCapacityPerHaPair().applyValue({ args0 -> args0 })

    /**
     * Identifier of the Virtual Private Cloud for the file system.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    public val weeklyMaintenanceStartTime: Output<String>
        get() = javaResource.weeklyMaintenanceStartTime().applyValue({ args0 -> args0 })
}

public object OntapFileSystemMapper : ResourceMapper<OntapFileSystem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fsx.OntapFileSystem::class == javaResource::class

    override fun map(javaResource: Resource): OntapFileSystem = OntapFileSystem(
        javaResource as
            com.pulumi.aws.fsx.OntapFileSystem,
    )
}

/**
 * @see [OntapFileSystem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OntapFileSystem].
 */
public suspend fun ontapFileSystem(
    name: String,
    block: suspend OntapFileSystemResourceBuilder.() -> Unit,
): OntapFileSystem {
    val builder = OntapFileSystemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OntapFileSystem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ontapFileSystem(name: String): OntapFileSystem {
    val builder = OntapFileSystemResourceBuilder()
    builder.name(name)
    return builder.build()
}
