@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.OntapFileSystemArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.OntapFileSystemDiskIopsConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.OntapFileSystemDiskIopsConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon FSx for NetApp ONTAP file system.
 * See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/what-is-fsx-ontap.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OntapFileSystem("test", {
 *     storageCapacity: 1024,
 *     subnetIds: [
 *         test1.id,
 *         test2.id,
 *     ],
 *     deploymentType: "MULTI_AZ_1",
 *     throughputCapacity: 512,
 *     preferredSubnetId: test1.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OntapFileSystem("test",
 *     storage_capacity=1024,
 *     subnet_ids=[
 *         test1["id"],
 *         test2["id"],
 *     ],
 *     deployment_type="MULTI_AZ_1",
 *     throughput_capacity=512,
 *     preferred_subnet_id=test1["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OntapFileSystem("test", new()
 *     {
 *         StorageCapacity = 1024,
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *             test2.Id,
 *         },
 *         DeploymentType = "MULTI_AZ_1",
 *         ThroughputCapacity = 512,
 *         PreferredSubnetId = test1.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapFileSystem(ctx, "test", &fsx.OntapFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(1024),
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 				test2.Id,
 * 			},
 * 			DeploymentType:     pulumi.String("MULTI_AZ_1"),
 * 			ThroughputCapacity: pulumi.Int(512),
 * 			PreferredSubnetId:  pulumi.Any(test1.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapFileSystem;
 * import com.pulumi.aws.fsx.OntapFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapFileSystem("test", OntapFileSystemArgs.builder()
 *             .storageCapacity(1024)
 *             .subnetIds(
 *                 test1.id(),
 *                 test2.id())
 *             .deploymentType("MULTI_AZ_1")
 *             .throughputCapacity(512)
 *             .preferredSubnetId(test1.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OntapFileSystem
 *     properties:
 *       storageCapacity: 1024
 *       subnetIds:
 *         - ${test1.id}
 *         - ${test2.id}
 *       deploymentType: MULTI_AZ_1
 *       throughputCapacity: 512
 *       preferredSubnetId: ${test1.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testhapairs = new aws.fsx.OntapFileSystem("testhapairs", {
 *     storageCapacity: 2048,
 *     subnetIds: [test1&#46;id],
 *     deploymentType: "SINGLE_AZ_1",
 *     haPairs: 2,
 *     throughputCapacityPerHaPair: 128,
 *     preferredSubnetId: test1.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * testhapairs = aws.fsx.OntapFileSystem("testhapairs",
 *     storage_capacity=2048,
 *     subnet_ids=[test1["id"]],
 *     deployment_type="SINGLE_AZ_1",
 *     ha_pairs=2,
 *     throughput_capacity_per_ha_pair=128,
 *     preferred_subnet_id=test1["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testhapairs = new Aws.Fsx.OntapFileSystem("testhapairs", new()
 *     {
 *         StorageCapacity = 2048,
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *         },
 *         DeploymentType = "SINGLE_AZ_1",
 *         HaPairs = 2,
 *         ThroughputCapacityPerHaPair = 128,
 *         PreferredSubnetId = test1.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapFileSystem(ctx, "testhapairs", &fsx.OntapFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(2048),
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 			},
 * 			DeploymentType:              pulumi.String("SINGLE_AZ_1"),
 * 			HaPairs:                     pulumi.Int(2),
 * 			ThroughputCapacityPerHaPair: pulumi.Int(128),
 * 			PreferredSubnetId:           pulumi.Any(test1.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapFileSystem;
 * import com.pulumi.aws.fsx.OntapFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testhapairs = new OntapFileSystem("testhapairs", OntapFileSystemArgs.builder()
 *             .storageCapacity(2048)
 *             .subnetIds(test1.id())
 *             .deploymentType("SINGLE_AZ_1")
 *             .haPairs(2)
 *             .throughputCapacityPerHaPair(128)
 *             .preferredSubnetId(test1.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testhapairs:
 *     type: aws:fsx:OntapFileSystem
 *     properties:
 *       storageCapacity: 2048
 *       subnetIds:
 *         - ${test1.id}
 *       deploymentType: SINGLE_AZ_1
 *       haPairs: 2
 *       throughputCapacityPerHaPair: 128
 *       preferredSubnetId: ${test1.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testsingleazgen2 = new aws.fsx.OntapFileSystem("testsingleazgen2", {
 *     storageCapacity: 4096,
 *     subnetIds: [test1&#46;id],
 *     deploymentType: "SINGLE_AZ_2",
 *     haPairs: 4,
 *     throughputCapacityPerHaPair: 384,
 *     preferredSubnetId: test1.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * testsingleazgen2 = aws.fsx.OntapFileSystem("testsingleazgen2",
 *     storage_capacity=4096,
 *     subnet_ids=[test1["id"]],
 *     deployment_type="SINGLE_AZ_2",
 *     ha_pairs=4,
 *     throughput_capacity_per_ha_pair=384,
 *     preferred_subnet_id=test1["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testsingleazgen2 = new Aws.Fsx.OntapFileSystem("testsingleazgen2", new()
 *     {
 *         StorageCapacity = 4096,
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *         },
 *         DeploymentType = "SINGLE_AZ_2",
 *         HaPairs = 4,
 *         ThroughputCapacityPerHaPair = 384,
 *         PreferredSubnetId = test1.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapFileSystem(ctx, "testsingleazgen2", &fsx.OntapFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(4096),
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 			},
 * 			DeploymentType:              pulumi.String("SINGLE_AZ_2"),
 * 			HaPairs:                     pulumi.Int(4),
 * 			ThroughputCapacityPerHaPair: pulumi.Int(384),
 * 			PreferredSubnetId:           pulumi.Any(test1.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapFileSystem;
 * import com.pulumi.aws.fsx.OntapFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testsingleazgen2 = new OntapFileSystem("testsingleazgen2", OntapFileSystemArgs.builder()
 *             .storageCapacity(4096)
 *             .subnetIds(test1.id())
 *             .deploymentType("SINGLE_AZ_2")
 *             .haPairs(4)
 *             .throughputCapacityPerHaPair(384)
 *             .preferredSubnetId(test1.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testsingleazgen2:
 *     type: aws:fsx:OntapFileSystem
 *     properties:
 *       storageCapacity: 4096
 *       subnetIds:
 *         - ${test1.id}
 *       deploymentType: SINGLE_AZ_2
 *       haPairs: 4
 *       throughputCapacityPerHaPair: 384
 *       preferredSubnetId: ${test1.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testmultiazgen2 = new aws.fsx.OntapFileSystem("testmultiazgen2", {
 *     storageCapacity: 1024,
 *     subnetIds: [
 *         test1.id,
 *         test2.id,
 *     ],
 *     deploymentType: "MULTI_AZ_2",
 *     haPairs: 1,
 *     throughputCapacityPerHaPair: 384,
 *     preferredSubnetId: test1.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * testmultiazgen2 = aws.fsx.OntapFileSystem("testmultiazgen2",
 *     storage_capacity=1024,
 *     subnet_ids=[
 *         test1["id"],
 *         test2["id"],
 *     ],
 *     deployment_type="MULTI_AZ_2",
 *     ha_pairs=1,
 *     throughput_capacity_per_ha_pair=384,
 *     preferred_subnet_id=test1["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testmultiazgen2 = new Aws.Fsx.OntapFileSystem("testmultiazgen2", new()
 *     {
 *         StorageCapacity = 1024,
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *             test2.Id,
 *         },
 *         DeploymentType = "MULTI_AZ_2",
 *         HaPairs = 1,
 *         ThroughputCapacityPerHaPair = 384,
 *         PreferredSubnetId = test1.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapFileSystem(ctx, "testmultiazgen2", &fsx.OntapFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(1024),
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 				test2.Id,
 * 			},
 * 			DeploymentType:              pulumi.String("MULTI_AZ_2"),
 * 			HaPairs:                     pulumi.Int(1),
 * 			ThroughputCapacityPerHaPair: pulumi.Int(384),
 * 			PreferredSubnetId:           pulumi.Any(test1.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapFileSystem;
 * import com.pulumi.aws.fsx.OntapFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testmultiazgen2 = new OntapFileSystem("testmultiazgen2", OntapFileSystemArgs.builder()
 *             .storageCapacity(1024)
 *             .subnetIds(
 *                 test1.id(),
 *                 test2.id())
 *             .deploymentType("MULTI_AZ_2")
 *             .haPairs(1)
 *             .throughputCapacityPerHaPair(384)
 *             .preferredSubnetId(test1.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testmultiazgen2:
 *     type: aws:fsx:OntapFileSystem
 *     properties:
 *       storageCapacity: 1024
 *       subnetIds:
 *         - ${test1.id}
 *         - ${test2.id}
 *       deploymentType: MULTI_AZ_2
 *       haPairs: 1
 *       throughputCapacityPerHaPair: 384
 *       preferredSubnetId: ${test1.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx File Systems using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/ontapFileSystem:OntapFileSystem example fs-543ab12b1ca672f33
 * ```
 * Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property automaticBackupRetentionDays The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
 * @property dailyAutomaticBackupStartTime A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
 * @property deploymentType The filesystem deployment type. Supports `MULTI_AZ_1`, `MULTI_AZ_2`, `SINGLE_AZ_1`, and `SINGLE_AZ_2`.
 * @property diskIopsConfiguration The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
 * @property endpointIpAddressRange Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
 * @property fsxAdminPassword The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
 * @property haPairs The number of ha_pairs to deploy for the file system. Valid value is 1 for `SINGLE_AZ_1` or `MULTI_AZ_1` and `MULTI_AZ_2`. Valid values are 1 through 12 for `SINGLE_AZ_2`.
 * @property kmsKeyId ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
 * @property preferredSubnetId The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
 * @property routeTableIds Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
 * @property securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
 * @property storageCapacity The storage capacity (GiB) of the file system. Valid values between `1024` and `196608` for file systems with deployment_type `SINGLE_AZ_1` and `MULTI_AZ_1`. Valid values are between `1024` and `524288` for `MULTI_AZ_2`. Valid values between `1024` (`1024` per ha pair) and `1048576` for file systems with deployment_type `SINGLE_AZ_2`. For `SINGLE_AZ_2`, the `1048576` (1PB) maximum is only supported when using 2 or more ha_pairs, the maximum is `524288` (512TB) when using 1 ha_pair.
 * @property storageType The filesystem storage type. defaults to `SSD`.
 * @property subnetIds A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
 * @property tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property throughputCapacity Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter is only supported when not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
 * @property throughputCapacityPerHaPair Sets the per-HA-pair throughput capacity (in MBps) for the file system that you're creating, as opposed to `throughput_capacity` which specifies the total throughput capacity for the file system. Valid value for `MULTI_AZ_1` and `SINGLE_AZ_1` are `128`, `256`, `512`, `1024`, `2048`, and `4096`. Valid values for deployment type `MULTI_AZ_2` and `SINGLE_AZ_2` are `384`,`768`,`1536`,`3072`,`6144` where `ha_pairs` is `1`. Valid values for deployment type `SINGLE_AZ_2` are `1536`, `3072`, and `6144` where `ha_pairs` is greater than 1. This parameter is only supported when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
 * @property weeklyMaintenanceStartTime The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
 */
public data class OntapFileSystemArgs(
    public val automaticBackupRetentionDays: Output<Int>? = null,
    public val dailyAutomaticBackupStartTime: Output<String>? = null,
    public val deploymentType: Output<String>? = null,
    public val diskIopsConfiguration: Output<OntapFileSystemDiskIopsConfigurationArgs>? = null,
    public val endpointIpAddressRange: Output<String>? = null,
    public val fsxAdminPassword: Output<String>? = null,
    public val haPairs: Output<Int>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val preferredSubnetId: Output<String>? = null,
    public val routeTableIds: Output<List<String>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val storageCapacity: Output<Int>? = null,
    public val storageType: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throughputCapacity: Output<Int>? = null,
    public val throughputCapacityPerHaPair: Output<Int>? = null,
    public val weeklyMaintenanceStartTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.OntapFileSystemArgs> {
    override fun toJava(): com.pulumi.aws.fsx.OntapFileSystemArgs =
        com.pulumi.aws.fsx.OntapFileSystemArgs.builder()
            .automaticBackupRetentionDays(automaticBackupRetentionDays?.applyValue({ args0 -> args0 }))
            .dailyAutomaticBackupStartTime(dailyAutomaticBackupStartTime?.applyValue({ args0 -> args0 }))
            .deploymentType(deploymentType?.applyValue({ args0 -> args0 }))
            .diskIopsConfiguration(
                diskIopsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .endpointIpAddressRange(endpointIpAddressRange?.applyValue({ args0 -> args0 }))
            .fsxAdminPassword(fsxAdminPassword?.applyValue({ args0 -> args0 }))
            .haPairs(haPairs?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .preferredSubnetId(preferredSubnetId?.applyValue({ args0 -> args0 }))
            .routeTableIds(routeTableIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .storageCapacity(storageCapacity?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughputCapacity(throughputCapacity?.applyValue({ args0 -> args0 }))
            .throughputCapacityPerHaPair(throughputCapacityPerHaPair?.applyValue({ args0 -> args0 }))
            .weeklyMaintenanceStartTime(weeklyMaintenanceStartTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OntapFileSystemArgs].
 */
@PulumiTagMarker
public class OntapFileSystemArgsBuilder internal constructor() {
    private var automaticBackupRetentionDays: Output<Int>? = null

    private var dailyAutomaticBackupStartTime: Output<String>? = null

    private var deploymentType: Output<String>? = null

    private var diskIopsConfiguration: Output<OntapFileSystemDiskIopsConfigurationArgs>? = null

    private var endpointIpAddressRange: Output<String>? = null

    private var fsxAdminPassword: Output<String>? = null

    private var haPairs: Output<Int>? = null

    private var kmsKeyId: Output<String>? = null

    private var preferredSubnetId: Output<String>? = null

    private var routeTableIds: Output<List<String>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var storageCapacity: Output<Int>? = null

    private var storageType: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throughputCapacity: Output<Int>? = null

    private var throughputCapacityPerHaPair: Output<Int>? = null

    private var weeklyMaintenanceStartTime: Output<String>? = null

    /**
     * @param value The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     */
    @JvmName("wdlxarmhmvbbxqyi")
    public suspend fun automaticBackupRetentionDays(`value`: Output<Int>) {
        this.automaticBackupRetentionDays = value
    }

    /**
     * @param value A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     */
    @JvmName("louffvunlhwepijf")
    public suspend fun dailyAutomaticBackupStartTime(`value`: Output<String>) {
        this.dailyAutomaticBackupStartTime = value
    }

    /**
     * @param value The filesystem deployment type. Supports `MULTI_AZ_1`, `MULTI_AZ_2`, `SINGLE_AZ_1`, and `SINGLE_AZ_2`.
     */
    @JvmName("duondkykjwdvqntq")
    public suspend fun deploymentType(`value`: Output<String>) {
        this.deploymentType = value
    }

    /**
     * @param value The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
     */
    @JvmName("ccrcmudblpobqqda")
    public suspend fun diskIopsConfiguration(`value`: Output<OntapFileSystemDiskIopsConfigurationArgs>) {
        this.diskIopsConfiguration = value
    }

    /**
     * @param value Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
     */
    @JvmName("rboadrpqcylmuhdn")
    public suspend fun endpointIpAddressRange(`value`: Output<String>) {
        this.endpointIpAddressRange = value
    }

    /**
     * @param value The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
     */
    @JvmName("gpiudfcgjcikxsae")
    public suspend fun fsxAdminPassword(`value`: Output<String>) {
        this.fsxAdminPassword = value
    }

    /**
     * @param value The number of ha_pairs to deploy for the file system. Valid value is 1 for `SINGLE_AZ_1` or `MULTI_AZ_1` and `MULTI_AZ_2`. Valid values are 1 through 12 for `SINGLE_AZ_2`.
     */
    @JvmName("lmjavyorsosqcfsr")
    public suspend fun haPairs(`value`: Output<Int>) {
        this.haPairs = value
    }

    /**
     * @param value ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     */
    @JvmName("rklweglhtbjgsokx")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
     */
    @JvmName("hapaosrnjirktony")
    public suspend fun preferredSubnetId(`value`: Output<String>) {
        this.preferredSubnetId = value
    }

    /**
     * @param value Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("etfgorerkkmgajqv")
    public suspend fun routeTableIds(`value`: Output<List<String>>) {
        this.routeTableIds = value
    }

    @JvmName("qqneqjeqesutlvgi")
    public suspend fun routeTableIds(vararg values: Output<String>) {
        this.routeTableIds = Output.all(values.asList())
    }

    /**
     * @param values Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("yvkkmhiewfofmfch")
    public suspend fun routeTableIds(values: List<Output<String>>) {
        this.routeTableIds = Output.all(values)
    }

    /**
     * @param value A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("agghnrjxuaxovotj")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("vfudoxiqdxtivhep")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("fsbsugawmyvylmtr")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value The storage capacity (GiB) of the file system. Valid values between `1024` and `196608` for file systems with deployment_type `SINGLE_AZ_1` and `MULTI_AZ_1`. Valid values are between `1024` and `524288` for `MULTI_AZ_2`. Valid values between `1024` (`1024` per ha pair) and `1048576` for file systems with deployment_type `SINGLE_AZ_2`. For `SINGLE_AZ_2`, the `1048576` (1PB) maximum is only supported when using 2 or more ha_pairs, the maximum is `524288` (512TB) when using 1 ha_pair.
     */
    @JvmName("fpyusiahpdyvbqjm")
    public suspend fun storageCapacity(`value`: Output<Int>) {
        this.storageCapacity = value
    }

    /**
     * @param value The filesystem storage type. defaults to `SSD`.
     */
    @JvmName("rwppwgswydmmwoti")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
     */
    @JvmName("lqcsdekbbvenfodn")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("xdjfvxekbrlnkjqx")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
     */
    @JvmName("juhckooqdbncfgew")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mklrlapuytaxqfjk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter is only supported when not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
     */
    @JvmName("picycvsrysuaidfo")
    public suspend fun throughputCapacity(`value`: Output<Int>) {
        this.throughputCapacity = value
    }

    /**
     * @param value Sets the per-HA-pair throughput capacity (in MBps) for the file system that you're creating, as opposed to `throughput_capacity` which specifies the total throughput capacity for the file system. Valid value for `MULTI_AZ_1` and `SINGLE_AZ_1` are `128`, `256`, `512`, `1024`, `2048`, and `4096`. Valid values for deployment type `MULTI_AZ_2` and `SINGLE_AZ_2` are `384`,`768`,`1536`,`3072`,`6144` where `ha_pairs` is `1`. Valid values for deployment type `SINGLE_AZ_2` are `1536`, `3072`, and `6144` where `ha_pairs` is greater than 1. This parameter is only supported when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
     */
    @JvmName("cywswjqeyeyqoesw")
    public suspend fun throughputCapacityPerHaPair(`value`: Output<Int>) {
        this.throughputCapacityPerHaPair = value
    }

    /**
     * @param value The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    @JvmName("bsmmpvgubnuqxbfr")
    public suspend fun weeklyMaintenanceStartTime(`value`: Output<String>) {
        this.weeklyMaintenanceStartTime = value
    }

    /**
     * @param value The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     */
    @JvmName("xfgtpslitcsvegbk")
    public suspend fun automaticBackupRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticBackupRetentionDays = mapped
    }

    /**
     * @param value A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     */
    @JvmName("wdlyrvwnoyknofme")
    public suspend fun dailyAutomaticBackupStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyAutomaticBackupStartTime = mapped
    }

    /**
     * @param value The filesystem deployment type. Supports `MULTI_AZ_1`, `MULTI_AZ_2`, `SINGLE_AZ_1`, and `SINGLE_AZ_2`.
     */
    @JvmName("wspluelreoqntctl")
    public suspend fun deploymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
     */
    @JvmName("amvpohqulugosivh")
    public suspend fun diskIopsConfiguration(`value`: OntapFileSystemDiskIopsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIopsConfiguration = mapped
    }

    /**
     * @param argument The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system. See Disk Iops Configuration below.
     */
    @JvmName("wymthengyjchdbye")
    public suspend fun diskIopsConfiguration(argument: suspend OntapFileSystemDiskIopsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OntapFileSystemDiskIopsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.diskIopsConfiguration = mapped
    }

    /**
     * @param value Specifies the IP address range in which the endpoints to access your file system will be created. By default, Amazon FSx selects an unused IP address range for you from the 198.19.* range.
     */
    @JvmName("sbdidasqtsserahd")
    public suspend fun endpointIpAddressRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointIpAddressRange = mapped
    }

    /**
     * @param value The ONTAP administrative password for the fsxadmin user that you can use to administer your file system using the ONTAP CLI and REST API.
     */
    @JvmName("csfhvvadeeucbwop")
    public suspend fun fsxAdminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fsxAdminPassword = mapped
    }

    /**
     * @param value The number of ha_pairs to deploy for the file system. Valid value is 1 for `SINGLE_AZ_1` or `MULTI_AZ_1` and `MULTI_AZ_2`. Valid values are 1 through 12 for `SINGLE_AZ_2`.
     */
    @JvmName("vecbscyfdcydxfwi")
    public suspend fun haPairs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.haPairs = mapped
    }

    /**
     * @param value ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     */
    @JvmName("ecnucpeofkavexwy")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value The ID for a subnet. A subnet is a range of IP addresses in your virtual private cloud (VPC).
     */
    @JvmName("mkaorsbuhdjprgyb")
    public suspend fun preferredSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredSubnetId = mapped
    }

    /**
     * @param value Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("mvkkinspygpqiago")
    public suspend fun routeTableIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableIds = mapped
    }

    /**
     * @param values Specifies the VPC route tables in which your file system's endpoints will be created. You should specify all VPC route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("vnqpckehiyclpqxg")
    public suspend fun routeTableIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeTableIds = mapped
    }

    /**
     * @param value A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("cuqnjllooqraiaki")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("qstpqlontjpxdist")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value The storage capacity (GiB) of the file system. Valid values between `1024` and `196608` for file systems with deployment_type `SINGLE_AZ_1` and `MULTI_AZ_1`. Valid values are between `1024` and `524288` for `MULTI_AZ_2`. Valid values between `1024` (`1024` per ha pair) and `1048576` for file systems with deployment_type `SINGLE_AZ_2`. For `SINGLE_AZ_2`, the `1048576` (1PB) maximum is only supported when using 2 or more ha_pairs, the maximum is `524288` (512TB) when using 1 ha_pair.
     */
    @JvmName("xsidyxmfocfttrie")
    public suspend fun storageCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacity = mapped
    }

    /**
     * @param value The filesystem storage type. defaults to `SSD`.
     */
    @JvmName("ydoxdysqmlycygqq")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
     */
    @JvmName("mryvmvkjhkanffkl")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of IDs for the subnets that the file system will be accessible from. Up to 2 subnets can be provided.
     */
    @JvmName("pnfchgbmpbgodijg")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tpwovxkiywqtwdny")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wxdhywyqofolwyga")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Sets the throughput capacity (in MBps) for the file system that you're creating. Valid values are `128`, `256`, `512`, `1024`, `2048`, and `4096`. This parameter is only supported when not using the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
     */
    @JvmName("cgyaiamqrlsnvhuc")
    public suspend fun throughputCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputCapacity = mapped
    }

    /**
     * @param value Sets the per-HA-pair throughput capacity (in MBps) for the file system that you're creating, as opposed to `throughput_capacity` which specifies the total throughput capacity for the file system. Valid value for `MULTI_AZ_1` and `SINGLE_AZ_1` are `128`, `256`, `512`, `1024`, `2048`, and `4096`. Valid values for deployment type `MULTI_AZ_2` and `SINGLE_AZ_2` are `384`,`768`,`1536`,`3072`,`6144` where `ha_pairs` is `1`. Valid values for deployment type `SINGLE_AZ_2` are `1536`, `3072`, and `6144` where `ha_pairs` is greater than 1. This parameter is only supported when specifying the ha_pairs parameter. Either throughput_capacity or throughput_capacity_per_ha_pair must be specified.
     */
    @JvmName("twgwldkshnolfwnm")
    public suspend fun throughputCapacityPerHaPair(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputCapacityPerHaPair = mapped
    }

    /**
     * @param value The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    @JvmName("oargfrtjrherygbh")
    public suspend fun weeklyMaintenanceStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyMaintenanceStartTime = mapped
    }

    internal fun build(): OntapFileSystemArgs = OntapFileSystemArgs(
        automaticBackupRetentionDays = automaticBackupRetentionDays,
        dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime,
        deploymentType = deploymentType,
        diskIopsConfiguration = diskIopsConfiguration,
        endpointIpAddressRange = endpointIpAddressRange,
        fsxAdminPassword = fsxAdminPassword,
        haPairs = haPairs,
        kmsKeyId = kmsKeyId,
        preferredSubnetId = preferredSubnetId,
        routeTableIds = routeTableIds,
        securityGroupIds = securityGroupIds,
        storageCapacity = storageCapacity,
        storageType = storageType,
        subnetIds = subnetIds,
        tags = tags,
        throughputCapacity = throughputCapacity,
        throughputCapacityPerHaPair = throughputCapacityPerHaPair,
        weeklyMaintenanceStartTime = weeklyMaintenanceStartTime,
    )
}
