@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.kotlin.outputs.OntapStorageVirtualMachineActiveDirectoryConfiguration
import com.pulumi.aws.fsx.kotlin.outputs.OntapStorageVirtualMachineEndpoint
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.fsx.kotlin.outputs.OntapStorageVirtualMachineActiveDirectoryConfiguration.Companion.toKotlin as ontapStorageVirtualMachineActiveDirectoryConfigurationToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.OntapStorageVirtualMachineEndpoint.Companion.toKotlin as ontapStorageVirtualMachineEndpointToKotlin

/**
 * Builder for [OntapStorageVirtualMachine].
 */
@PulumiTagMarker
public class OntapStorageVirtualMachineResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OntapStorageVirtualMachineArgs = OntapStorageVirtualMachineArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OntapStorageVirtualMachineArgsBuilder.() -> Unit) {
        val builder = OntapStorageVirtualMachineArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OntapStorageVirtualMachine {
        val builtJavaResource = com.pulumi.aws.fsx.OntapStorageVirtualMachine(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OntapStorageVirtualMachine(builtJavaResource)
    }
}

/**
 * Manages a FSx Storage Virtual Machine.
 * See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html) for more information.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OntapStorageVirtualMachine("test", {
 *     fileSystemId: testAwsFsxOntapFileSystem.id,
 *     name: "test",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OntapStorageVirtualMachine("test",
 *     file_system_id=test_aws_fsx_ontap_file_system["id"],
 *     name="test")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OntapStorageVirtualMachine("test", new()
 *     {
 *         FileSystemId = testAwsFsxOntapFileSystem.Id,
 *         Name = "test",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapStorageVirtualMachine(ctx, "test", &fsx.OntapStorageVirtualMachineArgs{
 * 			FileSystemId: pulumi.Any(testAwsFsxOntapFileSystem.Id),
 * 			Name:         pulumi.String("test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapStorageVirtualMachine;
 * import com.pulumi.aws.fsx.OntapStorageVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapStorageVirtualMachine("test", OntapStorageVirtualMachineArgs.builder()
 *             .fileSystemId(testAwsFsxOntapFileSystem.id())
 *             .name("test")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OntapStorageVirtualMachine
 *     properties:
 *       fileSystemId: ${testAwsFsxOntapFileSystem.id}
 *       name: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using a Self-Managed Microsoft Active Directory
 * Additional information for using AWS Directory Service with ONTAP File Systems can be found in the [FSx ONTAP Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/self-managed-AD.html).
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OntapStorageVirtualMachine("test", {
 *     fileSystemId: testAwsFsxOntapFileSystem.id,
 *     name: "mysvm",
 *     activeDirectoryConfiguration: {
 *         netbiosName: "mysvm",
 *         selfManagedActiveDirectoryConfiguration: {
 *             dnsIps: [
 *                 "10.0.0.111",
 *                 "10.0.0.222",
 *             ],
 *             domainName: "corp.example.com",
 *             password: "avoid-plaintext-passwords",
 *             username: "Admin",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OntapStorageVirtualMachine("test",
 *     file_system_id=test_aws_fsx_ontap_file_system["id"],
 *     name="mysvm",
 *     active_directory_configuration={
 *         "netbios_name": "mysvm",
 *         "self_managed_active_directory_configuration": {
 *             "dns_ips": [
 *                 "10.0.0.111",
 *                 "10.0.0.222",
 *             ],
 *             "domain_name": "corp.example.com",
 *             "password": "avoid-plaintext-passwords",
 *             "username": "Admin",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OntapStorageVirtualMachine("test", new()
 *     {
 *         FileSystemId = testAwsFsxOntapFileSystem.Id,
 *         Name = "mysvm",
 *         ActiveDirectoryConfiguration = new Aws.Fsx.Inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs
 *         {
 *             NetbiosName = "mysvm",
 *             SelfManagedActiveDirectoryConfiguration = new Aws.Fsx.Inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs
 *             {
 *                 DnsIps = new[]
 *                 {
 *                     "10.0.0.111",
 *                     "10.0.0.222",
 *                 },
 *                 DomainName = "corp.example.com",
 *                 Password = "avoid-plaintext-passwords",
 *                 Username = "Admin",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapStorageVirtualMachine(ctx, "test", &fsx.OntapStorageVirtualMachineArgs{
 * 			FileSystemId: pulumi.Any(testAwsFsxOntapFileSystem.Id),
 * 			Name:         pulumi.String("mysvm"),
 * 			ActiveDirectoryConfiguration: &fsx.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs{
 * 				NetbiosName: pulumi.String("mysvm"),
 * 				SelfManagedActiveDirectoryConfiguration: &fsx.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs{
 * 					DnsIps: pulumi.StringArray{
 * 						pulumi.String("10.0.0.111"),
 * 						pulumi.String("10.0.0.222"),
 * 					},
 * 					DomainName: pulumi.String("corp.example.com"),
 * 					Password:   pulumi.String("avoid-plaintext-passwords"),
 * 					Username:   pulumi.String("Admin"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapStorageVirtualMachine;
 * import com.pulumi.aws.fsx.OntapStorageVirtualMachineArgs;
 * import com.pulumi.aws.fsx.inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs;
 * import com.pulumi.aws.fsx.inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapStorageVirtualMachine("test", OntapStorageVirtualMachineArgs.builder()
 *             .fileSystemId(testAwsFsxOntapFileSystem.id())
 *             .name("mysvm")
 *             .activeDirectoryConfiguration(OntapStorageVirtualMachineActiveDirectoryConfigurationArgs.builder()
 *                 .netbiosName("mysvm")
 *                 .selfManagedActiveDirectoryConfiguration(OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs.builder()
 *                     .dnsIps(
 *                         "10.0.0.111",
 *                         "10.0.0.222")
 *                     .domainName("corp.example.com")
 *                     .password("avoid-plaintext-passwords")
 *                     .username("Admin")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OntapStorageVirtualMachine
 *     properties:
 *       fileSystemId: ${testAwsFsxOntapFileSystem.id}
 *       name: mysvm
 *       activeDirectoryConfiguration:
 *         netbiosName: mysvm
 *         selfManagedActiveDirectoryConfiguration:
 *           dnsIps:
 *             - 10.0.0.111
 *             - 10.0.0.222
 *           domainName: corp.example.com
 *           password: avoid-plaintext-passwords
 *           username: Admin
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx Storage Virtual Machine using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/ontapStorageVirtualMachine:OntapStorageVirtualMachine example svm-12345678abcdef123
 * ```
 * Certain resource arguments, like `svm_admin_password` and the `self_managed_active_directory` configuation block `password`, do not have a FSx API method for reading the information after creation. If these arguments are set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 */
public class OntapStorageVirtualMachine internal constructor(
    override val javaResource: com.pulumi.aws.fsx.OntapStorageVirtualMachine,
) : KotlinCustomResource(javaResource, OntapStorageVirtualMachineMapper) {
    /**
     * Configuration block that Amazon FSx uses to join the FSx ONTAP Storage Virtual Machine(SVM) to your Microsoft Active Directory (AD) directory. Detailed below.
     */
    public val activeDirectoryConfiguration:
        Output<OntapStorageVirtualMachineActiveDirectoryConfiguration>?
        get() = javaResource.activeDirectoryConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ontapStorageVirtualMachineActiveDirectoryConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name of the storage virtual machine.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The endpoints that are used to access data or to manage the storage virtual machine using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. See Endpoints below.
     */
    public val endpoints: Output<List<OntapStorageVirtualMachineEndpoint>>
        get() = javaResource.endpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    ontapStorageVirtualMachineEndpointToKotlin(args0)
                })
            })
        })

    /**
     * The ID of the Amazon FSx ONTAP File System that this SVM will be created on.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * The name of the SVM. You can use a maximum of 47 alphanumeric characters, plus the underscore (_) special character.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the root volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. All volumes created under this SVM will inherit the root security style unless the security style is specified on the volume. Default value is `UNIX`.
     */
    public val rootVolumeSecurityStyle: Output<String>?
        get() = javaResource.rootVolumeSecurityStyle().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes the SVM's subtype, e.g. `DEFAULT`
     */
    public val subtype: Output<String>
        get() = javaResource.subtype().applyValue({ args0 -> args0 })

    /**
     * Specifies the password to use when logging on to the SVM using a secure shell (SSH) connection to the SVM's management endpoint. Doing so enables you to manage the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's fsxadmin user to manage the SVM.
     */
    public val svmAdminPassword: Output<String>?
        get() = javaResource.svmAdminPassword().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the storage virtual machine. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The SVM's UUID (universally unique identifier).
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })
}

public object OntapStorageVirtualMachineMapper : ResourceMapper<OntapStorageVirtualMachine> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fsx.OntapStorageVirtualMachine::class == javaResource::class

    override fun map(javaResource: Resource): OntapStorageVirtualMachine =
        OntapStorageVirtualMachine(javaResource as com.pulumi.aws.fsx.OntapStorageVirtualMachine)
}

/**
 * @see [OntapStorageVirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OntapStorageVirtualMachine].
 */
public suspend fun ontapStorageVirtualMachine(
    name: String,
    block: suspend OntapStorageVirtualMachineResourceBuilder.() -> Unit,
): OntapStorageVirtualMachine {
    val builder = OntapStorageVirtualMachineResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OntapStorageVirtualMachine].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ontapStorageVirtualMachine(name: String): OntapStorageVirtualMachine {
    val builder = OntapStorageVirtualMachineResourceBuilder()
    builder.name(name)
    return builder.build()
}
