@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.OntapStorageVirtualMachineArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a FSx Storage Virtual Machine.
 * See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-svms.html) for more information.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OntapStorageVirtualMachine("test", {
 *     fileSystemId: testAwsFsxOntapFileSystem.id,
 *     name: "test",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OntapStorageVirtualMachine("test",
 *     file_system_id=test_aws_fsx_ontap_file_system["id"],
 *     name="test")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OntapStorageVirtualMachine("test", new()
 *     {
 *         FileSystemId = testAwsFsxOntapFileSystem.Id,
 *         Name = "test",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapStorageVirtualMachine(ctx, "test", &fsx.OntapStorageVirtualMachineArgs{
 * 			FileSystemId: pulumi.Any(testAwsFsxOntapFileSystem.Id),
 * 			Name:         pulumi.String("test"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapStorageVirtualMachine;
 * import com.pulumi.aws.fsx.OntapStorageVirtualMachineArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapStorageVirtualMachine("test", OntapStorageVirtualMachineArgs.builder()
 *             .fileSystemId(testAwsFsxOntapFileSystem.id())
 *             .name("test")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OntapStorageVirtualMachine
 *     properties:
 *       fileSystemId: ${testAwsFsxOntapFileSystem.id}
 *       name: test
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using a Self-Managed Microsoft Active Directory
 * Additional information for using AWS Directory Service with ONTAP File Systems can be found in the [FSx ONTAP Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/self-managed-AD.html).
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OntapStorageVirtualMachine("test", {
 *     fileSystemId: testAwsFsxOntapFileSystem.id,
 *     name: "mysvm",
 *     activeDirectoryConfiguration: {
 *         netbiosName: "mysvm",
 *         selfManagedActiveDirectoryConfiguration: {
 *             dnsIps: [
 *                 "10.0.0.111",
 *                 "10.0.0.222",
 *             ],
 *             domainName: "corp.example.com",
 *             password: "avoid-plaintext-passwords",
 *             username: "Admin",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OntapStorageVirtualMachine("test",
 *     file_system_id=test_aws_fsx_ontap_file_system["id"],
 *     name="mysvm",
 *     active_directory_configuration={
 *         "netbios_name": "mysvm",
 *         "self_managed_active_directory_configuration": {
 *             "dns_ips": [
 *                 "10.0.0.111",
 *                 "10.0.0.222",
 *             ],
 *             "domain_name": "corp.example.com",
 *             "password": "avoid-plaintext-passwords",
 *             "username": "Admin",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OntapStorageVirtualMachine("test", new()
 *     {
 *         FileSystemId = testAwsFsxOntapFileSystem.Id,
 *         Name = "mysvm",
 *         ActiveDirectoryConfiguration = new Aws.Fsx.Inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs
 *         {
 *             NetbiosName = "mysvm",
 *             SelfManagedActiveDirectoryConfiguration = new Aws.Fsx.Inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs
 *             {
 *                 DnsIps = new[]
 *                 {
 *                     "10.0.0.111",
 *                     "10.0.0.222",
 *                 },
 *                 DomainName = "corp.example.com",
 *                 Password = "avoid-plaintext-passwords",
 *                 Username = "Admin",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapStorageVirtualMachine(ctx, "test", &fsx.OntapStorageVirtualMachineArgs{
 * 			FileSystemId: pulumi.Any(testAwsFsxOntapFileSystem.Id),
 * 			Name:         pulumi.String("mysvm"),
 * 			ActiveDirectoryConfiguration: &fsx.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs{
 * 				NetbiosName: pulumi.String("mysvm"),
 * 				SelfManagedActiveDirectoryConfiguration: &fsx.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs{
 * 					DnsIps: pulumi.StringArray{
 * 						pulumi.String("10.0.0.111"),
 * 						pulumi.String("10.0.0.222"),
 * 					},
 * 					DomainName: pulumi.String("corp.example.com"),
 * 					Password:   pulumi.String("avoid-plaintext-passwords"),
 * 					Username:   pulumi.String("Admin"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapStorageVirtualMachine;
 * import com.pulumi.aws.fsx.OntapStorageVirtualMachineArgs;
 * import com.pulumi.aws.fsx.inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs;
 * import com.pulumi.aws.fsx.inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapStorageVirtualMachine("test", OntapStorageVirtualMachineArgs.builder()
 *             .fileSystemId(testAwsFsxOntapFileSystem.id())
 *             .name("mysvm")
 *             .activeDirectoryConfiguration(OntapStorageVirtualMachineActiveDirectoryConfigurationArgs.builder()
 *                 .netbiosName("mysvm")
 *                 .selfManagedActiveDirectoryConfiguration(OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs.builder()
 *                     .dnsIps(
 *                         "10.0.0.111",
 *                         "10.0.0.222")
 *                     .domainName("corp.example.com")
 *                     .password("avoid-plaintext-passwords")
 *                     .username("Admin")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OntapStorageVirtualMachine
 *     properties:
 *       fileSystemId: ${testAwsFsxOntapFileSystem.id}
 *       name: mysvm
 *       activeDirectoryConfiguration:
 *         netbiosName: mysvm
 *         selfManagedActiveDirectoryConfiguration:
 *           dnsIps:
 *             - 10.0.0.111
 *             - 10.0.0.222
 *           domainName: corp.example.com
 *           password: avoid-plaintext-passwords
 *           username: Admin
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx Storage Virtual Machine using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/ontapStorageVirtualMachine:OntapStorageVirtualMachine example svm-12345678abcdef123
 * ```
 * Certain resource arguments, like `svm_admin_password` and the `self_managed_active_directory` configuation block `password`, do not have a FSx API method for reading the information after creation. If these arguments are set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property activeDirectoryConfiguration Configuration block that Amazon FSx uses to join the FSx ONTAP Storage Virtual Machine(SVM) to your Microsoft Active Directory (AD) directory. Detailed below.
 * @property fileSystemId The ID of the Amazon FSx ONTAP File System that this SVM will be created on.
 * @property name The name of the SVM. You can use a maximum of 47 alphanumeric characters, plus the underscore (_) special character.
 * @property rootVolumeSecurityStyle Specifies the root volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. All volumes created under this SVM will inherit the root security style unless the security style is specified on the volume. Default value is `UNIX`.
 * @property svmAdminPassword Specifies the password to use when logging on to the SVM using a secure shell (SSH) connection to the SVM's management endpoint. Doing so enables you to manage the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's fsxadmin user to manage the SVM.
 * @property tags A map of tags to assign to the storage virtual machine. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class OntapStorageVirtualMachineArgs(
    public val activeDirectoryConfiguration: Output<OntapStorageVirtualMachineActiveDirectoryConfigurationArgs>? = null,
    public val fileSystemId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val rootVolumeSecurityStyle: Output<String>? = null,
    public val svmAdminPassword: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.OntapStorageVirtualMachineArgs> {
    override fun toJava(): com.pulumi.aws.fsx.OntapStorageVirtualMachineArgs =
        com.pulumi.aws.fsx.OntapStorageVirtualMachineArgs.builder()
            .activeDirectoryConfiguration(
                activeDirectoryConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .rootVolumeSecurityStyle(rootVolumeSecurityStyle?.applyValue({ args0 -> args0 }))
            .svmAdminPassword(svmAdminPassword?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [OntapStorageVirtualMachineArgs].
 */
@PulumiTagMarker
public class OntapStorageVirtualMachineArgsBuilder internal constructor() {
    private var activeDirectoryConfiguration:
        Output<OntapStorageVirtualMachineActiveDirectoryConfigurationArgs>? = null

    private var fileSystemId: Output<String>? = null

    private var name: Output<String>? = null

    private var rootVolumeSecurityStyle: Output<String>? = null

    private var svmAdminPassword: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Configuration block that Amazon FSx uses to join the FSx ONTAP Storage Virtual Machine(SVM) to your Microsoft Active Directory (AD) directory. Detailed below.
     */
    @JvmName("fyixhevpvkghycmj")
    public suspend fun activeDirectoryConfiguration(`value`: Output<OntapStorageVirtualMachineActiveDirectoryConfigurationArgs>) {
        this.activeDirectoryConfiguration = value
    }

    /**
     * @param value The ID of the Amazon FSx ONTAP File System that this SVM will be created on.
     */
    @JvmName("qfttgwfubrvhdlit")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The name of the SVM. You can use a maximum of 47 alphanumeric characters, plus the underscore (_) special character.
     */
    @JvmName("jdfqoobyujoeuvri")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the root volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. All volumes created under this SVM will inherit the root security style unless the security style is specified on the volume. Default value is `UNIX`.
     */
    @JvmName("lrsalwygrwlhnhvn")
    public suspend fun rootVolumeSecurityStyle(`value`: Output<String>) {
        this.rootVolumeSecurityStyle = value
    }

    /**
     * @param value Specifies the password to use when logging on to the SVM using a secure shell (SSH) connection to the SVM's management endpoint. Doing so enables you to manage the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's fsxadmin user to manage the SVM.
     */
    @JvmName("otxlfyegjxihaxii")
    public suspend fun svmAdminPassword(`value`: Output<String>) {
        this.svmAdminPassword = value
    }

    /**
     * @param value A map of tags to assign to the storage virtual machine. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xcnkhpyokqvaqswr")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block that Amazon FSx uses to join the FSx ONTAP Storage Virtual Machine(SVM) to your Microsoft Active Directory (AD) directory. Detailed below.
     */
    @JvmName("jpipsugarohqgnuh")
    public suspend fun activeDirectoryConfiguration(`value`: OntapStorageVirtualMachineActiveDirectoryConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryConfiguration = mapped
    }

    /**
     * @param argument Configuration block that Amazon FSx uses to join the FSx ONTAP Storage Virtual Machine(SVM) to your Microsoft Active Directory (AD) directory. Detailed below.
     */
    @JvmName("swxkshemomlmrrmu")
    public suspend fun activeDirectoryConfiguration(argument: suspend OntapStorageVirtualMachineActiveDirectoryConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            OntapStorageVirtualMachineActiveDirectoryConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.activeDirectoryConfiguration = mapped
    }

    /**
     * @param value The ID of the Amazon FSx ONTAP File System that this SVM will be created on.
     */
    @JvmName("ibguyijfoipbxvwi")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The name of the SVM. You can use a maximum of 47 alphanumeric characters, plus the underscore (_) special character.
     */
    @JvmName("kprsithanyktpjiq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the root volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`. All volumes created under this SVM will inherit the root security style unless the security style is specified on the volume. Default value is `UNIX`.
     */
    @JvmName("bxrwilmycreawrcy")
    public suspend fun rootVolumeSecurityStyle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootVolumeSecurityStyle = mapped
    }

    /**
     * @param value Specifies the password to use when logging on to the SVM using a secure shell (SSH) connection to the SVM's management endpoint. Doing so enables you to manage the SVM using the NetApp ONTAP CLI or REST API. If you do not specify a password, you can still use the file system's fsxadmin user to manage the SVM.
     */
    @JvmName("hoornayoggxgnjpi")
    public suspend fun svmAdminPassword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.svmAdminPassword = mapped
    }

    /**
     * @param value A map of tags to assign to the storage virtual machine. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vordwrbiapfnxntm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the storage virtual machine. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("yodrdsnqtnwngvpf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): OntapStorageVirtualMachineArgs = OntapStorageVirtualMachineArgs(
        activeDirectoryConfiguration = activeDirectoryConfiguration,
        fileSystemId = fileSystemId,
        name = name,
        rootVolumeSecurityStyle = rootVolumeSecurityStyle,
        svmAdminPassword = svmAdminPassword,
        tags = tags,
    )
}
