@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeAggregateConfiguration
import com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeSnaplockConfiguration
import com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeTieringPolicy
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeAggregateConfiguration.Companion.toKotlin as ontapVolumeAggregateConfigurationToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeSnaplockConfiguration.Companion.toKotlin as ontapVolumeSnaplockConfigurationToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.OntapVolumeTieringPolicy.Companion.toKotlin as ontapVolumeTieringPolicyToKotlin

/**
 * Builder for [OntapVolume].
 */
@PulumiTagMarker
public class OntapVolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OntapVolumeArgs = OntapVolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OntapVolumeArgsBuilder.() -> Unit) {
        val builder = OntapVolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OntapVolume {
        val builtJavaResource = com.pulumi.aws.fsx.OntapVolume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OntapVolume(builtJavaResource)
    }
}

/**
 * Manages a FSx ONTAP Volume.
 * See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html) for more information.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OntapVolume("test", {
 *     name: "test",
 *     junctionPath: "/test",
 *     sizeInMegabytes: 1024,
 *     storageEfficiencyEnabled: true,
 *     storageVirtualMachineId: testAwsFsxOntapStorageVirtualMachine.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OntapVolume("test",
 *     name="test",
 *     junction_path="/test",
 *     size_in_megabytes=1024,
 *     storage_efficiency_enabled=True,
 *     storage_virtual_machine_id=test_aws_fsx_ontap_storage_virtual_machine["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OntapVolume("test", new()
 *     {
 *         Name = "test",
 *         JunctionPath = "/test",
 *         SizeInMegabytes = 1024,
 *         StorageEfficiencyEnabled = true,
 *         StorageVirtualMachineId = testAwsFsxOntapStorageVirtualMachine.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapVolume(ctx, "test", &fsx.OntapVolumeArgs{
 * 			Name:                     pulumi.String("test"),
 * 			JunctionPath:             pulumi.String("/test"),
 * 			SizeInMegabytes:          pulumi.Int(1024),
 * 			StorageEfficiencyEnabled: pulumi.Bool(true),
 * 			StorageVirtualMachineId:  pulumi.Any(testAwsFsxOntapStorageVirtualMachine.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapVolume;
 * import com.pulumi.aws.fsx.OntapVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapVolume("test", OntapVolumeArgs.builder()
 *             .name("test")
 *             .junctionPath("/test")
 *             .sizeInMegabytes(1024)
 *             .storageEfficiencyEnabled(true)
 *             .storageVirtualMachineId(testAwsFsxOntapStorageVirtualMachine.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OntapVolume
 *     properties:
 *       name: test
 *       junctionPath: /test
 *       sizeInMegabytes: 1024
 *       storageEfficiencyEnabled: true
 *       storageVirtualMachineId: ${testAwsFsxOntapStorageVirtualMachine.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using Tiering Policy
 * Additional information on tiering policy with ONTAP Volumes can be found in the [FSx ONTAP Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html).
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OntapVolume("test", {
 *     name: "test",
 *     junctionPath: "/test",
 *     sizeInMegabytes: 1024,
 *     storageEfficiencyEnabled: true,
 *     storageVirtualMachineId: testAwsFsxOntapStorageVirtualMachine.id,
 *     tieringPolicy: {
 *         name: "AUTO",
 *         coolingPeriod: 31,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OntapVolume("test",
 *     name="test",
 *     junction_path="/test",
 *     size_in_megabytes=1024,
 *     storage_efficiency_enabled=True,
 *     storage_virtual_machine_id=test_aws_fsx_ontap_storage_virtual_machine["id"],
 *     tiering_policy={
 *         "name": "AUTO",
 *         "cooling_period": 31,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OntapVolume("test", new()
 *     {
 *         Name = "test",
 *         JunctionPath = "/test",
 *         SizeInMegabytes = 1024,
 *         StorageEfficiencyEnabled = true,
 *         StorageVirtualMachineId = testAwsFsxOntapStorageVirtualMachine.Id,
 *         TieringPolicy = new Aws.Fsx.Inputs.OntapVolumeTieringPolicyArgs
 *         {
 *             Name = "AUTO",
 *             CoolingPeriod = 31,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapVolume(ctx, "test", &fsx.OntapVolumeArgs{
 * 			Name:                     pulumi.String("test"),
 * 			JunctionPath:             pulumi.String("/test"),
 * 			SizeInMegabytes:          pulumi.Int(1024),
 * 			StorageEfficiencyEnabled: pulumi.Bool(true),
 * 			StorageVirtualMachineId:  pulumi.Any(testAwsFsxOntapStorageVirtualMachine.Id),
 * 			TieringPolicy: &fsx.OntapVolumeTieringPolicyArgs{
 * 				Name:          pulumi.String("AUTO"),
 * 				CoolingPeriod: pulumi.Int(31),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapVolume;
 * import com.pulumi.aws.fsx.OntapVolumeArgs;
 * import com.pulumi.aws.fsx.inputs.OntapVolumeTieringPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapVolume("test", OntapVolumeArgs.builder()
 *             .name("test")
 *             .junctionPath("/test")
 *             .sizeInMegabytes(1024)
 *             .storageEfficiencyEnabled(true)
 *             .storageVirtualMachineId(testAwsFsxOntapStorageVirtualMachine.id())
 *             .tieringPolicy(OntapVolumeTieringPolicyArgs.builder()
 *                 .name("AUTO")
 *                 .coolingPeriod(31)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OntapVolume
 *     properties:
 *       name: test
 *       junctionPath: /test
 *       sizeInMegabytes: 1024
 *       storageEfficiencyEnabled: true
 *       storageVirtualMachineId: ${testAwsFsxOntapStorageVirtualMachine.id}
 *       tieringPolicy:
 *         name: AUTO
 *         coolingPeriod: 31
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx ONTAP volume using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/ontapVolume:OntapVolume example fsvol-12345678abcdef123
 * ```
 */
public class OntapVolume internal constructor(
    override val javaResource: com.pulumi.aws.fsx.OntapVolume,
) : KotlinCustomResource(javaResource, OntapVolumeMapper) {
    /**
     * The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
     */
    public val aggregateConfiguration: Output<OntapVolumeAggregateConfiguration>?
        get() = javaResource.aggregateConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ontapVolumeAggregateConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name of the volune.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    public val bypassSnaplockEnterpriseRetention: Output<Boolean>?
        get() = javaResource.bypassSnaplockEnterpriseRetention().applyValue({ args0 ->
            args0.map({ args0 -> args0 }).orElse(null)
        })

    /**
     * A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
     */
    public val copyTagsToBackups: Output<Boolean>?
        get() = javaResource.copyTagsToBackups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Describes the file system for the volume, e.g. `fs-12345679`
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to apply to the volume's final backup.
     */
    public val finalBackupTags: Output<Map<String, String>>?
        get() = javaResource.finalBackupTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * Specifies the FlexCache endpoint type of the volume, Valid values are `NONE`, `ORIGIN`, `CACHE`. Default value is `NONE`. These can be set by the ONTAP CLI or API and are use with FlexCache feature.
     */
    public val flexcacheEndpointType: Output<String>
        get() = javaResource.flexcacheEndpointType().applyValue({ args0 -> args0 })

    /**
     * Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
     */
    public val junctionPath: Output<String>?
        get() = javaResource.junctionPath().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
     */
    public val ontapVolumeType: Output<String>
        get() = javaResource.ontapVolumeType().applyValue({ args0 -> args0 })

    /**
     * Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
     */
    public val securityStyle: Output<String>
        get() = javaResource.securityStyle().applyValue({ args0 -> args0 })

    /**
     * Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
     */
    public val sizeInBytes: Output<String>
        get() = javaResource.sizeInBytes().applyValue({ args0 -> args0 })

    /**
     * Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
     */
    public val sizeInMegabytes: Output<Int>
        get() = javaResource.sizeInMegabytes().applyValue({ args0 -> args0 })

    /**
     * When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    public val skipFinalBackup: Output<Boolean>?
        get() = javaResource.skipFinalBackup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
     */
    public val snaplockConfiguration: Output<OntapVolumeSnaplockConfiguration>?
        get() = javaResource.snaplockConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ontapVolumeSnaplockConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
     */
    public val snapshotPolicy: Output<String>
        get() = javaResource.snapshotPolicy().applyValue({ args0 -> args0 })

    /**
     * Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
     */
    public val storageEfficiencyEnabled: Output<Boolean>?
        get() = javaResource.storageEfficiencyEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Specifies the storage virtual machine in which to create the volume.
     * The following arguments are optional:
     */
    public val storageVirtualMachineId: Output<String>
        get() = javaResource.storageVirtualMachineId().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
     */
    public val tieringPolicy: Output<OntapVolumeTieringPolicy>?
        get() = javaResource.tieringPolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> ontapVolumeTieringPolicyToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The Volume's UUID (universally unique identifier).
     */
    public val uuid: Output<String>
        get() = javaResource.uuid().applyValue({ args0 -> args0 })

    /**
     * Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
     */
    public val volumeStyle: Output<String>
        get() = javaResource.volumeStyle().applyValue({ args0 -> args0 })

    /**
     * The type of volume, currently the only valid value is `ONTAP`.
     */
    public val volumeType: Output<String>?
        get() = javaResource.volumeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object OntapVolumeMapper : ResourceMapper<OntapVolume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fsx.OntapVolume::class == javaResource::class

    override fun map(javaResource: Resource): OntapVolume = OntapVolume(
        javaResource as
            com.pulumi.aws.fsx.OntapVolume,
    )
}

/**
 * @see [OntapVolume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OntapVolume].
 */
public suspend fun ontapVolume(name: String, block: suspend OntapVolumeResourceBuilder.() -> Unit): OntapVolume {
    val builder = OntapVolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OntapVolume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ontapVolume(name: String): OntapVolume {
    val builder = OntapVolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
