@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.OntapVolumeArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.OntapVolumeAggregateConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.OntapVolumeAggregateConfigurationArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.OntapVolumeSnaplockConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.OntapVolumeSnaplockConfigurationArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.OntapVolumeTieringPolicyArgs
import com.pulumi.aws.fsx.kotlin.inputs.OntapVolumeTieringPolicyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages a FSx ONTAP Volume.
 * See the [FSx ONTAP User Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html) for more information.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OntapVolume("test", {
 *     name: "test",
 *     junctionPath: "/test",
 *     sizeInMegabytes: 1024,
 *     storageEfficiencyEnabled: true,
 *     storageVirtualMachineId: testAwsFsxOntapStorageVirtualMachine.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OntapVolume("test",
 *     name="test",
 *     junction_path="/test",
 *     size_in_megabytes=1024,
 *     storage_efficiency_enabled=True,
 *     storage_virtual_machine_id=test_aws_fsx_ontap_storage_virtual_machine["id"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OntapVolume("test", new()
 *     {
 *         Name = "test",
 *         JunctionPath = "/test",
 *         SizeInMegabytes = 1024,
 *         StorageEfficiencyEnabled = true,
 *         StorageVirtualMachineId = testAwsFsxOntapStorageVirtualMachine.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapVolume(ctx, "test", &fsx.OntapVolumeArgs{
 * 			Name:                     pulumi.String("test"),
 * 			JunctionPath:             pulumi.String("/test"),
 * 			SizeInMegabytes:          pulumi.Int(1024),
 * 			StorageEfficiencyEnabled: pulumi.Bool(true),
 * 			StorageVirtualMachineId:  pulumi.Any(testAwsFsxOntapStorageVirtualMachine.Id),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapVolume;
 * import com.pulumi.aws.fsx.OntapVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapVolume("test", OntapVolumeArgs.builder()
 *             .name("test")
 *             .junctionPath("/test")
 *             .sizeInMegabytes(1024)
 *             .storageEfficiencyEnabled(true)
 *             .storageVirtualMachineId(testAwsFsxOntapStorageVirtualMachine.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OntapVolume
 *     properties:
 *       name: test
 *       junctionPath: /test
 *       sizeInMegabytes: 1024
 *       storageEfficiencyEnabled: true
 *       storageVirtualMachineId: ${testAwsFsxOntapStorageVirtualMachine.id}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using Tiering Policy
 * Additional information on tiering policy with ONTAP Volumes can be found in the [FSx ONTAP Guide](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/managing-volumes.html).
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OntapVolume("test", {
 *     name: "test",
 *     junctionPath: "/test",
 *     sizeInMegabytes: 1024,
 *     storageEfficiencyEnabled: true,
 *     storageVirtualMachineId: testAwsFsxOntapStorageVirtualMachine.id,
 *     tieringPolicy: {
 *         name: "AUTO",
 *         coolingPeriod: 31,
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OntapVolume("test",
 *     name="test",
 *     junction_path="/test",
 *     size_in_megabytes=1024,
 *     storage_efficiency_enabled=True,
 *     storage_virtual_machine_id=test_aws_fsx_ontap_storage_virtual_machine["id"],
 *     tiering_policy={
 *         "name": "AUTO",
 *         "cooling_period": 31,
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OntapVolume("test", new()
 *     {
 *         Name = "test",
 *         JunctionPath = "/test",
 *         SizeInMegabytes = 1024,
 *         StorageEfficiencyEnabled = true,
 *         StorageVirtualMachineId = testAwsFsxOntapStorageVirtualMachine.Id,
 *         TieringPolicy = new Aws.Fsx.Inputs.OntapVolumeTieringPolicyArgs
 *         {
 *             Name = "AUTO",
 *             CoolingPeriod = 31,
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOntapVolume(ctx, "test", &fsx.OntapVolumeArgs{
 * 			Name:                     pulumi.String("test"),
 * 			JunctionPath:             pulumi.String("/test"),
 * 			SizeInMegabytes:          pulumi.Int(1024),
 * 			StorageEfficiencyEnabled: pulumi.Bool(true),
 * 			StorageVirtualMachineId:  pulumi.Any(testAwsFsxOntapStorageVirtualMachine.Id),
 * 			TieringPolicy: &fsx.OntapVolumeTieringPolicyArgs{
 * 				Name:          pulumi.String("AUTO"),
 * 				CoolingPeriod: pulumi.Int(31),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OntapVolume;
 * import com.pulumi.aws.fsx.OntapVolumeArgs;
 * import com.pulumi.aws.fsx.inputs.OntapVolumeTieringPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OntapVolume("test", OntapVolumeArgs.builder()
 *             .name("test")
 *             .junctionPath("/test")
 *             .sizeInMegabytes(1024)
 *             .storageEfficiencyEnabled(true)
 *             .storageVirtualMachineId(testAwsFsxOntapStorageVirtualMachine.id())
 *             .tieringPolicy(OntapVolumeTieringPolicyArgs.builder()
 *                 .name("AUTO")
 *                 .coolingPeriod(31)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OntapVolume
 *     properties:
 *       name: test
 *       junctionPath: /test
 *       sizeInMegabytes: 1024
 *       storageEfficiencyEnabled: true
 *       storageVirtualMachineId: ${testAwsFsxOntapStorageVirtualMachine.id}
 *       tieringPolicy:
 *         name: AUTO
 *         coolingPeriod: 31
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx ONTAP volume using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/ontapVolume:OntapVolume example fsvol-12345678abcdef123
 * ```
 * @property aggregateConfiguration The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
 * @property bypassSnaplockEnterpriseRetention Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
 * @property copyTagsToBackups A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
 * @property finalBackupTags A map of tags to apply to the volume's final backup.
 * @property junctionPath Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
 * @property name The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
 * @property ontapVolumeType Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
 * @property securityStyle Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
 * @property sizeInBytes Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
 * @property sizeInMegabytes Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
 * @property skipFinalBackup When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
 * @property snaplockConfiguration The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
 * @property snapshotPolicy Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
 * @property storageEfficiencyEnabled Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
 * @property storageVirtualMachineId Specifies the storage virtual machine in which to create the volume.
 * The following arguments are optional:
 * @property tags A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property tieringPolicy The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
 * @property volumeStyle Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
 * @property volumeType The type of volume, currently the only valid value is `ONTAP`.
 */
public data class OntapVolumeArgs(
    public val aggregateConfiguration: Output<OntapVolumeAggregateConfigurationArgs>? = null,
    public val bypassSnaplockEnterpriseRetention: Output<Boolean>? = null,
    public val copyTagsToBackups: Output<Boolean>? = null,
    public val finalBackupTags: Output<Map<String, String>>? = null,
    public val junctionPath: Output<String>? = null,
    public val name: Output<String>? = null,
    public val ontapVolumeType: Output<String>? = null,
    public val securityStyle: Output<String>? = null,
    public val sizeInBytes: Output<String>? = null,
    public val sizeInMegabytes: Output<Int>? = null,
    public val skipFinalBackup: Output<Boolean>? = null,
    public val snaplockConfiguration: Output<OntapVolumeSnaplockConfigurationArgs>? = null,
    public val snapshotPolicy: Output<String>? = null,
    public val storageEfficiencyEnabled: Output<Boolean>? = null,
    public val storageVirtualMachineId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tieringPolicy: Output<OntapVolumeTieringPolicyArgs>? = null,
    public val volumeStyle: Output<String>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.OntapVolumeArgs> {
    override fun toJava(): com.pulumi.aws.fsx.OntapVolumeArgs =
        com.pulumi.aws.fsx.OntapVolumeArgs.builder()
            .aggregateConfiguration(
                aggregateConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .bypassSnaplockEnterpriseRetention(
                bypassSnaplockEnterpriseRetention?.applyValue({ args0 ->
                    args0
                }),
            )
            .copyTagsToBackups(copyTagsToBackups?.applyValue({ args0 -> args0 }))
            .finalBackupTags(
                finalBackupTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .junctionPath(junctionPath?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .ontapVolumeType(ontapVolumeType?.applyValue({ args0 -> args0 }))
            .securityStyle(securityStyle?.applyValue({ args0 -> args0 }))
            .sizeInBytes(sizeInBytes?.applyValue({ args0 -> args0 }))
            .sizeInMegabytes(sizeInMegabytes?.applyValue({ args0 -> args0 }))
            .skipFinalBackup(skipFinalBackup?.applyValue({ args0 -> args0 }))
            .snaplockConfiguration(
                snaplockConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .snapshotPolicy(snapshotPolicy?.applyValue({ args0 -> args0 }))
            .storageEfficiencyEnabled(storageEfficiencyEnabled?.applyValue({ args0 -> args0 }))
            .storageVirtualMachineId(storageVirtualMachineId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tieringPolicy(tieringPolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .volumeStyle(volumeStyle?.applyValue({ args0 -> args0 }))
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OntapVolumeArgs].
 */
@PulumiTagMarker
public class OntapVolumeArgsBuilder internal constructor() {
    private var aggregateConfiguration: Output<OntapVolumeAggregateConfigurationArgs>? = null

    private var bypassSnaplockEnterpriseRetention: Output<Boolean>? = null

    private var copyTagsToBackups: Output<Boolean>? = null

    private var finalBackupTags: Output<Map<String, String>>? = null

    private var junctionPath: Output<String>? = null

    private var name: Output<String>? = null

    private var ontapVolumeType: Output<String>? = null

    private var securityStyle: Output<String>? = null

    private var sizeInBytes: Output<String>? = null

    private var sizeInMegabytes: Output<Int>? = null

    private var skipFinalBackup: Output<Boolean>? = null

    private var snaplockConfiguration: Output<OntapVolumeSnaplockConfigurationArgs>? = null

    private var snapshotPolicy: Output<String>? = null

    private var storageEfficiencyEnabled: Output<Boolean>? = null

    private var storageVirtualMachineId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tieringPolicy: Output<OntapVolumeTieringPolicyArgs>? = null

    private var volumeStyle: Output<String>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
     */
    @JvmName("nutqwpowilqamejv")
    public suspend fun aggregateConfiguration(`value`: Output<OntapVolumeAggregateConfigurationArgs>) {
        this.aggregateConfiguration = value
    }

    /**
     * @param value Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("esfbbshiffrddaju")
    public suspend fun bypassSnaplockEnterpriseRetention(`value`: Output<Boolean>) {
        this.bypassSnaplockEnterpriseRetention = value
    }

    /**
     * @param value A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
     */
    @JvmName("bconkxicrnthiexm")
    public suspend fun copyTagsToBackups(`value`: Output<Boolean>) {
        this.copyTagsToBackups = value
    }

    /**
     * @param value A map of tags to apply to the volume's final backup.
     */
    @JvmName("nadrcmwfoxpqcvkx")
    public suspend fun finalBackupTags(`value`: Output<Map<String, String>>) {
        this.finalBackupTags = value
    }

    /**
     * @param value Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
     */
    @JvmName("slxtppvenkxyyesr")
    public suspend fun junctionPath(`value`: Output<String>) {
        this.junctionPath = value
    }

    /**
     * @param value The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     */
    @JvmName("xmisaftajcbvsltg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
     */
    @JvmName("rwladckvenojoahe")
    public suspend fun ontapVolumeType(`value`: Output<String>) {
        this.ontapVolumeType = value
    }

    /**
     * @param value Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
     */
    @JvmName("buavjuopqsxwfxnh")
    public suspend fun securityStyle(`value`: Output<String>) {
        this.securityStyle = value
    }

    /**
     * @param value Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
     */
    @JvmName("ubeyvyxiwllxfxll")
    public suspend fun sizeInBytes(`value`: Output<String>) {
        this.sizeInBytes = value
    }

    /**
     * @param value Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
     */
    @JvmName("gksuhwbmgkdbdiye")
    public suspend fun sizeInMegabytes(`value`: Output<Int>) {
        this.sizeInMegabytes = value
    }

    /**
     * @param value When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("nbigempyoddshqok")
    public suspend fun skipFinalBackup(`value`: Output<Boolean>) {
        this.skipFinalBackup = value
    }

    /**
     * @param value The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
     */
    @JvmName("kivabgjdndryhktf")
    public suspend fun snaplockConfiguration(`value`: Output<OntapVolumeSnaplockConfigurationArgs>) {
        this.snaplockConfiguration = value
    }

    /**
     * @param value Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
     */
    @JvmName("muubsrdlaiunnuhf")
    public suspend fun snapshotPolicy(`value`: Output<String>) {
        this.snapshotPolicy = value
    }

    /**
     * @param value Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
     */
    @JvmName("uvybrxsduifsmdly")
    public suspend fun storageEfficiencyEnabled(`value`: Output<Boolean>) {
        this.storageEfficiencyEnabled = value
    }

    /**
     * @param value Specifies the storage virtual machine in which to create the volume.
     * The following arguments are optional:
     */
    @JvmName("skacorhtkvefkyyh")
    public suspend fun storageVirtualMachineId(`value`: Output<String>) {
        this.storageVirtualMachineId = value
    }

    /**
     * @param value A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xslvtqgbqtruopuk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
     */
    @JvmName("joyjkaedxxbipemp")
    public suspend fun tieringPolicy(`value`: Output<OntapVolumeTieringPolicyArgs>) {
        this.tieringPolicy = value
    }

    /**
     * @param value Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
     */
    @JvmName("myjpdmijsgbxavng")
    public suspend fun volumeStyle(`value`: Output<String>) {
        this.volumeStyle = value
    }

    /**
     * @param value The type of volume, currently the only valid value is `ONTAP`.
     */
    @JvmName("fswkhyhqpjueoekv")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
     */
    @JvmName("rabvnywwnphhohiv")
    public suspend fun aggregateConfiguration(`value`: OntapVolumeAggregateConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregateConfiguration = mapped
    }

    /**
     * @param argument The Aggregate configuration only applies to `FLEXGROUP` volumes. See [`aggregate_configuration` Block] for details.
     */
    @JvmName("ewuwvqvgpyubbvff")
    public suspend fun aggregateConfiguration(argument: suspend OntapVolumeAggregateConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OntapVolumeAggregateConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.aggregateConfiguration = mapped
    }

    /**
     * @param value Setting this to `true` allows a SnapLock administrator to delete an FSx for ONTAP SnapLock Enterprise volume with unexpired write once, read many (WORM) files. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("pwgutrbeyymxlhrt")
    public suspend fun bypassSnaplockEnterpriseRetention(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassSnaplockEnterpriseRetention = mapped
    }

    /**
     * @param value A boolean flag indicating whether tags for the volume should be copied to backups. This value defaults to `false`.
     */
    @JvmName("iytssakcomxhnudn")
    public suspend fun copyTagsToBackups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToBackups = mapped
    }

    /**
     * @param value A map of tags to apply to the volume's final backup.
     */
    @JvmName("wmevfutsjtwajene")
    public suspend fun finalBackupTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalBackupTags = mapped
    }

    /**
     * @param values A map of tags to apply to the volume's final backup.
     */
    @JvmName("baspgwsokvbxvdyl")
    public fun finalBackupTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.finalBackupTags = mapped
    }

    /**
     * @param value Specifies the location in the storage virtual machine's namespace where the volume is mounted. The junction_path must have a leading forward slash, such as `/vol3`
     */
    @JvmName("hxmfxpklooschghh")
    public suspend fun junctionPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.junctionPath = mapped
    }

    /**
     * @param value The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     */
    @JvmName("ltvwsptodmcbojqk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the type of volume, valid values are `RW`, `DP`. Default value is `RW`. These can be set by the ONTAP CLI or API. This setting is used as part of migration and replication [Migrating to Amazon FSx for NetApp ONTAP](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/migrating-fsx-ontap.html)
     */
    @JvmName("ebpccrykvylmhmoo")
    public suspend fun ontapVolumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ontapVolumeType = mapped
    }

    /**
     * @param value Specifies the volume security style, Valid values are `UNIX`, `NTFS`, and `MIXED`.
     */
    @JvmName("cltvifapjasnkkae")
    public suspend fun securityStyle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityStyle = mapped
    }

    /**
     * @param value Specifies the size of the volume, in megabytes (MB), that you are creating. Can be used for any size but required for volumes over 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
     */
    @JvmName("xsepltfhqnvjjexa")
    public suspend fun sizeInBytes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeInBytes = mapped
    }

    /**
     * @param value Specifies the size of the volume, in megabytes (MB), that you are creating. Supported when creating volumes under 2 PB. Either size_in_bytes or size_in_megabytes must be specified. Minimum size for `FLEXGROUP` volumes are 100GiB per constituent.
     */
    @JvmName("kiddwoboecihcxpi")
    public suspend fun sizeInMegabytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sizeInMegabytes = mapped
    }

    /**
     * @param value When enabled, will skip the default final backup taken when the volume is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("ldiexfmhathkhhnv")
    public suspend fun skipFinalBackup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipFinalBackup = mapped
    }

    /**
     * @param value The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
     */
    @JvmName("uvorfryxybuyhmtg")
    public suspend fun snaplockConfiguration(`value`: OntapVolumeSnaplockConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snaplockConfiguration = mapped
    }

    /**
     * @param argument The SnapLock configuration for an FSx for ONTAP volume. See `snaplock_configuration` Block for details.
     */
    @JvmName("qeftpwuijpbyvgqw")
    public suspend fun snaplockConfiguration(argument: suspend OntapVolumeSnaplockConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OntapVolumeSnaplockConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.snaplockConfiguration = mapped
    }

    /**
     * @param value Specifies the snapshot policy for the volume. See [snapshot policies](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/snapshots-ontap.html#snapshot-policies) in the Amazon FSx ONTAP User Guide
     */
    @JvmName("mnucxsvolmdyvhcd")
    public suspend fun snapshotPolicy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.snapshotPolicy = mapped
    }

    /**
     * @param value Set to true to enable deduplication, compression, and compaction storage efficiency features on the volume.
     */
    @JvmName("xgulgyddjhciprrh")
    public suspend fun storageEfficiencyEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageEfficiencyEnabled = mapped
    }

    /**
     * @param value Specifies the storage virtual machine in which to create the volume.
     * The following arguments are optional:
     */
    @JvmName("dirkuurkcymtmsjo")
    public suspend fun storageVirtualMachineId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageVirtualMachineId = mapped
    }

    /**
     * @param value A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nygifiggysfpkjaj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the volume. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("stgtnsraquerveoy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
     */
    @JvmName("tnmqrcxevwgxiwno")
    public suspend fun tieringPolicy(`value`: OntapVolumeTieringPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tieringPolicy = mapped
    }

    /**
     * @param argument The data tiering policy for an FSx for ONTAP volume. See `tiering_policy` Block for details.
     */
    @JvmName("obhjuolpvfbgtdjw")
    public suspend fun tieringPolicy(argument: suspend OntapVolumeTieringPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = OntapVolumeTieringPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tieringPolicy = mapped
    }

    /**
     * @param value Specifies the styles of volume, valid values are `FLEXVOL`, `FLEXGROUP`. Default value is `FLEXVOL`. FLEXGROUPS have a larger minimum and maximum size. See Volume Styles for more details. [Volume Styles](https://docs.aws.amazon.com/fsx/latest/ONTAPGuide/volume-styles.html)
     */
    @JvmName("pgynscyurosjgswe")
    public suspend fun volumeStyle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeStyle = mapped
    }

    /**
     * @param value The type of volume, currently the only valid value is `ONTAP`.
     */
    @JvmName("ymhxsbpyjebiwdns")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): OntapVolumeArgs = OntapVolumeArgs(
        aggregateConfiguration = aggregateConfiguration,
        bypassSnaplockEnterpriseRetention = bypassSnaplockEnterpriseRetention,
        copyTagsToBackups = copyTagsToBackups,
        finalBackupTags = finalBackupTags,
        junctionPath = junctionPath,
        name = name,
        ontapVolumeType = ontapVolumeType,
        securityStyle = securityStyle,
        sizeInBytes = sizeInBytes,
        sizeInMegabytes = sizeInMegabytes,
        skipFinalBackup = skipFinalBackup,
        snaplockConfiguration = snaplockConfiguration,
        snapshotPolicy = snapshotPolicy,
        storageEfficiencyEnabled = storageEfficiencyEnabled,
        storageVirtualMachineId = storageVirtualMachineId,
        tags = tags,
        tieringPolicy = tieringPolicy,
        volumeStyle = volumeStyle,
        volumeType = volumeType,
    )
}
