@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.kotlin.outputs.OpenZfsFileSystemDiskIopsConfiguration
import com.pulumi.aws.fsx.kotlin.outputs.OpenZfsFileSystemRootVolumeConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.fsx.kotlin.outputs.OpenZfsFileSystemDiskIopsConfiguration.Companion.toKotlin as openZfsFileSystemDiskIopsConfigurationToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.OpenZfsFileSystemRootVolumeConfiguration.Companion.toKotlin as openZfsFileSystemRootVolumeConfigurationToKotlin

/**
 * Builder for [OpenZfsFileSystem].
 */
@PulumiTagMarker
public class OpenZfsFileSystemResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OpenZfsFileSystemArgs = OpenZfsFileSystemArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OpenZfsFileSystemArgsBuilder.() -> Unit) {
        val builder = OpenZfsFileSystemArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OpenZfsFileSystem {
        val builtJavaResource = com.pulumi.aws.fsx.OpenZfsFileSystem(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OpenZfsFileSystem(builtJavaResource)
    }
}

/**
 * Manages an Amazon FSx for OpenZFS file system.
 * See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OpenZfsFileSystem("test", {
 *     storageCapacity: 64,
 *     subnetIds: [test1&#46;id],
 *     deploymentType: "SINGLE_AZ_1",
 *     throughputCapacity: 64,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OpenZfsFileSystem("test",
 *     storage_capacity=64,
 *     subnet_ids=[test1["id"]],
 *     deployment_type="SINGLE_AZ_1",
 *     throughput_capacity=64)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OpenZfsFileSystem("test", new()
 *     {
 *         StorageCapacity = 64,
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *         },
 *         DeploymentType = "SINGLE_AZ_1",
 *         ThroughputCapacity = 64,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOpenZfsFileSystem(ctx, "test", &fsx.OpenZfsFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(64),
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 			},
 * 			DeploymentType:     pulumi.String("SINGLE_AZ_1"),
 * 			ThroughputCapacity: pulumi.Int(64),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OpenZfsFileSystem;
 * import com.pulumi.aws.fsx.OpenZfsFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OpenZfsFileSystem("test", OpenZfsFileSystemArgs.builder()
 *             .storageCapacity(64)
 *             .subnetIds(test1.id())
 *             .deploymentType("SINGLE_AZ_1")
 *             .throughputCapacity(64)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OpenZfsFileSystem
 *     properties:
 *       storageCapacity: 64
 *       subnetIds:
 *         - ${test1.id}
 *       deploymentType: SINGLE_AZ_1
 *       throughputCapacity: 64
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx File Systems using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/openZfsFileSystem:OpenZfsFileSystem example fs-543ab12b1ca672f33
 * ```
 * Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 */
public class OpenZfsFileSystem internal constructor(
    override val javaResource: com.pulumi.aws.fsx.OpenZfsFileSystem,
) : KotlinCustomResource(javaResource, OpenZfsFileSystemMapper) {
    /**
     * Amazon Resource Name of the file system.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     */
    public val automaticBackupRetentionDays: Output<Int>?
        get() = javaResource.automaticBackupRetentionDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The ID of the source backup to create the filesystem from.
     */
    public val backupId: Output<String>?
        get() = javaResource.backupId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
     */
    public val copyTagsToBackups: Output<Boolean>?
        get() = javaResource.copyTagsToBackups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     */
    public val copyTagsToVolumes: Output<Boolean>?
        get() = javaResource.copyTagsToVolumes().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     */
    public val dailyAutomaticBackupStartTime: Output<String>
        get() = javaResource.dailyAutomaticBackupStartTime().applyValue({ args0 -> args0 })

    /**
     * List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
     */
    public val deleteOptions: Output<List<String>>?
        get() = javaResource.deleteOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * The filesystem deployment type. Valid values: `SINGLE_AZ_1`, `SINGLE_AZ_2` and `MULTI_AZ_1`.
     */
    public val deploymentType: Output<String>
        get() = javaResource.deploymentType().applyValue({ args0 -> args0 })

    /**
     * The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
     */
    public val diskIopsConfiguration: Output<OpenZfsFileSystemDiskIopsConfiguration>
        get() = javaResource.diskIopsConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                openZfsFileSystemDiskIopsConfigurationToKotlin(args0)
            })
        })

    /**
     * DNS name for the file system, e.g., `fs-12345678.fsx.us-west-2.amazonaws.com`
     */
    public val dnsName: Output<String>
        get() = javaResource.dnsName().applyValue({ args0 -> args0 })

    /**
     * IP address of the endpoint that is used to access data or to manage the file system.
     */
    public val endpointIpAddress: Output<String>
        get() = javaResource.endpointIpAddress().applyValue({ args0 -> args0 })

    /**
     * (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
     */
    public val endpointIpAddressRange: Output<String>
        get() = javaResource.endpointIpAddressRange().applyValue({ args0 -> args0 })

    /**
     * A map of tags to apply to the file system's final backup.
     */
    public val finalBackupTags: Output<Map<String, String>>?
        get() = javaResource.finalBackupTags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0.key.to(args0.value) }).toMap()
            }).orElse(null)
        })

    /**
     * ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     */
    public val kmsKeyId: Output<String>
        get() = javaResource.kmsKeyId().applyValue({ args0 -> args0 })

    /**
     * Set of Elastic Network Interface identifiers from which the file system is accessible The first network interface returned is the primary network interface.
     */
    public val networkInterfaceIds: Output<List<String>>
        get() = javaResource.networkInterfaceIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * AWS account identifier that created the file system.
     */
    public val ownerId: Output<String>
        get() = javaResource.ownerId().applyValue({ args0 -> args0 })

    /**
     * (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
     */
    public val preferredSubnetId: Output<String>?
        get() = javaResource.preferredSubnetId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
     */
    public val rootVolumeConfiguration: Output<OpenZfsFileSystemRootVolumeConfiguration>
        get() = javaResource.rootVolumeConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                openZfsFileSystemRootVolumeConfigurationToKotlin(args0)
            })
        })

    /**
     * Identifier of the root volume, e.g., `fsvol-12345678`
     */
    public val rootVolumeId: Output<String>
        get() = javaResource.rootVolumeId().applyValue({ args0 -> args0 })

    /**
     * (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    public val routeTableIds: Output<List<String>>
        get() = javaResource.routeTableIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    public val securityGroupIds: Output<List<String>>?
        get() = javaResource.securityGroupIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    public val skipFinalBackup: Output<Boolean>?
        get() = javaResource.skipFinalBackup().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
     */
    public val storageCapacity: Output<Int>?
        get() = javaResource.storageCapacity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The filesystem storage type. Only `SSD` is supported.
     */
    public val storageType: Output<String>?
        get() = javaResource.storageType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A list of IDs for the subnets that the file system will be accessible from.
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
     * The following arguments are optional:
     */
    public val throughputCapacity: Output<Int>
        get() = javaResource.throughputCapacity().applyValue({ args0 -> args0 })

    /**
     * Identifier of the Virtual Private Cloud for the file system.
     */
    public val vpcId: Output<String>
        get() = javaResource.vpcId().applyValue({ args0 -> args0 })

    /**
     * The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    public val weeklyMaintenanceStartTime: Output<String>
        get() = javaResource.weeklyMaintenanceStartTime().applyValue({ args0 -> args0 })
}

public object OpenZfsFileSystemMapper : ResourceMapper<OpenZfsFileSystem> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fsx.OpenZfsFileSystem::class == javaResource::class

    override fun map(javaResource: Resource): OpenZfsFileSystem = OpenZfsFileSystem(
        javaResource as
            com.pulumi.aws.fsx.OpenZfsFileSystem,
    )
}

/**
 * @see [OpenZfsFileSystem].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OpenZfsFileSystem].
 */
public suspend fun openZfsFileSystem(
    name: String,
    block: suspend OpenZfsFileSystemResourceBuilder.() -> Unit,
): OpenZfsFileSystem {
    val builder = OpenZfsFileSystemResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OpenZfsFileSystem].
 * @param name The _unique_ name of the resulting resource.
 */
public fun openZfsFileSystem(name: String): OpenZfsFileSystem {
    val builder = OpenZfsFileSystemResourceBuilder()
    builder.name(name)
    return builder.build()
}
