@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.OpenZfsFileSystemArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.OpenZfsFileSystemDiskIopsConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.OpenZfsFileSystemDiskIopsConfigurationArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.OpenZfsFileSystemRootVolumeConfigurationArgs
import com.pulumi.aws.fsx.kotlin.inputs.OpenZfsFileSystemRootVolumeConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon FSx for OpenZFS file system.
 * See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OpenZfsFileSystem("test", {
 *     storageCapacity: 64,
 *     subnetIds: [test1&#46;id],
 *     deploymentType: "SINGLE_AZ_1",
 *     throughputCapacity: 64,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OpenZfsFileSystem("test",
 *     storage_capacity=64,
 *     subnet_ids=[test1["id"]],
 *     deployment_type="SINGLE_AZ_1",
 *     throughput_capacity=64)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OpenZfsFileSystem("test", new()
 *     {
 *         StorageCapacity = 64,
 *         SubnetIds = new[]
 *         {
 *             test1.Id,
 *         },
 *         DeploymentType = "SINGLE_AZ_1",
 *         ThroughputCapacity = 64,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOpenZfsFileSystem(ctx, "test", &fsx.OpenZfsFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(64),
 * 			SubnetIds: pulumi.StringArray{
 * 				test1.Id,
 * 			},
 * 			DeploymentType:     pulumi.String("SINGLE_AZ_1"),
 * 			ThroughputCapacity: pulumi.Int(64),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OpenZfsFileSystem;
 * import com.pulumi.aws.fsx.OpenZfsFileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OpenZfsFileSystem("test", OpenZfsFileSystemArgs.builder()
 *             .storageCapacity(64)
 *             .subnetIds(test1.id())
 *             .deploymentType("SINGLE_AZ_1")
 *             .throughputCapacity(64)
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OpenZfsFileSystem
 *     properties:
 *       storageCapacity: 64
 *       subnetIds:
 *         - ${test1.id}
 *       deploymentType: SINGLE_AZ_1
 *       throughputCapacity: 64
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx File Systems using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/openZfsFileSystem:OpenZfsFileSystem example fs-543ab12b1ca672f33
 * ```
 * Certain resource arguments, like `security_group_ids`, do not have a FSx API method for reading the information after creation. If the argument is set in the Pulumi program on an imported resource, Pulumi will always show a difference. To workaround this behavior, either omit the argument from the Pulumi program or use `ignore_changes` to hide the difference. For example:
 * @property automaticBackupRetentionDays The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
 * @property backupId The ID of the source backup to create the filesystem from.
 * @property copyTagsToBackups A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
 * @property copyTagsToVolumes A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
 * @property dailyAutomaticBackupStartTime A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
 * @property deleteOptions List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
 * @property deploymentType The filesystem deployment type. Valid values: `SINGLE_AZ_1`, `SINGLE_AZ_2` and `MULTI_AZ_1`.
 * @property diskIopsConfiguration The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
 * @property endpointIpAddressRange (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
 * @property finalBackupTags A map of tags to apply to the file system's final backup.
 * @property kmsKeyId ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
 * @property preferredSubnetId (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
 * @property rootVolumeConfiguration The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
 * @property routeTableIds (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
 * @property securityGroupIds A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
 * @property skipFinalBackup When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
 * @property storageCapacity The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
 * @property storageType The filesystem storage type. Only `SSD` is supported.
 * @property subnetIds A list of IDs for the subnets that the file system will be accessible from.
 * @property tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property throughputCapacity Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
 * The following arguments are optional:
 * @property weeklyMaintenanceStartTime The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
 */
public data class OpenZfsFileSystemArgs(
    public val automaticBackupRetentionDays: Output<Int>? = null,
    public val backupId: Output<String>? = null,
    public val copyTagsToBackups: Output<Boolean>? = null,
    public val copyTagsToVolumes: Output<Boolean>? = null,
    public val dailyAutomaticBackupStartTime: Output<String>? = null,
    public val deleteOptions: Output<List<String>>? = null,
    public val deploymentType: Output<String>? = null,
    public val diskIopsConfiguration: Output<OpenZfsFileSystemDiskIopsConfigurationArgs>? = null,
    public val endpointIpAddressRange: Output<String>? = null,
    public val finalBackupTags: Output<Map<String, String>>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val preferredSubnetId: Output<String>? = null,
    public val rootVolumeConfiguration: Output<OpenZfsFileSystemRootVolumeConfigurationArgs>? = null,
    public val routeTableIds: Output<List<String>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val skipFinalBackup: Output<Boolean>? = null,
    public val storageCapacity: Output<Int>? = null,
    public val storageType: Output<String>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throughputCapacity: Output<Int>? = null,
    public val weeklyMaintenanceStartTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.OpenZfsFileSystemArgs> {
    override fun toJava(): com.pulumi.aws.fsx.OpenZfsFileSystemArgs =
        com.pulumi.aws.fsx.OpenZfsFileSystemArgs.builder()
            .automaticBackupRetentionDays(automaticBackupRetentionDays?.applyValue({ args0 -> args0 }))
            .backupId(backupId?.applyValue({ args0 -> args0 }))
            .copyTagsToBackups(copyTagsToBackups?.applyValue({ args0 -> args0 }))
            .copyTagsToVolumes(copyTagsToVolumes?.applyValue({ args0 -> args0 }))
            .dailyAutomaticBackupStartTime(dailyAutomaticBackupStartTime?.applyValue({ args0 -> args0 }))
            .deleteOptions(deleteOptions?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .deploymentType(deploymentType?.applyValue({ args0 -> args0 }))
            .diskIopsConfiguration(
                diskIopsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .endpointIpAddressRange(endpointIpAddressRange?.applyValue({ args0 -> args0 }))
            .finalBackupTags(
                finalBackupTags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .preferredSubnetId(preferredSubnetId?.applyValue({ args0 -> args0 }))
            .rootVolumeConfiguration(
                rootVolumeConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .routeTableIds(routeTableIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .skipFinalBackup(skipFinalBackup?.applyValue({ args0 -> args0 }))
            .storageCapacity(storageCapacity?.applyValue({ args0 -> args0 }))
            .storageType(storageType?.applyValue({ args0 -> args0 }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughputCapacity(throughputCapacity?.applyValue({ args0 -> args0 }))
            .weeklyMaintenanceStartTime(weeklyMaintenanceStartTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenZfsFileSystemArgs].
 */
@PulumiTagMarker
public class OpenZfsFileSystemArgsBuilder internal constructor() {
    private var automaticBackupRetentionDays: Output<Int>? = null

    private var backupId: Output<String>? = null

    private var copyTagsToBackups: Output<Boolean>? = null

    private var copyTagsToVolumes: Output<Boolean>? = null

    private var dailyAutomaticBackupStartTime: Output<String>? = null

    private var deleteOptions: Output<List<String>>? = null

    private var deploymentType: Output<String>? = null

    private var diskIopsConfiguration: Output<OpenZfsFileSystemDiskIopsConfigurationArgs>? = null

    private var endpointIpAddressRange: Output<String>? = null

    private var finalBackupTags: Output<Map<String, String>>? = null

    private var kmsKeyId: Output<String>? = null

    private var preferredSubnetId: Output<String>? = null

    private var rootVolumeConfiguration: Output<OpenZfsFileSystemRootVolumeConfigurationArgs>? = null

    private var routeTableIds: Output<List<String>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var skipFinalBackup: Output<Boolean>? = null

    private var storageCapacity: Output<Int>? = null

    private var storageType: Output<String>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throughputCapacity: Output<Int>? = null

    private var weeklyMaintenanceStartTime: Output<String>? = null

    /**
     * @param value The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     */
    @JvmName("pcncrjeahnllcxyi")
    public suspend fun automaticBackupRetentionDays(`value`: Output<Int>) {
        this.automaticBackupRetentionDays = value
    }

    /**
     * @param value The ID of the source backup to create the filesystem from.
     */
    @JvmName("mdriwyaajasjhekq")
    public suspend fun backupId(`value`: Output<String>) {
        this.backupId = value
    }

    /**
     * @param value A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
     */
    @JvmName("pkpuipsccrhmmrce")
    public suspend fun copyTagsToBackups(`value`: Output<Boolean>) {
        this.copyTagsToBackups = value
    }

    /**
     * @param value A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     */
    @JvmName("oyfpftcqyodpvyjx")
    public suspend fun copyTagsToVolumes(`value`: Output<Boolean>) {
        this.copyTagsToVolumes = value
    }

    /**
     * @param value A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     */
    @JvmName("tewpowwnoecueoko")
    public suspend fun dailyAutomaticBackupStartTime(`value`: Output<String>) {
        this.dailyAutomaticBackupStartTime = value
    }

    /**
     * @param value List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
     */
    @JvmName("qbhtgbmtvamoxgjr")
    public suspend fun deleteOptions(`value`: Output<List<String>>) {
        this.deleteOptions = value
    }

    @JvmName("yironvmrtqpubslf")
    public suspend fun deleteOptions(vararg values: Output<String>) {
        this.deleteOptions = Output.all(values.asList())
    }

    /**
     * @param values List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
     */
    @JvmName("emdduxgkgisccytw")
    public suspend fun deleteOptions(values: List<Output<String>>) {
        this.deleteOptions = Output.all(values)
    }

    /**
     * @param value The filesystem deployment type. Valid values: `SINGLE_AZ_1`, `SINGLE_AZ_2` and `MULTI_AZ_1`.
     */
    @JvmName("uhnsupjyxjoikcpn")
    public suspend fun deploymentType(`value`: Output<String>) {
        this.deploymentType = value
    }

    /**
     * @param value The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
     */
    @JvmName("oniurladfanmyoul")
    public suspend fun diskIopsConfiguration(`value`: Output<OpenZfsFileSystemDiskIopsConfigurationArgs>) {
        this.diskIopsConfiguration = value
    }

    /**
     * @param value (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
     */
    @JvmName("ppiitjyxftrlldvx")
    public suspend fun endpointIpAddressRange(`value`: Output<String>) {
        this.endpointIpAddressRange = value
    }

    /**
     * @param value A map of tags to apply to the file system's final backup.
     */
    @JvmName("jaahpidkrpubvypl")
    public suspend fun finalBackupTags(`value`: Output<Map<String, String>>) {
        this.finalBackupTags = value
    }

    /**
     * @param value ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     */
    @JvmName("xmkntqtgrqwlobsc")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
     */
    @JvmName("jylklxfsbrunoule")
    public suspend fun preferredSubnetId(`value`: Output<String>) {
        this.preferredSubnetId = value
    }

    /**
     * @param value The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
     */
    @JvmName("fvkuiftjjsoksxqg")
    public suspend fun rootVolumeConfiguration(`value`: Output<OpenZfsFileSystemRootVolumeConfigurationArgs>) {
        this.rootVolumeConfiguration = value
    }

    /**
     * @param value (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("dsxtbbexjjikmjrg")
    public suspend fun routeTableIds(`value`: Output<List<String>>) {
        this.routeTableIds = value
    }

    @JvmName("oonengpovefsxghc")
    public suspend fun routeTableIds(vararg values: Output<String>) {
        this.routeTableIds = Output.all(values.asList())
    }

    /**
     * @param values (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("aqdmpxdikodslgnx")
    public suspend fun routeTableIds(values: List<Output<String>>) {
        this.routeTableIds = Output.all(values)
    }

    /**
     * @param value A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("ckogbwpeckdptvqm")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("qnjloovyqaevcotl")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("eyhbqbcmlxmepxdm")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("qxbyybbipqgekwdc")
    public suspend fun skipFinalBackup(`value`: Output<Boolean>) {
        this.skipFinalBackup = value
    }

    /**
     * @param value The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
     */
    @JvmName("drxabjpavffkdnhv")
    public suspend fun storageCapacity(`value`: Output<Int>) {
        this.storageCapacity = value
    }

    /**
     * @param value The filesystem storage type. Only `SSD` is supported.
     */
    @JvmName("wtxfhghnqobjicco")
    public suspend fun storageType(`value`: Output<String>) {
        this.storageType = value
    }

    /**
     * @param value A list of IDs for the subnets that the file system will be accessible from.
     */
    @JvmName("sayiwydlcotmykoo")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("kahnnnablydcivlu")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of IDs for the subnets that the file system will be accessible from.
     */
    @JvmName("ahtcriyqxjdfhaqf")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("smvuwxerrcqclgra")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
     * The following arguments are optional:
     */
    @JvmName("smfecuwhlcqjpmvf")
    public suspend fun throughputCapacity(`value`: Output<Int>) {
        this.throughputCapacity = value
    }

    /**
     * @param value The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    @JvmName("cnloykkcxxhpskaj")
    public suspend fun weeklyMaintenanceStartTime(`value`: Output<String>) {
        this.weeklyMaintenanceStartTime = value
    }

    /**
     * @param value The number of days to retain automatic backups. Setting this to 0 disables automatic backups. You can retain automatic backups for a maximum of 90 days.
     */
    @JvmName("rgsviphagkknrjto")
    public suspend fun automaticBackupRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.automaticBackupRetentionDays = mapped
    }

    /**
     * @param value The ID of the source backup to create the filesystem from.
     */
    @JvmName("keahcpjmwjbeywcy")
    public suspend fun backupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupId = mapped
    }

    /**
     * @param value A boolean flag indicating whether tags for the file system should be copied to backups. The default value is false.
     */
    @JvmName("laeygqpyxvlftkqk")
    public suspend fun copyTagsToBackups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToBackups = mapped
    }

    /**
     * @param value A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     */
    @JvmName("tsimytepswuxbfjx")
    public suspend fun copyTagsToVolumes(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToVolumes = mapped
    }

    /**
     * @param value A recurring daily time, in the format HH:MM. HH is the zero-padded hour of the day (0-23), and MM is the zero-padded minute of the hour. For example, 05:00 specifies 5 AM daily. Requires `automatic_backup_retention_days` to be set.
     */
    @JvmName("hkjqbdkfvttfpkph")
    public suspend fun dailyAutomaticBackupStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dailyAutomaticBackupStartTime = mapped
    }

    /**
     * @param value List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
     */
    @JvmName("gvfpmumrbrydohhy")
    public suspend fun deleteOptions(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteOptions = mapped
    }

    /**
     * @param values List of delete options, which at present supports only one value that specifies whether to delete all child volumes and snapshots when the file system is deleted. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`.
     */
    @JvmName("svluqervxqixrxby")
    public suspend fun deleteOptions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deleteOptions = mapped
    }

    /**
     * @param value The filesystem deployment type. Valid values: `SINGLE_AZ_1`, `SINGLE_AZ_2` and `MULTI_AZ_1`.
     */
    @JvmName("hsncnxpetplriqaq")
    public suspend fun deploymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
     */
    @JvmName("exuaedijxmpuinpj")
    public suspend fun diskIopsConfiguration(`value`: OpenZfsFileSystemDiskIopsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskIopsConfiguration = mapped
    }

    /**
     * @param argument The SSD IOPS configuration for the Amazon FSx for OpenZFS file system. See `disk_iops_configuration` Block for details.
     */
    @JvmName("sjcrrrjbgrntpxpn")
    public suspend fun diskIopsConfiguration(argument: suspend OpenZfsFileSystemDiskIopsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OpenZfsFileSystemDiskIopsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.diskIopsConfiguration = mapped
    }

    /**
     * @param value (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system will be created.
     */
    @JvmName("vlxprnubtmwvljbs")
    public suspend fun endpointIpAddressRange(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointIpAddressRange = mapped
    }

    /**
     * @param value A map of tags to apply to the file system's final backup.
     */
    @JvmName("ttmohhrtlncuepjj")
    public suspend fun finalBackupTags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.finalBackupTags = mapped
    }

    /**
     * @param values A map of tags to apply to the file system's final backup.
     */
    @JvmName("aateavnkbuoclkgk")
    public fun finalBackupTags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.finalBackupTags = mapped
    }

    /**
     * @param value ARN for the KMS Key to encrypt the file system at rest, Defaults to an AWS managed KMS Key.
     */
    @JvmName("libmirtovvydlvum")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value (Multi-AZ only) Required when `deployment_type` is set to `MULTI_AZ_1`. This specifies the subnet in which you want the preferred file server to be located.
     */
    @JvmName("uwrgypjisnphnbbp")
    public suspend fun preferredSubnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredSubnetId = mapped
    }

    /**
     * @param value The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
     */
    @JvmName("qjgqblcoktrhaubt")
    public suspend fun rootVolumeConfiguration(`value`: OpenZfsFileSystemRootVolumeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootVolumeConfiguration = mapped
    }

    /**
     * @param argument The configuration for the root volume of the file system. All other volumes are children or the root volume. See `root_volume_configuration` Block for details.
     */
    @JvmName("jcqwtkkyahnvblth")
    public suspend fun rootVolumeConfiguration(argument: suspend OpenZfsFileSystemRootVolumeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = OpenZfsFileSystemRootVolumeConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rootVolumeConfiguration = mapped
    }

    /**
     * @param value (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("bhjqpomwlhyerdxp")
    public suspend fun routeTableIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routeTableIds = mapped
    }

    /**
     * @param values (Multi-AZ only) Specifies the route tables in which Amazon FSx creates the rules for routing traffic to the correct file server. You should specify all virtual private cloud (VPC) route tables associated with the subnets in which your clients are located. By default, Amazon FSx selects your VPC's default route table.
     */
    @JvmName("etpubiphthfawpyl")
    public suspend fun routeTableIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routeTableIds = mapped
    }

    /**
     * @param value A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("odqddxendefrplef")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of IDs for the security groups that apply to the specified network interfaces created for file system access. These security groups will apply to all network interfaces.
     */
    @JvmName("wiygwyepjrbqenlr")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value When enabled, will skip the default final backup taken when the file system is deleted. This configuration must be applied separately before attempting to delete the resource to have the desired behavior. Defaults to `false`.
     */
    @JvmName("wiolojjaevpakjdg")
    public suspend fun skipFinalBackup(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.skipFinalBackup = mapped
    }

    /**
     * @param value The storage capacity (GiB) of the file system. Valid values between `64` and `524288`.
     */
    @JvmName("mlufsgjolpgsjycs")
    public suspend fun storageCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacity = mapped
    }

    /**
     * @param value The filesystem storage type. Only `SSD` is supported.
     */
    @JvmName("jxresyjsfdmyiaii")
    public suspend fun storageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageType = mapped
    }

    /**
     * @param value A list of IDs for the subnets that the file system will be accessible from.
     */
    @JvmName("ovxwkiamvxmvfqnd")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of IDs for the subnets that the file system will be accessible from.
     */
    @JvmName("rampxuxlwovsjeud")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hwsbioikollhdbha")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ylrfytwglagxeajq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Throughput (MB/s) of the file system. Valid values depend on `deployment_type`. Must be one of `64`, `128`, `256`, `512`, `1024`, `2048`, `3072`, `4096` for `SINGLE_AZ_1`. Must be one of `160`, `320`, `640`, `1280`, `2560`, `3840`, `5120`, `7680`, `10240` for `SINGLE_AZ_2`.
     * The following arguments are optional:
     */
    @JvmName("puowcuyotefbmuum")
    public suspend fun throughputCapacity(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputCapacity = mapped
    }

    /**
     * @param value The preferred start time (in `d:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
     */
    @JvmName("gqjabnguasivpjhv")
    public suspend fun weeklyMaintenanceStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyMaintenanceStartTime = mapped
    }

    internal fun build(): OpenZfsFileSystemArgs = OpenZfsFileSystemArgs(
        automaticBackupRetentionDays = automaticBackupRetentionDays,
        backupId = backupId,
        copyTagsToBackups = copyTagsToBackups,
        copyTagsToVolumes = copyTagsToVolumes,
        dailyAutomaticBackupStartTime = dailyAutomaticBackupStartTime,
        deleteOptions = deleteOptions,
        deploymentType = deploymentType,
        diskIopsConfiguration = diskIopsConfiguration,
        endpointIpAddressRange = endpointIpAddressRange,
        finalBackupTags = finalBackupTags,
        kmsKeyId = kmsKeyId,
        preferredSubnetId = preferredSubnetId,
        rootVolumeConfiguration = rootVolumeConfiguration,
        routeTableIds = routeTableIds,
        securityGroupIds = securityGroupIds,
        skipFinalBackup = skipFinalBackup,
        storageCapacity = storageCapacity,
        storageType = storageType,
        subnetIds = subnetIds,
        tags = tags,
        throughputCapacity = throughputCapacity,
        weeklyMaintenanceStartTime = weeklyMaintenanceStartTime,
    )
}
