@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [OpenZfsSnapshot].
 */
@PulumiTagMarker
public class OpenZfsSnapshotResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OpenZfsSnapshotArgs = OpenZfsSnapshotArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OpenZfsSnapshotArgsBuilder.() -> Unit) {
        val builder = OpenZfsSnapshotArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OpenZfsSnapshot {
        val builtJavaResource = com.pulumi.aws.fsx.OpenZfsSnapshot(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OpenZfsSnapshot(builtJavaResource)
    }
}

/**
 * Manages an Amazon FSx for OpenZFS volume.
 * See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.
 * ## Example Usage
 * ### Root volume Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleOpenZfsFileSystem = new aws.fsx.OpenZfsFileSystem("example", {
 *     storageCapacity: 64,
 *     subnetIds: [exampleAwsSubnet&#46;id],
 *     deploymentType: "SINGLE_AZ_1",
 *     throughputCapacity: 64,
 * });
 * const example = new aws.fsx.OpenZfsSnapshot("example", {
 *     name: "example",
 *     volumeId: exampleOpenZfsFileSystem.rootVolumeId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_open_zfs_file_system = aws.fsx.OpenZfsFileSystem("example",
 *     storage_capacity=64,
 *     subnet_ids=[example_aws_subnet["id"]],
 *     deployment_type="SINGLE_AZ_1",
 *     throughput_capacity=64)
 * example = aws.fsx.OpenZfsSnapshot("example",
 *     name="example",
 *     volume_id=example_open_zfs_file_system.root_volume_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleOpenZfsFileSystem = new Aws.Fsx.OpenZfsFileSystem("example", new()
 *     {
 *         StorageCapacity = 64,
 *         SubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         DeploymentType = "SINGLE_AZ_1",
 *         ThroughputCapacity = 64,
 *     });
 *     var example = new Aws.Fsx.OpenZfsSnapshot("example", new()
 *     {
 *         Name = "example",
 *         VolumeId = exampleOpenZfsFileSystem.RootVolumeId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleOpenZfsFileSystem, err := fsx.NewOpenZfsFileSystem(ctx, "example", &fsx.OpenZfsFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(64),
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			DeploymentType:     pulumi.String("SINGLE_AZ_1"),
 * 			ThroughputCapacity: pulumi.Int(64),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fsx.NewOpenZfsSnapshot(ctx, "example", &fsx.OpenZfsSnapshotArgs{
 * 			Name:     pulumi.String("example"),
 * 			VolumeId: exampleOpenZfsFileSystem.RootVolumeId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OpenZfsFileSystem;
 * import com.pulumi.aws.fsx.OpenZfsFileSystemArgs;
 * import com.pulumi.aws.fsx.OpenZfsSnapshot;
 * import com.pulumi.aws.fsx.OpenZfsSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOpenZfsFileSystem = new OpenZfsFileSystem("exampleOpenZfsFileSystem", OpenZfsFileSystemArgs.builder()
 *             .storageCapacity(64)
 *             .subnetIds(exampleAwsSubnet.id())
 *             .deploymentType("SINGLE_AZ_1")
 *             .throughputCapacity(64)
 *             .build());
 *         var example = new OpenZfsSnapshot("example", OpenZfsSnapshotArgs.builder()
 *             .name("example")
 *             .volumeId(exampleOpenZfsFileSystem.rootVolumeId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fsx:OpenZfsSnapshot
 *     properties:
 *       name: example
 *       volumeId: ${exampleOpenZfsFileSystem.rootVolumeId}
 *   exampleOpenZfsFileSystem:
 *     type: aws:fsx:OpenZfsFileSystem
 *     name: example
 *     properties:
 *       storageCapacity: 64
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       deploymentType: SINGLE_AZ_1
 *       throughputCapacity: 64
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Child volume Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleOpenZfsFileSystem = new aws.fsx.OpenZfsFileSystem("example", {
 *     storageCapacity: 64,
 *     subnetIds: [exampleAwsSubnet&#46;id],
 *     deploymentType: "SINGLE_AZ_1",
 *     throughputCapacity: 64,
 * });
 * const exampleOpenZfsVolume = new aws.fsx.OpenZfsVolume("example", {
 *     name: "example",
 *     parentVolumeId: exampleOpenZfsFileSystem.rootVolumeId,
 * });
 * const example = new aws.fsx.OpenZfsSnapshot("example", {
 *     name: "example",
 *     volumeId: exampleOpenZfsVolume.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_open_zfs_file_system = aws.fsx.OpenZfsFileSystem("example",
 *     storage_capacity=64,
 *     subnet_ids=[example_aws_subnet["id"]],
 *     deployment_type="SINGLE_AZ_1",
 *     throughput_capacity=64)
 * example_open_zfs_volume = aws.fsx.OpenZfsVolume("example",
 *     name="example",
 *     parent_volume_id=example_open_zfs_file_system.root_volume_id)
 * example = aws.fsx.OpenZfsSnapshot("example",
 *     name="example",
 *     volume_id=example_open_zfs_volume.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleOpenZfsFileSystem = new Aws.Fsx.OpenZfsFileSystem("example", new()
 *     {
 *         StorageCapacity = 64,
 *         SubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         DeploymentType = "SINGLE_AZ_1",
 *         ThroughputCapacity = 64,
 *     });
 *     var exampleOpenZfsVolume = new Aws.Fsx.OpenZfsVolume("example", new()
 *     {
 *         Name = "example",
 *         ParentVolumeId = exampleOpenZfsFileSystem.RootVolumeId,
 *     });
 *     var example = new Aws.Fsx.OpenZfsSnapshot("example", new()
 *     {
 *         Name = "example",
 *         VolumeId = exampleOpenZfsVolume.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleOpenZfsFileSystem, err := fsx.NewOpenZfsFileSystem(ctx, "example", &fsx.OpenZfsFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(64),
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			DeploymentType:     pulumi.String("SINGLE_AZ_1"),
 * 			ThroughputCapacity: pulumi.Int(64),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleOpenZfsVolume, err := fsx.NewOpenZfsVolume(ctx, "example", &fsx.OpenZfsVolumeArgs{
 * 			Name:           pulumi.String("example"),
 * 			ParentVolumeId: exampleOpenZfsFileSystem.RootVolumeId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fsx.NewOpenZfsSnapshot(ctx, "example", &fsx.OpenZfsSnapshotArgs{
 * 			Name:     pulumi.String("example"),
 * 			VolumeId: exampleOpenZfsVolume.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OpenZfsFileSystem;
 * import com.pulumi.aws.fsx.OpenZfsFileSystemArgs;
 * import com.pulumi.aws.fsx.OpenZfsVolume;
 * import com.pulumi.aws.fsx.OpenZfsVolumeArgs;
 * import com.pulumi.aws.fsx.OpenZfsSnapshot;
 * import com.pulumi.aws.fsx.OpenZfsSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOpenZfsFileSystem = new OpenZfsFileSystem("exampleOpenZfsFileSystem", OpenZfsFileSystemArgs.builder()
 *             .storageCapacity(64)
 *             .subnetIds(exampleAwsSubnet.id())
 *             .deploymentType("SINGLE_AZ_1")
 *             .throughputCapacity(64)
 *             .build());
 *         var exampleOpenZfsVolume = new OpenZfsVolume("exampleOpenZfsVolume", OpenZfsVolumeArgs.builder()
 *             .name("example")
 *             .parentVolumeId(exampleOpenZfsFileSystem.rootVolumeId())
 *             .build());
 *         var example = new OpenZfsSnapshot("example", OpenZfsSnapshotArgs.builder()
 *             .name("example")
 *             .volumeId(exampleOpenZfsVolume.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fsx:OpenZfsSnapshot
 *     properties:
 *       name: example
 *       volumeId: ${exampleOpenZfsVolume.id}
 *   exampleOpenZfsVolume:
 *     type: aws:fsx:OpenZfsVolume
 *     name: example
 *     properties:
 *       name: example
 *       parentVolumeId: ${exampleOpenZfsFileSystem.rootVolumeId}
 *   exampleOpenZfsFileSystem:
 *     type: aws:fsx:OpenZfsFileSystem
 *     name: example
 *     properties:
 *       storageCapacity: 64
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       deploymentType: SINGLE_AZ_1
 *       throughputCapacity: 64
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx OpenZFS snapshot using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/openZfsSnapshot:OpenZfsSnapshot example fs-543ab12b1ca672f33
 * ```
 */
public class OpenZfsSnapshot internal constructor(
    override val javaResource: com.pulumi.aws.fsx.OpenZfsSnapshot,
) : KotlinCustomResource(javaResource, OpenZfsSnapshotMapper) {
    /**
     * Amazon Resource Name of the snapshot.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    public val creationTime: Output<String>
        get() = javaResource.creationTime().applyValue({ args0 -> args0 })

    /**
     * The name of the Snapshot. You can use a maximum of 203 alphanumeric characters plus either _ or -  or : or . for the name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The ID of the volume to snapshot. This can be the root volume or a child volume.
     */
    public val volumeId: Output<String>
        get() = javaResource.volumeId().applyValue({ args0 -> args0 })
}

public object OpenZfsSnapshotMapper : ResourceMapper<OpenZfsSnapshot> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fsx.OpenZfsSnapshot::class == javaResource::class

    override fun map(javaResource: Resource): OpenZfsSnapshot = OpenZfsSnapshot(
        javaResource as
            com.pulumi.aws.fsx.OpenZfsSnapshot,
    )
}

/**
 * @see [OpenZfsSnapshot].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OpenZfsSnapshot].
 */
public suspend fun openZfsSnapshot(
    name: String,
    block: suspend OpenZfsSnapshotResourceBuilder.() -> Unit,
): OpenZfsSnapshot {
    val builder = OpenZfsSnapshotResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OpenZfsSnapshot].
 * @param name The _unique_ name of the resulting resource.
 */
public fun openZfsSnapshot(name: String): OpenZfsSnapshot {
    val builder = OpenZfsSnapshotResourceBuilder()
    builder.name(name)
    return builder.build()
}
