@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.OpenZfsSnapshotArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon FSx for OpenZFS volume.
 * See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.
 * ## Example Usage
 * ### Root volume Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleOpenZfsFileSystem = new aws.fsx.OpenZfsFileSystem("example", {
 *     storageCapacity: 64,
 *     subnetIds: [exampleAwsSubnet&#46;id],
 *     deploymentType: "SINGLE_AZ_1",
 *     throughputCapacity: 64,
 * });
 * const example = new aws.fsx.OpenZfsSnapshot("example", {
 *     name: "example",
 *     volumeId: exampleOpenZfsFileSystem.rootVolumeId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_open_zfs_file_system = aws.fsx.OpenZfsFileSystem("example",
 *     storage_capacity=64,
 *     subnet_ids=[example_aws_subnet["id"]],
 *     deployment_type="SINGLE_AZ_1",
 *     throughput_capacity=64)
 * example = aws.fsx.OpenZfsSnapshot("example",
 *     name="example",
 *     volume_id=example_open_zfs_file_system.root_volume_id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleOpenZfsFileSystem = new Aws.Fsx.OpenZfsFileSystem("example", new()
 *     {
 *         StorageCapacity = 64,
 *         SubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         DeploymentType = "SINGLE_AZ_1",
 *         ThroughputCapacity = 64,
 *     });
 *     var example = new Aws.Fsx.OpenZfsSnapshot("example", new()
 *     {
 *         Name = "example",
 *         VolumeId = exampleOpenZfsFileSystem.RootVolumeId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleOpenZfsFileSystem, err := fsx.NewOpenZfsFileSystem(ctx, "example", &fsx.OpenZfsFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(64),
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			DeploymentType:     pulumi.String("SINGLE_AZ_1"),
 * 			ThroughputCapacity: pulumi.Int(64),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fsx.NewOpenZfsSnapshot(ctx, "example", &fsx.OpenZfsSnapshotArgs{
 * 			Name:     pulumi.String("example"),
 * 			VolumeId: exampleOpenZfsFileSystem.RootVolumeId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OpenZfsFileSystem;
 * import com.pulumi.aws.fsx.OpenZfsFileSystemArgs;
 * import com.pulumi.aws.fsx.OpenZfsSnapshot;
 * import com.pulumi.aws.fsx.OpenZfsSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOpenZfsFileSystem = new OpenZfsFileSystem("exampleOpenZfsFileSystem", OpenZfsFileSystemArgs.builder()
 *             .storageCapacity(64)
 *             .subnetIds(exampleAwsSubnet.id())
 *             .deploymentType("SINGLE_AZ_1")
 *             .throughputCapacity(64)
 *             .build());
 *         var example = new OpenZfsSnapshot("example", OpenZfsSnapshotArgs.builder()
 *             .name("example")
 *             .volumeId(exampleOpenZfsFileSystem.rootVolumeId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fsx:OpenZfsSnapshot
 *     properties:
 *       name: example
 *       volumeId: ${exampleOpenZfsFileSystem.rootVolumeId}
 *   exampleOpenZfsFileSystem:
 *     type: aws:fsx:OpenZfsFileSystem
 *     name: example
 *     properties:
 *       storageCapacity: 64
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       deploymentType: SINGLE_AZ_1
 *       throughputCapacity: 64
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Child volume Example
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleOpenZfsFileSystem = new aws.fsx.OpenZfsFileSystem("example", {
 *     storageCapacity: 64,
 *     subnetIds: [exampleAwsSubnet&#46;id],
 *     deploymentType: "SINGLE_AZ_1",
 *     throughputCapacity: 64,
 * });
 * const exampleOpenZfsVolume = new aws.fsx.OpenZfsVolume("example", {
 *     name: "example",
 *     parentVolumeId: exampleOpenZfsFileSystem.rootVolumeId,
 * });
 * const example = new aws.fsx.OpenZfsSnapshot("example", {
 *     name: "example",
 *     volumeId: exampleOpenZfsVolume.id,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_open_zfs_file_system = aws.fsx.OpenZfsFileSystem("example",
 *     storage_capacity=64,
 *     subnet_ids=[example_aws_subnet["id"]],
 *     deployment_type="SINGLE_AZ_1",
 *     throughput_capacity=64)
 * example_open_zfs_volume = aws.fsx.OpenZfsVolume("example",
 *     name="example",
 *     parent_volume_id=example_open_zfs_file_system.root_volume_id)
 * example = aws.fsx.OpenZfsSnapshot("example",
 *     name="example",
 *     volume_id=example_open_zfs_volume.id)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleOpenZfsFileSystem = new Aws.Fsx.OpenZfsFileSystem("example", new()
 *     {
 *         StorageCapacity = 64,
 *         SubnetIds = new[]
 *         {
 *             exampleAwsSubnet.Id,
 *         },
 *         DeploymentType = "SINGLE_AZ_1",
 *         ThroughputCapacity = 64,
 *     });
 *     var exampleOpenZfsVolume = new Aws.Fsx.OpenZfsVolume("example", new()
 *     {
 *         Name = "example",
 *         ParentVolumeId = exampleOpenZfsFileSystem.RootVolumeId,
 *     });
 *     var example = new Aws.Fsx.OpenZfsSnapshot("example", new()
 *     {
 *         Name = "example",
 *         VolumeId = exampleOpenZfsVolume.Id,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleOpenZfsFileSystem, err := fsx.NewOpenZfsFileSystem(ctx, "example", &fsx.OpenZfsFileSystemArgs{
 * 			StorageCapacity: pulumi.Int(64),
 * 			SubnetIds: pulumi.StringArray{
 * 				exampleAwsSubnet.Id,
 * 			},
 * 			DeploymentType:     pulumi.String("SINGLE_AZ_1"),
 * 			ThroughputCapacity: pulumi.Int(64),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		exampleOpenZfsVolume, err := fsx.NewOpenZfsVolume(ctx, "example", &fsx.OpenZfsVolumeArgs{
 * 			Name:           pulumi.String("example"),
 * 			ParentVolumeId: exampleOpenZfsFileSystem.RootVolumeId,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = fsx.NewOpenZfsSnapshot(ctx, "example", &fsx.OpenZfsSnapshotArgs{
 * 			Name:     pulumi.String("example"),
 * 			VolumeId: exampleOpenZfsVolume.ID(),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OpenZfsFileSystem;
 * import com.pulumi.aws.fsx.OpenZfsFileSystemArgs;
 * import com.pulumi.aws.fsx.OpenZfsVolume;
 * import com.pulumi.aws.fsx.OpenZfsVolumeArgs;
 * import com.pulumi.aws.fsx.OpenZfsSnapshot;
 * import com.pulumi.aws.fsx.OpenZfsSnapshotArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleOpenZfsFileSystem = new OpenZfsFileSystem("exampleOpenZfsFileSystem", OpenZfsFileSystemArgs.builder()
 *             .storageCapacity(64)
 *             .subnetIds(exampleAwsSubnet.id())
 *             .deploymentType("SINGLE_AZ_1")
 *             .throughputCapacity(64)
 *             .build());
 *         var exampleOpenZfsVolume = new OpenZfsVolume("exampleOpenZfsVolume", OpenZfsVolumeArgs.builder()
 *             .name("example")
 *             .parentVolumeId(exampleOpenZfsFileSystem.rootVolumeId())
 *             .build());
 *         var example = new OpenZfsSnapshot("example", OpenZfsSnapshotArgs.builder()
 *             .name("example")
 *             .volumeId(exampleOpenZfsVolume.id())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:fsx:OpenZfsSnapshot
 *     properties:
 *       name: example
 *       volumeId: ${exampleOpenZfsVolume.id}
 *   exampleOpenZfsVolume:
 *     type: aws:fsx:OpenZfsVolume
 *     name: example
 *     properties:
 *       name: example
 *       parentVolumeId: ${exampleOpenZfsFileSystem.rootVolumeId}
 *   exampleOpenZfsFileSystem:
 *     type: aws:fsx:OpenZfsFileSystem
 *     name: example
 *     properties:
 *       storageCapacity: 64
 *       subnetIds:
 *         - ${exampleAwsSubnet.id}
 *       deploymentType: SINGLE_AZ_1
 *       throughputCapacity: 64
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx OpenZFS snapshot using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/openZfsSnapshot:OpenZfsSnapshot example fs-543ab12b1ca672f33
 * ```
 * @property name The name of the Snapshot. You can use a maximum of 203 alphanumeric characters plus either _ or -  or : or . for the name.
 * @property tags A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
 * @property volumeId The ID of the volume to snapshot. This can be the root volume or a child volume.
 */
public data class OpenZfsSnapshotArgs(
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val volumeId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.OpenZfsSnapshotArgs> {
    override fun toJava(): com.pulumi.aws.fsx.OpenZfsSnapshotArgs =
        com.pulumi.aws.fsx.OpenZfsSnapshotArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .volumeId(volumeId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenZfsSnapshotArgs].
 */
@PulumiTagMarker
public class OpenZfsSnapshotArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var volumeId: Output<String>? = null

    /**
     * @param value The name of the Snapshot. You can use a maximum of 203 alphanumeric characters plus either _ or -  or : or . for the name.
     */
    @JvmName("dnaiyufgjhrivfob")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     */
    @JvmName("cpyhiqtdxqaihswo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The ID of the volume to snapshot. This can be the root volume or a child volume.
     */
    @JvmName("imunuaxxqxxrfmig")
    public suspend fun volumeId(`value`: Output<String>) {
        this.volumeId = value
    }

    /**
     * @param value The name of the Snapshot. You can use a maximum of 203 alphanumeric characters plus either _ or -  or : or . for the name.
     */
    @JvmName("aytaujndxiskkyyh")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     */
    @JvmName("huubyckgayodawxi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level. If you have set `copy_tags_to_backups` to true, and you specify one or more tags, no existing file system tags are copied from the file system to the backup.
     */
    @JvmName("gbxonqeocjbjkckv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The ID of the volume to snapshot. This can be the root volume or a child volume.
     */
    @JvmName("lfybojtrxjafkguk")
    public suspend fun volumeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeId = mapped
    }

    internal fun build(): OpenZfsSnapshotArgs = OpenZfsSnapshotArgs(
        name = name,
        tags = tags,
        volumeId = volumeId,
    )
}
