@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.kotlin.outputs.OpenZfsVolumeNfsExports
import com.pulumi.aws.fsx.kotlin.outputs.OpenZfsVolumeOriginSnapshot
import com.pulumi.aws.fsx.kotlin.outputs.OpenZfsVolumeUserAndGroupQuota
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.fsx.kotlin.outputs.OpenZfsVolumeNfsExports.Companion.toKotlin as openZfsVolumeNfsExportsToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.OpenZfsVolumeOriginSnapshot.Companion.toKotlin as openZfsVolumeOriginSnapshotToKotlin
import com.pulumi.aws.fsx.kotlin.outputs.OpenZfsVolumeUserAndGroupQuota.Companion.toKotlin as openZfsVolumeUserAndGroupQuotaToKotlin

/**
 * Builder for [OpenZfsVolume].
 */
@PulumiTagMarker
public class OpenZfsVolumeResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OpenZfsVolumeArgs = OpenZfsVolumeArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OpenZfsVolumeArgsBuilder.() -> Unit) {
        val builder = OpenZfsVolumeArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OpenZfsVolume {
        val builtJavaResource = com.pulumi.aws.fsx.OpenZfsVolume(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OpenZfsVolume(builtJavaResource)
    }
}

/**
 * Manages an Amazon FSx for OpenZFS volume.
 * See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OpenZfsVolume("test", {
 *     name: "testvolume",
 *     parentVolumeId: testAwsFsxOpenzfsFileSystem.rootVolumeId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OpenZfsVolume("test",
 *     name="testvolume",
 *     parent_volume_id=test_aws_fsx_openzfs_file_system["rootVolumeId"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OpenZfsVolume("test", new()
 *     {
 *         Name = "testvolume",
 *         ParentVolumeId = testAwsFsxOpenzfsFileSystem.RootVolumeId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOpenZfsVolume(ctx, "test", &fsx.OpenZfsVolumeArgs{
 * 			Name:           pulumi.String("testvolume"),
 * 			ParentVolumeId: pulumi.Any(testAwsFsxOpenzfsFileSystem.RootVolumeId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OpenZfsVolume;
 * import com.pulumi.aws.fsx.OpenZfsVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OpenZfsVolume("test", OpenZfsVolumeArgs.builder()
 *             .name("testvolume")
 *             .parentVolumeId(testAwsFsxOpenzfsFileSystem.rootVolumeId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OpenZfsVolume
 *     properties:
 *       name: testvolume
 *       parentVolumeId: ${testAwsFsxOpenzfsFileSystem.rootVolumeId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx Volumes using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/openZfsVolume:OpenZfsVolume example fsvol-543ab12b1ca672f33
 * ```
 */
public class OpenZfsVolume internal constructor(
    override val javaResource: com.pulumi.aws.fsx.OpenZfsVolume,
) : KotlinCustomResource(javaResource, OpenZfsVolumeMapper) {
    /**
     * Amazon Resource Name of the file system.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     */
    public val copyTagsToSnapshots: Output<Boolean>?
        get() = javaResource.copyTagsToSnapshots().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
     */
    public val dataCompressionType: Output<String>?
        get() = javaResource.dataCompressionType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
     */
    public val deleteVolumeOptions: Output<String>?
        get() = javaResource.deleteVolumeOptions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
     */
    public val nfsExports: Output<OpenZfsVolumeNfsExports>?
        get() = javaResource.nfsExports().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    openZfsVolumeNfsExportsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
     */
    public val originSnapshot: Output<OpenZfsVolumeOriginSnapshot>?
        get() = javaResource.originSnapshot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> openZfsVolumeOriginSnapshotToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `aws.fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `aws.fsx.OpenZfsVolume`.
     */
    public val parentVolumeId: Output<String>
        get() = javaResource.parentVolumeId().applyValue({ args0 -> args0 })

    /**
     * specifies whether the volume is read-only. Default is false.
     */
    public val readOnly: Output<Boolean>
        get() = javaResource.readOnly().applyValue({ args0 -> args0 })

    /**
     * The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
     */
    public val recordSizeKib: Output<Int>?
        get() = javaResource.recordSizeKib().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
     */
    public val storageCapacityQuotaGib: Output<Int>
        get() = javaResource.storageCapacityQuotaGib().applyValue({ args0 -> args0 })

    /**
     * The amount of storage in gibibytes (GiB) to reserve from the parent volume.
     */
    public val storageCapacityReservationGib: Output<Int>
        get() = javaResource.storageCapacityReservationGib().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
     */
    public val userAndGroupQuotas: Output<List<OpenZfsVolumeUserAndGroupQuota>>
        get() = javaResource.userAndGroupQuotas().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> openZfsVolumeUserAndGroupQuotaToKotlin(args0) })
            })
        })

    public val volumeType: Output<String>?
        get() = javaResource.volumeType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object OpenZfsVolumeMapper : ResourceMapper<OpenZfsVolume> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.fsx.OpenZfsVolume::class == javaResource::class

    override fun map(javaResource: Resource): OpenZfsVolume = OpenZfsVolume(
        javaResource as
            com.pulumi.aws.fsx.OpenZfsVolume,
    )
}

/**
 * @see [OpenZfsVolume].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OpenZfsVolume].
 */
public suspend fun openZfsVolume(
    name: String,
    block: suspend OpenZfsVolumeResourceBuilder.() -> Unit,
): OpenZfsVolume {
    val builder = OpenZfsVolumeResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OpenZfsVolume].
 * @param name The _unique_ name of the resulting resource.
 */
public fun openZfsVolume(name: String): OpenZfsVolume {
    val builder = OpenZfsVolumeResourceBuilder()
    builder.name(name)
    return builder.build()
}
