@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin

import com.pulumi.aws.fsx.OpenZfsVolumeArgs.builder
import com.pulumi.aws.fsx.kotlin.inputs.OpenZfsVolumeNfsExportsArgs
import com.pulumi.aws.fsx.kotlin.inputs.OpenZfsVolumeNfsExportsArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.OpenZfsVolumeOriginSnapshotArgs
import com.pulumi.aws.fsx.kotlin.inputs.OpenZfsVolumeOriginSnapshotArgsBuilder
import com.pulumi.aws.fsx.kotlin.inputs.OpenZfsVolumeUserAndGroupQuotaArgs
import com.pulumi.aws.fsx.kotlin.inputs.OpenZfsVolumeUserAndGroupQuotaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an Amazon FSx for OpenZFS volume.
 * See the [FSx OpenZFS User Guide](https://docs.aws.amazon.com/fsx/latest/OpenZFSGuide/what-is-fsx.html) for more information.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.fsx.OpenZfsVolume("test", {
 *     name: "testvolume",
 *     parentVolumeId: testAwsFsxOpenzfsFileSystem.rootVolumeId,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.fsx.OpenZfsVolume("test",
 *     name="testvolume",
 *     parent_volume_id=test_aws_fsx_openzfs_file_system["rootVolumeId"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.Fsx.OpenZfsVolume("test", new()
 *     {
 *         Name = "testvolume",
 *         ParentVolumeId = testAwsFsxOpenzfsFileSystem.RootVolumeId,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/fsx"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := fsx.NewOpenZfsVolume(ctx, "test", &fsx.OpenZfsVolumeArgs{
 * 			Name:           pulumi.String("testvolume"),
 * 			ParentVolumeId: pulumi.Any(testAwsFsxOpenzfsFileSystem.RootVolumeId),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.fsx.OpenZfsVolume;
 * import com.pulumi.aws.fsx.OpenZfsVolumeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new OpenZfsVolume("test", OpenZfsVolumeArgs.builder()
 *             .name("testvolume")
 *             .parentVolumeId(testAwsFsxOpenzfsFileSystem.rootVolumeId())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:fsx:OpenZfsVolume
 *     properties:
 *       name: testvolume
 *       parentVolumeId: ${testAwsFsxOpenzfsFileSystem.rootVolumeId}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import FSx Volumes using the `id`. For example:
 * ```sh
 * $ pulumi import aws:fsx/openZfsVolume:OpenZfsVolume example fsvol-543ab12b1ca672f33
 * ```
 * @property copyTagsToSnapshots A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
 * @property dataCompressionType Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
 * @property deleteVolumeOptions Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
 * @property name The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
 * @property nfsExports NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
 * @property originSnapshot Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
 * @property parentVolumeId The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `aws.fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `aws.fsx.OpenZfsVolume`.
 * @property readOnly specifies whether the volume is read-only. Default is false.
 * @property recordSizeKib The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
 * @property storageCapacityQuotaGib The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
 * @property storageCapacityReservationGib The amount of storage in gibibytes (GiB) to reserve from the parent volume.
 * @property tags A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userAndGroupQuotas Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
 * @property volumeType
 */
public data class OpenZfsVolumeArgs(
    public val copyTagsToSnapshots: Output<Boolean>? = null,
    public val dataCompressionType: Output<String>? = null,
    public val deleteVolumeOptions: Output<String>? = null,
    public val name: Output<String>? = null,
    public val nfsExports: Output<OpenZfsVolumeNfsExportsArgs>? = null,
    public val originSnapshot: Output<OpenZfsVolumeOriginSnapshotArgs>? = null,
    public val parentVolumeId: Output<String>? = null,
    public val readOnly: Output<Boolean>? = null,
    public val recordSizeKib: Output<Int>? = null,
    public val storageCapacityQuotaGib: Output<Int>? = null,
    public val storageCapacityReservationGib: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userAndGroupQuotas: Output<List<OpenZfsVolumeUserAndGroupQuotaArgs>>? = null,
    public val volumeType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.OpenZfsVolumeArgs> {
    override fun toJava(): com.pulumi.aws.fsx.OpenZfsVolumeArgs =
        com.pulumi.aws.fsx.OpenZfsVolumeArgs.builder()
            .copyTagsToSnapshots(copyTagsToSnapshots?.applyValue({ args0 -> args0 }))
            .dataCompressionType(dataCompressionType?.applyValue({ args0 -> args0 }))
            .deleteVolumeOptions(deleteVolumeOptions?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .nfsExports(nfsExports?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .originSnapshot(originSnapshot?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parentVolumeId(parentVolumeId?.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 }))
            .recordSizeKib(recordSizeKib?.applyValue({ args0 -> args0 }))
            .storageCapacityQuotaGib(storageCapacityQuotaGib?.applyValue({ args0 -> args0 }))
            .storageCapacityReservationGib(storageCapacityReservationGib?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userAndGroupQuotas(
                userAndGroupQuotas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .volumeType(volumeType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenZfsVolumeArgs].
 */
@PulumiTagMarker
public class OpenZfsVolumeArgsBuilder internal constructor() {
    private var copyTagsToSnapshots: Output<Boolean>? = null

    private var dataCompressionType: Output<String>? = null

    private var deleteVolumeOptions: Output<String>? = null

    private var name: Output<String>? = null

    private var nfsExports: Output<OpenZfsVolumeNfsExportsArgs>? = null

    private var originSnapshot: Output<OpenZfsVolumeOriginSnapshotArgs>? = null

    private var parentVolumeId: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    private var recordSizeKib: Output<Int>? = null

    private var storageCapacityQuotaGib: Output<Int>? = null

    private var storageCapacityReservationGib: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userAndGroupQuotas: Output<List<OpenZfsVolumeUserAndGroupQuotaArgs>>? = null

    private var volumeType: Output<String>? = null

    /**
     * @param value A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     */
    @JvmName("gyauitoahmntihms")
    public suspend fun copyTagsToSnapshots(`value`: Output<Boolean>) {
        this.copyTagsToSnapshots = value
    }

    /**
     * @param value Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
     */
    @JvmName("jiyaielihwnlakmh")
    public suspend fun dataCompressionType(`value`: Output<String>) {
        this.dataCompressionType = value
    }

    /**
     * @param value Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
     */
    @JvmName("tlbonuvrcijbjiro")
    public suspend fun deleteVolumeOptions(`value`: Output<String>) {
        this.deleteVolumeOptions = value
    }

    /**
     * @param value The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     */
    @JvmName("gylwwkwixsutyyol")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
     */
    @JvmName("jwrcsoeynjwqbxsd")
    public suspend fun nfsExports(`value`: Output<OpenZfsVolumeNfsExportsArgs>) {
        this.nfsExports = value
    }

    /**
     * @param value Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
     */
    @JvmName("hqcgfuyqbeyqxgsm")
    public suspend fun originSnapshot(`value`: Output<OpenZfsVolumeOriginSnapshotArgs>) {
        this.originSnapshot = value
    }

    /**
     * @param value The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `aws.fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `aws.fsx.OpenZfsVolume`.
     */
    @JvmName("lrelaihyqkohglmn")
    public suspend fun parentVolumeId(`value`: Output<String>) {
        this.parentVolumeId = value
    }

    /**
     * @param value specifies whether the volume is read-only. Default is false.
     */
    @JvmName("jhernkwhtoqqpyeq")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
     */
    @JvmName("qgybinlrjrmvlkql")
    public suspend fun recordSizeKib(`value`: Output<Int>) {
        this.recordSizeKib = value
    }

    /**
     * @param value The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
     */
    @JvmName("adhcftbtrulhewyr")
    public suspend fun storageCapacityQuotaGib(`value`: Output<Int>) {
        this.storageCapacityQuotaGib = value
    }

    /**
     * @param value The amount of storage in gibibytes (GiB) to reserve from the parent volume.
     */
    @JvmName("lygxnhgkttibtehv")
    public suspend fun storageCapacityReservationGib(`value`: Output<Int>) {
        this.storageCapacityReservationGib = value
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("olcabpylplgsuqlc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
     */
    @JvmName("pdgrjeswblxksssa")
    public suspend fun userAndGroupQuotas(`value`: Output<List<OpenZfsVolumeUserAndGroupQuotaArgs>>) {
        this.userAndGroupQuotas = value
    }

    @JvmName("myfekrqrtimfshug")
    public suspend fun userAndGroupQuotas(vararg values: Output<OpenZfsVolumeUserAndGroupQuotaArgs>) {
        this.userAndGroupQuotas = Output.all(values.asList())
    }

    /**
     * @param values Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
     */
    @JvmName("dhmvnaymobokgjck")
    public suspend fun userAndGroupQuotas(values: List<Output<OpenZfsVolumeUserAndGroupQuotaArgs>>) {
        this.userAndGroupQuotas = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("scruexpeefwepylk")
    public suspend fun volumeType(`value`: Output<String>) {
        this.volumeType = value
    }

    /**
     * @param value A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     */
    @JvmName("saihytjgkliqohyc")
    public suspend fun copyTagsToSnapshots(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToSnapshots = mapped
    }

    /**
     * @param value Method used to compress the data on the volume. Valid values are `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
     */
    @JvmName("eukfpnrvfltvuokj")
    public suspend fun dataCompressionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCompressionType = mapped
    }

    /**
     * @param value Whether to delete all child volumes and snapshots. Valid values: `DELETE_CHILD_VOLUMES_AND_SNAPSHOTS`. This configuration must be applied separately before attempting to delete the resource to have the desired behavior..
     */
    @JvmName("jtlbgatgfwbevkwt")
    public suspend fun deleteVolumeOptions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteVolumeOptions = mapped
    }

    /**
     * @param value The name of the Volume. You can use a maximum of 203 alphanumeric characters, plus the underscore (_) special character.
     */
    @JvmName("hlllmwigsrmgrnmr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
     */
    @JvmName("rdcctvyjskcmrsok")
    public suspend fun nfsExports(`value`: OpenZfsVolumeNfsExportsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsExports = mapped
    }

    /**
     * @param argument NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block Below for details.
     */
    @JvmName("vplxjtgaippgwjpp")
    public suspend fun nfsExports(argument: suspend OpenZfsVolumeNfsExportsArgsBuilder.() -> Unit) {
        val toBeMapped = OpenZfsVolumeNfsExportsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.nfsExports = mapped
    }

    /**
     * @param value Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
     */
    @JvmName("kjdxfyturocukhwy")
    public suspend fun originSnapshot(`value`: OpenZfsVolumeOriginSnapshotArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.originSnapshot = mapped
    }

    /**
     * @param argument Specifies the configuration to use when creating the OpenZFS volume. See `origin_snapshot` Block below for details.
     */
    @JvmName("nxmqkwvksscepsne")
    public suspend fun originSnapshot(argument: suspend OpenZfsVolumeOriginSnapshotArgsBuilder.() -> Unit) {
        val toBeMapped = OpenZfsVolumeOriginSnapshotArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.originSnapshot = mapped
    }

    /**
     * @param value The volume id of volume that will be the parent volume for the volume being created, this could be the root volume created from the `aws.fsx.OpenZfsFileSystem` resource with the `root_volume_id` or the `id` property of another `aws.fsx.OpenZfsVolume`.
     */
    @JvmName("usudxosrcowdyoue")
    public suspend fun parentVolumeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentVolumeId = mapped
    }

    /**
     * @param value specifies whether the volume is read-only. Default is false.
     */
    @JvmName("plujpqjtworvciet")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    /**
     * @param value The record size of an OpenZFS volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
     */
    @JvmName("muvamhqrtbofxgfi")
    public suspend fun recordSizeKib(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordSizeKib = mapped
    }

    /**
     * @param value The maximum amount of storage in gibibytes (GiB) that the volume can use from its parent.
     */
    @JvmName("mxpruhebrajsovua")
    public suspend fun storageCapacityQuotaGib(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacityQuotaGib = mapped
    }

    /**
     * @param value The amount of storage in gibibytes (GiB) to reserve from the parent volume.
     */
    @JvmName("cwybbjuoonlaafay")
    public suspend fun storageCapacityReservationGib(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageCapacityReservationGib = mapped
    }

    /**
     * @param value A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("nqrjrlthxrieocth")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file system. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cwjrhcbqkklmhoun")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
     */
    @JvmName("icqyqprymfqsjikj")
    public suspend fun userAndGroupQuotas(`value`: List<OpenZfsVolumeUserAndGroupQuotaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAndGroupQuotas = mapped
    }

    /**
     * @param argument Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
     */
    @JvmName("mkkafwnhslqrgibn")
    public suspend fun userAndGroupQuotas(argument: List<suspend OpenZfsVolumeUserAndGroupQuotaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OpenZfsVolumeUserAndGroupQuotaArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userAndGroupQuotas = mapped
    }

    /**
     * @param argument Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
     */
    @JvmName("jbtgrjklyvjwagyi")
    public suspend fun userAndGroupQuotas(vararg argument: suspend OpenZfsVolumeUserAndGroupQuotaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OpenZfsVolumeUserAndGroupQuotaArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userAndGroupQuotas = mapped
    }

    /**
     * @param argument Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
     */
    @JvmName("jnmsgnonnfypvmdp")
    public suspend fun userAndGroupQuotas(argument: suspend OpenZfsVolumeUserAndGroupQuotaArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            OpenZfsVolumeUserAndGroupQuotaArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.userAndGroupQuotas = mapped
    }

    /**
     * @param values Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block Below.
     */
    @JvmName("rcyphsojybqkvssk")
    public suspend fun userAndGroupQuotas(vararg values: OpenZfsVolumeUserAndGroupQuotaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAndGroupQuotas = mapped
    }

    /**
     * @param value
     */
    @JvmName("ydxlyiybytjrtkiq")
    public suspend fun volumeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeType = mapped
    }

    internal fun build(): OpenZfsVolumeArgs = OpenZfsVolumeArgs(
        copyTagsToSnapshots = copyTagsToSnapshots,
        dataCompressionType = dataCompressionType,
        deleteVolumeOptions = deleteVolumeOptions,
        name = name,
        nfsExports = nfsExports,
        originSnapshot = originSnapshot,
        parentVolumeId = parentVolumeId,
        readOnly = readOnly,
        recordSizeKib = recordSizeKib,
        storageCapacityQuotaGib = storageCapacityQuotaGib,
        storageCapacityReservationGib = storageCapacityReservationGib,
        tags = tags,
        userAndGroupQuotas = userAndGroupQuotas,
        volumeType = volumeType,
    )
}
