@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3AutoImportPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property events A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
 */
public data class DataRepositoryAssociationS3AutoImportPolicyArgs(
    public val events: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3AutoImportPolicyArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3AutoImportPolicyArgs =
        com.pulumi.aws.fsx.inputs.DataRepositoryAssociationS3AutoImportPolicyArgs.builder()
            .events(events?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DataRepositoryAssociationS3AutoImportPolicyArgs].
 */
@PulumiTagMarker
public class DataRepositoryAssociationS3AutoImportPolicyArgsBuilder internal constructor() {
    private var events: Output<List<String>>? = null

    /**
     * @param value A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
     */
    @JvmName("rpewlojjadvohpfp")
    public suspend fun events(`value`: Output<List<String>>) {
        this.events = value
    }

    @JvmName("xmgjejdbpsacrxyj")
    public suspend fun events(vararg values: Output<String>) {
        this.events = Output.all(values.asList())
    }

    /**
     * @param values A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
     */
    @JvmName("vivbfaehkhknkrhy")
    public suspend fun events(values: List<Output<String>>) {
        this.events = Output.all(values)
    }

    /**
     * @param value A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
     */
    @JvmName("foegrqcfkfdwtccf")
    public suspend fun events(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.events = mapped
    }

    /**
     * @param values A list of file event types to automatically export to your linked S3 bucket or import from the linked S3 bucket. Valid values are `NEW`, `CHANGED`, `DELETED`. Max of 3.
     */
    @JvmName("icfygrkwbanmkmjw")
    public suspend fun events(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.events = mapped
    }

    internal fun build(): DataRepositoryAssociationS3AutoImportPolicyArgs =
        DataRepositoryAssociationS3AutoImportPolicyArgs(
            events = events,
        )
}
