@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property deploymentType Specifies the cache deployment type. The only supported value is `CACHE_1`.
 * @property logConfigurations
 * @property metadataConfigurations The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
 * @property mountName
 * @property perUnitStorageThroughput Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity, in MB/s/TiB. The only supported value is `1000`.
 * @property weeklyMaintenanceStartTime A recurring weekly time, in the format `D:HH:MM`. `D` is the day of the week, for which `1` represents Monday and `7` represents Sunday. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, 1:05:00 specifies maintenance at 5 AM Monday. See the [ISO week date](https://en.wikipedia.org/wiki/ISO_week_date) for more information.
 */
public data class FileCacheLustreConfigurationArgs(
    public val deploymentType: Output<String>,
    public val logConfigurations: Output<List<FileCacheLustreConfigurationLogConfigurationArgs>>? =
        null,
    public val metadataConfigurations: Output<List<FileCacheLustreConfigurationMetadataConfigurationArgs>>,
    public val mountName: Output<String>? = null,
    public val perUnitStorageThroughput: Output<Int>,
    public val weeklyMaintenanceStartTime: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationArgs =
        com.pulumi.aws.fsx.inputs.FileCacheLustreConfigurationArgs.builder()
            .deploymentType(deploymentType.applyValue({ args0 -> args0 }))
            .logConfigurations(
                logConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .metadataConfigurations(
                metadataConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .mountName(mountName?.applyValue({ args0 -> args0 }))
            .perUnitStorageThroughput(perUnitStorageThroughput.applyValue({ args0 -> args0 }))
            .weeklyMaintenanceStartTime(weeklyMaintenanceStartTime?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileCacheLustreConfigurationArgs].
 */
@PulumiTagMarker
public class FileCacheLustreConfigurationArgsBuilder internal constructor() {
    private var deploymentType: Output<String>? = null

    private var logConfigurations: Output<List<FileCacheLustreConfigurationLogConfigurationArgs>>? =
        null

    private var metadataConfigurations:
        Output<List<FileCacheLustreConfigurationMetadataConfigurationArgs>>? = null

    private var mountName: Output<String>? = null

    private var perUnitStorageThroughput: Output<Int>? = null

    private var weeklyMaintenanceStartTime: Output<String>? = null

    /**
     * @param value Specifies the cache deployment type. The only supported value is `CACHE_1`.
     */
    @JvmName("ngbimtltyinppnvf")
    public suspend fun deploymentType(`value`: Output<String>) {
        this.deploymentType = value
    }

    /**
     * @param value
     */
    @JvmName("ksbevwfkyiksenml")
    public suspend fun logConfigurations(`value`: Output<List<FileCacheLustreConfigurationLogConfigurationArgs>>) {
        this.logConfigurations = value
    }

    @JvmName("jhtxooxlajvqvrlb")
    public suspend fun logConfigurations(vararg values: Output<FileCacheLustreConfigurationLogConfigurationArgs>) {
        this.logConfigurations = Output.all(values.asList())
    }

    /**
     * @param values
     */
    @JvmName("yrclsdglshjbmbjw")
    public suspend fun logConfigurations(values: List<Output<FileCacheLustreConfigurationLogConfigurationArgs>>) {
        this.logConfigurations = Output.all(values)
    }

    /**
     * @param value The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
     */
    @JvmName("yrtxmbghqkyhnawy")
    public suspend fun metadataConfigurations(`value`: Output<List<FileCacheLustreConfigurationMetadataConfigurationArgs>>) {
        this.metadataConfigurations = value
    }

    @JvmName("qxnrjwufuqdsvgmm")
    public suspend fun metadataConfigurations(vararg values: Output<FileCacheLustreConfigurationMetadataConfigurationArgs>) {
        this.metadataConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
     */
    @JvmName("chxmvwlhvlxyewus")
    public suspend fun metadataConfigurations(values: List<Output<FileCacheLustreConfigurationMetadataConfigurationArgs>>) {
        this.metadataConfigurations = Output.all(values)
    }

    /**
     * @param value
     */
    @JvmName("bydljxjhextchokd")
    public suspend fun mountName(`value`: Output<String>) {
        this.mountName = value
    }

    /**
     * @param value Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity, in MB/s/TiB. The only supported value is `1000`.
     */
    @JvmName("csxwwxgggljjnbwq")
    public suspend fun perUnitStorageThroughput(`value`: Output<Int>) {
        this.perUnitStorageThroughput = value
    }

    /**
     * @param value A recurring weekly time, in the format `D:HH:MM`. `D` is the day of the week, for which `1` represents Monday and `7` represents Sunday. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, 1:05:00 specifies maintenance at 5 AM Monday. See the [ISO week date](https://en.wikipedia.org/wiki/ISO_week_date) for more information.
     */
    @JvmName("ktxbkkpkgthrmbdb")
    public suspend fun weeklyMaintenanceStartTime(`value`: Output<String>) {
        this.weeklyMaintenanceStartTime = value
    }

    /**
     * @param value Specifies the cache deployment type. The only supported value is `CACHE_1`.
     */
    @JvmName("vorenwhlndpdqgkl")
    public suspend fun deploymentType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.deploymentType = mapped
    }

    /**
     * @param value
     */
    @JvmName("isvfegwfelgrxyll")
    public suspend fun logConfigurations(`value`: List<FileCacheLustreConfigurationLogConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logConfigurations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("tpccajbongivbrft")
    public suspend fun logConfigurations(argument: List<suspend FileCacheLustreConfigurationLogConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FileCacheLustreConfigurationLogConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logConfigurations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("qywxledjhkplqkro")
    public suspend fun logConfigurations(vararg argument: suspend FileCacheLustreConfigurationLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FileCacheLustreConfigurationLogConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.logConfigurations = mapped
    }

    /**
     * @param argument
     */
    @JvmName("lebkeeodbtkykgup")
    public suspend fun logConfigurations(argument: suspend FileCacheLustreConfigurationLogConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FileCacheLustreConfigurationLogConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.logConfigurations = mapped
    }

    /**
     * @param values
     */
    @JvmName("qamblldjdruxhnkl")
    public suspend fun logConfigurations(vararg values: FileCacheLustreConfigurationLogConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logConfigurations = mapped
    }

    /**
     * @param value The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
     */
    @JvmName("tnkspxcbyovsppyq")
    public suspend fun metadataConfigurations(`value`: List<FileCacheLustreConfigurationMetadataConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadataConfigurations = mapped
    }

    /**
     * @param argument The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
     */
    @JvmName("boqgmcivwvhijtgi")
    public suspend fun metadataConfigurations(argument: List<suspend FileCacheLustreConfigurationMetadataConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FileCacheLustreConfigurationMetadataConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadataConfigurations = mapped
    }

    /**
     * @param argument The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
     */
    @JvmName("kssemjtlxydrqhbx")
    public suspend fun metadataConfigurations(vararg argument: suspend FileCacheLustreConfigurationMetadataConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FileCacheLustreConfigurationMetadataConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.metadataConfigurations = mapped
    }

    /**
     * @param argument The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
     */
    @JvmName("yhxnrwswbuvdevep")
    public suspend fun metadataConfigurations(argument: suspend FileCacheLustreConfigurationMetadataConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                FileCacheLustreConfigurationMetadataConfigurationArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.metadataConfigurations = mapped
    }

    /**
     * @param values The configuration for a Lustre MDT (Metadata Target) storage volume. See the `metadata_configuration` block.
     */
    @JvmName("ntxubhjpynywlaay")
    public suspend fun metadataConfigurations(vararg values: FileCacheLustreConfigurationMetadataConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadataConfigurations = mapped
    }

    /**
     * @param value
     */
    @JvmName("onmivgbwvhnkjyfj")
    public suspend fun mountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountName = mapped
    }

    /**
     * @param value Provisions the amount of read and write throughput for each 1 tebibyte (TiB) of cache storage capacity, in MB/s/TiB. The only supported value is `1000`.
     */
    @JvmName("ukvsjdrfnugyoldb")
    public suspend fun perUnitStorageThroughput(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.perUnitStorageThroughput = mapped
    }

    /**
     * @param value A recurring weekly time, in the format `D:HH:MM`. `D` is the day of the week, for which `1` represents Monday and `7` represents Sunday. `HH` is the zero-padded hour of the day (0-23), and `MM` is the zero-padded minute of the hour. For example, 1:05:00 specifies maintenance at 5 AM Monday. See the [ISO week date](https://en.wikipedia.org/wiki/ISO_week_date) for more information.
     */
    @JvmName("onsrjfitdlkkvubr")
    public suspend fun weeklyMaintenanceStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.weeklyMaintenanceStartTime = mapped
    }

    internal fun build(): FileCacheLustreConfigurationArgs = FileCacheLustreConfigurationArgs(
        deploymentType = deploymentType ?: throw PulumiNullFieldException("deploymentType"),
        logConfigurations = logConfigurations,
        metadataConfigurations = metadataConfigurations ?: throw
            PulumiNullFieldException("metadataConfigurations"),
        mountName = mountName,
        perUnitStorageThroughput = perUnitStorageThroughput ?: throw
            PulumiNullFieldException("perUnitStorageThroughput"),
        weeklyMaintenanceStartTime = weeklyMaintenanceStartTime,
    )
}
