@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.GetOntapFileSystemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOntapFileSystem.
 * @property id Identifier of the file system (e.g. `fs-12345678`).
 * @property tags The tags associated with the file system.
 */
public data class GetOntapFileSystemPlainArgs(
    public val id: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.GetOntapFileSystemPlainArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.GetOntapFileSystemPlainArgs =
        com.pulumi.aws.fsx.inputs.GetOntapFileSystemPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetOntapFileSystemPlainArgs].
 */
@PulumiTagMarker
public class GetOntapFileSystemPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Identifier of the file system (e.g. `fs-12345678`).
     */
    @JvmName("qkgyfurcvfkhqbam")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The tags associated with the file system.
     */
    @JvmName("yhoprevonwnegich")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values The tags associated with the file system.
     */
    @JvmName("xsqdegurtbddwwcv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetOntapFileSystemPlainArgs = GetOntapFileSystemPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        tags = tags,
    )
}
