@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOntapStorageVirtualMachine.
 * @property filters Configuration block. Detailed below.
 * @property id Identifier of the storage virtual machine (e.g. `svm-12345678`).
 * @property tags
 */
public data class GetOntapStorageVirtualMachinePlainArgs(
    public val filters: List<GetOntapStorageVirtualMachineFilter>? = null,
    public val id: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinePlainArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinePlainArgs =
        com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinePlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .id(id?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetOntapStorageVirtualMachinePlainArgs].
 */
@PulumiTagMarker
public class GetOntapStorageVirtualMachinePlainArgsBuilder internal constructor() {
    private var filters: List<GetOntapStorageVirtualMachineFilter>? = null

    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("ibhtffbegntwsmoc")
    public suspend fun filters(`value`: List<GetOntapStorageVirtualMachineFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("aupgrfbagvmekuoa")
    public suspend fun filters(argument: List<suspend GetOntapStorageVirtualMachineFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetOntapStorageVirtualMachineFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("sruqujmqvobjqssp")
    public suspend fun filters(vararg argument: suspend GetOntapStorageVirtualMachineFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetOntapStorageVirtualMachineFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("sjdsejtdhmseqdrb")
    public suspend fun filters(argument: suspend GetOntapStorageVirtualMachineFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetOntapStorageVirtualMachineFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("barraehyvxobjgml")
    public suspend fun filters(vararg values: GetOntapStorageVirtualMachineFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value Identifier of the storage virtual machine (e.g. `svm-12345678`).
     */
    @JvmName("toysjdmvjlkgseku")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value
     */
    @JvmName("ayeyoxkrrrykmtex")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("jyidydhvcysftcqs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetOntapStorageVirtualMachinePlainArgs =
        GetOntapStorageVirtualMachinePlainArgs(
            filters = filters,
            id = id,
            tags = tags,
        )
}
