@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinesFilter.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/fsx/latest/APIReference/API_StorageVirtualMachineFilter.html).
 * @property values Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
 */
public data class GetOntapStorageVirtualMachinesFilter(
    public val name: String,
    public val values: List<String>,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinesFilter> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinesFilter =
        com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinesFilter.builder()
            .name(name.let({ args0 -> args0 }))
            .values(values.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetOntapStorageVirtualMachinesFilter].
 */
@PulumiTagMarker
public class GetOntapStorageVirtualMachinesFilterBuilder internal constructor() {
    private var name: String? = null

    private var values: List<String>? = null

    /**
     * @param value Name of the field to filter by, as defined by [the underlying AWS API](https://docs.aws.amazon.com/fsx/latest/APIReference/API_StorageVirtualMachineFilter.html).
     */
    @JvmName("bjbjumlayjqxlinb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
     */
    @JvmName("ywtqtmshptmuxknk")
    public suspend fun values(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    /**
     * @param values Set of values that are accepted for the given field. An SVM will be selected if any one of the given values matches.
     */
    @JvmName("kauvaeoljbmbikyf")
    public suspend fun values(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.values = mapped
    }

    internal fun build(): GetOntapStorageVirtualMachinesFilter = GetOntapStorageVirtualMachinesFilter(
        name = name ?: throw PulumiNullFieldException("name"),
        values = values ?: throw PulumiNullFieldException("values"),
    )
}
