@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOntapStorageVirtualMachines.
 * @property filters Configuration block. Detailed below.
 */
public data class GetOntapStorageVirtualMachinesPlainArgs(
    public val filters: List<GetOntapStorageVirtualMachinesFilter>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinesPlainArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinesPlainArgs =
        com.pulumi.aws.fsx.inputs.GetOntapStorageVirtualMachinesPlainArgs.builder()
            .filters(
                filters?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetOntapStorageVirtualMachinesPlainArgs].
 */
@PulumiTagMarker
public class GetOntapStorageVirtualMachinesPlainArgsBuilder internal constructor() {
    private var filters: List<GetOntapStorageVirtualMachinesFilter>? = null

    /**
     * @param value Configuration block. Detailed below.
     */
    @JvmName("stjlgtwomhsmrtpg")
    public suspend fun filters(`value`: List<GetOntapStorageVirtualMachinesFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("euiqbmaxhtjtaeen")
    public suspend fun filters(argument: List<suspend GetOntapStorageVirtualMachinesFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetOntapStorageVirtualMachinesFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("idtwskpyuhohveyr")
    public suspend fun filters(vararg argument: suspend GetOntapStorageVirtualMachinesFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetOntapStorageVirtualMachinesFilterBuilder().applySuspend { it() }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument Configuration block. Detailed below.
     */
    @JvmName("rqfuspvufxcmmmjj")
    public suspend fun filters(argument: suspend GetOntapStorageVirtualMachinesFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(
            GetOntapStorageVirtualMachinesFilterBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values Configuration block. Detailed below.
     */
    @JvmName("qxspitbwxaxbvvcv")
    public suspend fun filters(vararg values: GetOntapStorageVirtualMachinesFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    internal fun build(): GetOntapStorageVirtualMachinesPlainArgs =
        GetOntapStorageVirtualMachinesPlainArgs(
            filters = filters,
        )
}
