@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.GetOpenZfsSnapshotPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getOpenZfsSnapshot.
 * @property filters One or more name/value pairs to filter off of. The
 * supported names are file-system-id or volume-id.
 * @property mostRecent If more than one result is returned, use the most recent snapshot.
 * @property name Name of the snapshot.
 * @property snapshotIds Returns information on a specific snapshot_id.
 * @property tags List of Tag values, with a maximum of 50 elements.
 */
public data class GetOpenZfsSnapshotPlainArgs(
    public val filters: List<GetOpenZfsSnapshotFilter>? = null,
    public val mostRecent: Boolean? = null,
    public val name: String? = null,
    public val snapshotIds: List<String>? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.GetOpenZfsSnapshotPlainArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.GetOpenZfsSnapshotPlainArgs =
        com.pulumi.aws.fsx.inputs.GetOpenZfsSnapshotPlainArgs.builder()
            .filters(filters?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .mostRecent(mostRecent?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .snapshotIds(snapshotIds?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetOpenZfsSnapshotPlainArgs].
 */
@PulumiTagMarker
public class GetOpenZfsSnapshotPlainArgsBuilder internal constructor() {
    private var filters: List<GetOpenZfsSnapshotFilter>? = null

    private var mostRecent: Boolean? = null

    private var name: String? = null

    private var snapshotIds: List<String>? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value One or more name/value pairs to filter off of. The
     * supported names are file-system-id or volume-id.
     */
    @JvmName("fexalxomykrkafxa")
    public suspend fun filters(`value`: List<GetOpenZfsSnapshotFilter>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. The
     * supported names are file-system-id or volume-id.
     */
    @JvmName("tyftjfgjuejqumfq")
    public suspend fun filters(argument: List<suspend GetOpenZfsSnapshotFilterBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GetOpenZfsSnapshotFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. The
     * supported names are file-system-id or volume-id.
     */
    @JvmName("jleaxsswcujhtkhd")
    public suspend fun filters(vararg argument: suspend GetOpenZfsSnapshotFilterBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GetOpenZfsSnapshotFilterBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param argument One or more name/value pairs to filter off of. The
     * supported names are file-system-id or volume-id.
     */
    @JvmName("qnjfeeywulneuiin")
    public suspend fun filters(argument: suspend GetOpenZfsSnapshotFilterBuilder.() -> Unit) {
        val toBeMapped = listOf(GetOpenZfsSnapshotFilterBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.filters = mapped
    }

    /**
     * @param values One or more name/value pairs to filter off of. The
     * supported names are file-system-id or volume-id.
     */
    @JvmName("ppiyssquqqauvlpk")
    public suspend fun filters(vararg values: GetOpenZfsSnapshotFilter) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.filters = mapped
    }

    /**
     * @param value If more than one result is returned, use the most recent snapshot.
     */
    @JvmName("hebobwbjdhvftwyr")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    /**
     * @param value Name of the snapshot.
     */
    @JvmName("rnnvkskmtupcutpt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Returns information on a specific snapshot_id.
     */
    @JvmName("ntdimrodytijfexx")
    public suspend fun snapshotIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.snapshotIds = mapped
    }

    /**
     * @param values Returns information on a specific snapshot_id.
     */
    @JvmName("mxinocefludpfdxk")
    public suspend fun snapshotIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.snapshotIds = mapped
    }

    /**
     * @param value List of Tag values, with a maximum of 50 elements.
     */
    @JvmName("eivhmdiqtjjktakh")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values List of Tag values, with a maximum of 50 elements.
     */
    @JvmName("sixevftkcdccdyuw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetOpenZfsSnapshotPlainArgs = GetOpenZfsSnapshotPlainArgs(
        filters = filters,
        mostRecent = mostRecent,
        name = name,
        snapshotIds = snapshotIds,
        tags = tags,
    )
}
