@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.GetWindowsFileSystemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getWindowsFileSystem.
 * @property id Identifier of the file system (e.g. `fs-12345678`).
 * @property tags The tags to associate with the file system.
 */
public data class GetWindowsFileSystemPlainArgs(
    public val id: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.GetWindowsFileSystemPlainArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.GetWindowsFileSystemPlainArgs =
        com.pulumi.aws.fsx.inputs.GetWindowsFileSystemPlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetWindowsFileSystemPlainArgs].
 */
@PulumiTagMarker
public class GetWindowsFileSystemPlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Identifier of the file system (e.g. `fs-12345678`).
     */
    @JvmName("myojeffnhouxjkqr")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value The tags to associate with the file system.
     */
    @JvmName("aqqerxyutlrngkxp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values The tags to associate with the file system.
     */
    @JvmName("kqidjmnljsbmwmay")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetWindowsFileSystemPlainArgs = GetWindowsFileSystemPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        tags = tags,
    )
}
