@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.LustreFileSystemLogConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destination The Amazon Resource Name (ARN) that specifies the destination of the logs. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
 * @property level Sets which data repository events are logged by Amazon FSx. Valid values are `WARN_ONLY`, `FAILURE_ONLY`, `ERROR_ONLY`, `WARN_ERROR` and `DISABLED`. Default value is `DISABLED`.
 */
public data class LustreFileSystemLogConfigurationArgs(
    public val destination: Output<String>? = null,
    public val level: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.LustreFileSystemLogConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.LustreFileSystemLogConfigurationArgs =
        com.pulumi.aws.fsx.inputs.LustreFileSystemLogConfigurationArgs.builder()
            .destination(destination?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LustreFileSystemLogConfigurationArgs].
 */
@PulumiTagMarker
public class LustreFileSystemLogConfigurationArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    private var level: Output<String>? = null

    /**
     * @param value The Amazon Resource Name (ARN) that specifies the destination of the logs. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
     */
    @JvmName("qiitbmmpgoqlrivu")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Sets which data repository events are logged by Amazon FSx. Valid values are `WARN_ONLY`, `FAILURE_ONLY`, `ERROR_ONLY`, `WARN_ERROR` and `DISABLED`. Default value is `DISABLED`.
     */
    @JvmName("rocopmgbfrexpaun")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) that specifies the destination of the logs. The name of the Amazon CloudWatch Logs log group must begin with the `/aws/fsx` prefix. If you do not provide a destination, Amazon FSx will create and use a log stream in the CloudWatch Logs `/aws/fsx/lustre` log group.
     */
    @JvmName("jutwvptsynoaffnd")
    public suspend fun destination(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param value Sets which data repository events are logged by Amazon FSx. Valid values are `WARN_ONLY`, `FAILURE_ONLY`, `ERROR_ONLY`, `WARN_ERROR` and `DISABLED`. Default value is `DISABLED`.
     */
    @JvmName("bwotffxptalmjdtr")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    internal fun build(): LustreFileSystemLogConfigurationArgs = LustreFileSystemLogConfigurationArgs(
        destination = destination,
        level = level,
    )
}
