@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.LustreFileSystemMetadataConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property iops Amount of IOPS provisioned for metadata. This parameter should only be used when the mode is set to `USER_PROVISIONED`. Valid Values are `1500`,`3000`,`6000` and `12000` through `192000` in increments of `12000`.
 * @property mode Mode for the metadata configuration of the file system. Valid values are `AUTOMATIC`, and `USER_PROVISIONED`.
 * !> **WARNING:** Updating the value of `iops` from a higher to a lower value will force a recreation of the resource. Any data on the file system will be lost when recreating.
 */
public data class LustreFileSystemMetadataConfigurationArgs(
    public val iops: Output<Int>? = null,
    public val mode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.LustreFileSystemMetadataConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.LustreFileSystemMetadataConfigurationArgs =
        com.pulumi.aws.fsx.inputs.LustreFileSystemMetadataConfigurationArgs.builder()
            .iops(iops?.applyValue({ args0 -> args0 }))
            .mode(mode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LustreFileSystemMetadataConfigurationArgs].
 */
@PulumiTagMarker
public class LustreFileSystemMetadataConfigurationArgsBuilder internal constructor() {
    private var iops: Output<Int>? = null

    private var mode: Output<String>? = null

    /**
     * @param value Amount of IOPS provisioned for metadata. This parameter should only be used when the mode is set to `USER_PROVISIONED`. Valid Values are `1500`,`3000`,`6000` and `12000` through `192000` in increments of `12000`.
     */
    @JvmName("toehflpotgutapni")
    public suspend fun iops(`value`: Output<Int>) {
        this.iops = value
    }

    /**
     * @param value Mode for the metadata configuration of the file system. Valid values are `AUTOMATIC`, and `USER_PROVISIONED`.
     * !> **WARNING:** Updating the value of `iops` from a higher to a lower value will force a recreation of the resource. Any data on the file system will be lost when recreating.
     */
    @JvmName("iygcxgwivptrqhra")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value Amount of IOPS provisioned for metadata. This parameter should only be used when the mode is set to `USER_PROVISIONED`. Valid Values are `1500`,`3000`,`6000` and `12000` through `192000` in increments of `12000`.
     */
    @JvmName("iqagqlfsombwjvlh")
    public suspend fun iops(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iops = mapped
    }

    /**
     * @param value Mode for the metadata configuration of the file system. Valid values are `AUTOMATIC`, and `USER_PROVISIONED`.
     * !> **WARNING:** Updating the value of `iops` from a higher to a lower value will force a recreation of the resource. Any data on the file system will be lost when recreating.
     */
    @JvmName("vbhisoeqwfneejma")
    public suspend fun mode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    internal fun build(): LustreFileSystemMetadataConfigurationArgs =
        LustreFileSystemMetadataConfigurationArgs(
            iops = iops,
            mode = mode,
        )
}
