@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.LustreFileSystemRootSquashConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property noSquashNids When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses: 1. A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, 10.0.1.6@tcp). 2. An address range is described using a dash to separate the range (for example, 10.0.[2-10]&#46;[1-255]@tcp).
 * @property rootSquash You enable root squash by setting a user ID (UID) and group ID (GID) for the file system in the format UID:GID (for example, 365534:65534). The UID and GID values can range from 0 to 4294967294.
 */
public data class LustreFileSystemRootSquashConfigurationArgs(
    public val noSquashNids: Output<List<String>>? = null,
    public val rootSquash: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.LustreFileSystemRootSquashConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.LustreFileSystemRootSquashConfigurationArgs =
        com.pulumi.aws.fsx.inputs.LustreFileSystemRootSquashConfigurationArgs.builder()
            .noSquashNids(noSquashNids?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .rootSquash(rootSquash?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LustreFileSystemRootSquashConfigurationArgs].
 */
@PulumiTagMarker
public class LustreFileSystemRootSquashConfigurationArgsBuilder internal constructor() {
    private var noSquashNids: Output<List<String>>? = null

    private var rootSquash: Output<String>? = null

    /**
     * @param value When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses: 1. A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, 10.0.1.6@tcp). 2. An address range is described using a dash to separate the range (for example, 10.0.[2-10]&#46;[1-255]@tcp).
     */
    @JvmName("uhqetaxqwdvoreew")
    public suspend fun noSquashNids(`value`: Output<List<String>>) {
        this.noSquashNids = value
    }

    @JvmName("yiymkvmuqtcujxlg")
    public suspend fun noSquashNids(vararg values: Output<String>) {
        this.noSquashNids = Output.all(values.asList())
    }

    /**
     * @param values When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses: 1. A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, 10.0.1.6@tcp). 2. An address range is described using a dash to separate the range (for example, 10.0.[2-10]&#46;[1-255]@tcp).
     */
    @JvmName("exivprampxfukrvk")
    public suspend fun noSquashNids(values: List<Output<String>>) {
        this.noSquashNids = Output.all(values)
    }

    /**
     * @param value You enable root squash by setting a user ID (UID) and group ID (GID) for the file system in the format UID:GID (for example, 365534:65534). The UID and GID values can range from 0 to 4294967294.
     */
    @JvmName("vhewerwlopxjrwcp")
    public suspend fun rootSquash(`value`: Output<String>) {
        this.rootSquash = value
    }

    /**
     * @param value When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses: 1. A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, 10.0.1.6@tcp). 2. An address range is described using a dash to separate the range (for example, 10.0.[2-10]&#46;[1-255]@tcp).
     */
    @JvmName("umushnmmtguryvdl")
    public suspend fun noSquashNids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noSquashNids = mapped
    }

    /**
     * @param values When root squash is enabled, you can optionally specify an array of NIDs of clients for which root squash does not apply. A client NID is a Lustre Network Identifier used to uniquely identify a client. You can specify the NID as either a single address or a range of addresses: 1. A single address is described in standard Lustre NID format by specifying the client’s IP address followed by the Lustre network ID (for example, 10.0.1.6@tcp). 2. An address range is described using a dash to separate the range (for example, 10.0.[2-10]&#46;[1-255]@tcp).
     */
    @JvmName("uuqxbfvbgeveqtbc")
    public suspend fun noSquashNids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.noSquashNids = mapped
    }

    /**
     * @param value You enable root squash by setting a user ID (UID) and group ID (GID) for the file system in the format UID:GID (for example, 365534:65534). The UID and GID values can range from 0 to 4294967294.
     */
    @JvmName("ngbafreohhoixwam")
    public suspend fun rootSquash(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rootSquash = mapped
    }

    internal fun build(): LustreFileSystemRootSquashConfigurationArgs =
        LustreFileSystemRootSquashConfigurationArgs(
            noSquashNids = noSquashNids,
            rootSquash = rootSquash,
        )
}
