@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property netbiosName The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. AWS limits to 15 characters because of standard NetBIOS naming limits.
 * @property selfManagedActiveDirectoryConfiguration
 */
public data class OntapStorageVirtualMachineActiveDirectoryConfigurationArgs(
    public val netbiosName: Output<String>? = null,
    public val selfManagedActiveDirectoryConfiguration: Output<OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.fsx.inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs =
        com.pulumi.aws.fsx.inputs.OntapStorageVirtualMachineActiveDirectoryConfigurationArgs.builder()
            .netbiosName(netbiosName?.applyValue({ args0 -> args0 }))
            .selfManagedActiveDirectoryConfiguration(
                selfManagedActiveDirectoryConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [OntapStorageVirtualMachineActiveDirectoryConfigurationArgs].
 */
@PulumiTagMarker
public class OntapStorageVirtualMachineActiveDirectoryConfigurationArgsBuilder internal constructor() {
    private var netbiosName: Output<String>? = null

    private var selfManagedActiveDirectoryConfiguration:
        Output<OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs>? =
        null

    /**
     * @param value The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. AWS limits to 15 characters because of standard NetBIOS naming limits.
     */
    @JvmName("qspnylntyurclgic")
    public suspend fun netbiosName(`value`: Output<String>) {
        this.netbiosName = value
    }

    /**
     * @param value
     */
    @JvmName("hpetmgffltinpbpc")
    public suspend fun selfManagedActiveDirectoryConfiguration(`value`: Output<OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs>) {
        this.selfManagedActiveDirectoryConfiguration = value
    }

    /**
     * @param value The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. AWS limits to 15 characters because of standard NetBIOS naming limits.
     */
    @JvmName("rlhmvpxlnikjcsfa")
    public suspend fun netbiosName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.netbiosName = mapped
    }

    /**
     * @param value
     */
    @JvmName("juclbpcvvthiycey")
    public suspend fun selfManagedActiveDirectoryConfiguration(`value`: OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selfManagedActiveDirectoryConfiguration = mapped
    }

    /**
     * @param argument
     */
    @JvmName("jkqqjfhndpmuvwrp")
    public suspend fun selfManagedActiveDirectoryConfiguration(argument: suspend OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.selfManagedActiveDirectoryConfiguration = mapped
    }

    internal fun build(): OntapStorageVirtualMachineActiveDirectoryConfigurationArgs =
        OntapStorageVirtualMachineActiveDirectoryConfigurationArgs(
            netbiosName = netbiosName,
            selfManagedActiveDirectoryConfiguration = selfManagedActiveDirectoryConfiguration,
        )
}
