@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OntapVolumeAggregateConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property aggregates Used to specify the names of the aggregates on which the volume will be created. Each aggregate needs to be in the format aggrX where X is the number of the aggregate.
 * @property constituentsPerAggregate Used to explicitly set the number of constituents within the FlexGroup per storage aggregate. the default value is `8`.
 * @property totalConstituents The total amount of constituents for a `FLEXGROUP` volume. This would equal constituents_per_aggregate x aggregates.
 */
public data class OntapVolumeAggregateConfigurationArgs(
    public val aggregates: Output<List<String>>? = null,
    public val constituentsPerAggregate: Output<Int>? = null,
    public val totalConstituents: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.OntapVolumeAggregateConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OntapVolumeAggregateConfigurationArgs =
        com.pulumi.aws.fsx.inputs.OntapVolumeAggregateConfigurationArgs.builder()
            .aggregates(aggregates?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .constituentsPerAggregate(constituentsPerAggregate?.applyValue({ args0 -> args0 }))
            .totalConstituents(totalConstituents?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OntapVolumeAggregateConfigurationArgs].
 */
@PulumiTagMarker
public class OntapVolumeAggregateConfigurationArgsBuilder internal constructor() {
    private var aggregates: Output<List<String>>? = null

    private var constituentsPerAggregate: Output<Int>? = null

    private var totalConstituents: Output<Int>? = null

    /**
     * @param value Used to specify the names of the aggregates on which the volume will be created. Each aggregate needs to be in the format aggrX where X is the number of the aggregate.
     */
    @JvmName("ywgwctsvsbqewojq")
    public suspend fun aggregates(`value`: Output<List<String>>) {
        this.aggregates = value
    }

    @JvmName("gwptwvlypenhhqbc")
    public suspend fun aggregates(vararg values: Output<String>) {
        this.aggregates = Output.all(values.asList())
    }

    /**
     * @param values Used to specify the names of the aggregates on which the volume will be created. Each aggregate needs to be in the format aggrX where X is the number of the aggregate.
     */
    @JvmName("vwcbucfddrcvermk")
    public suspend fun aggregates(values: List<Output<String>>) {
        this.aggregates = Output.all(values)
    }

    /**
     * @param value Used to explicitly set the number of constituents within the FlexGroup per storage aggregate. the default value is `8`.
     */
    @JvmName("fleqiyplljindicj")
    public suspend fun constituentsPerAggregate(`value`: Output<Int>) {
        this.constituentsPerAggregate = value
    }

    /**
     * @param value The total amount of constituents for a `FLEXGROUP` volume. This would equal constituents_per_aggregate x aggregates.
     */
    @JvmName("mqnnyqihbhktgbtw")
    public suspend fun totalConstituents(`value`: Output<Int>) {
        this.totalConstituents = value
    }

    /**
     * @param value Used to specify the names of the aggregates on which the volume will be created. Each aggregate needs to be in the format aggrX where X is the number of the aggregate.
     */
    @JvmName("yqkcmqvjvcixmodj")
    public suspend fun aggregates(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregates = mapped
    }

    /**
     * @param values Used to specify the names of the aggregates on which the volume will be created. Each aggregate needs to be in the format aggrX where X is the number of the aggregate.
     */
    @JvmName("klxmewrbtghqmcok")
    public suspend fun aggregates(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.aggregates = mapped
    }

    /**
     * @param value Used to explicitly set the number of constituents within the FlexGroup per storage aggregate. the default value is `8`.
     */
    @JvmName("hcxqmiqdhbvvbquf")
    public suspend fun constituentsPerAggregate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.constituentsPerAggregate = mapped
    }

    /**
     * @param value The total amount of constituents for a `FLEXGROUP` volume. This would equal constituents_per_aggregate x aggregates.
     */
    @JvmName("rcehpacfdgagspcu")
    public suspend fun totalConstituents(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalConstituents = mapped
    }

    internal fun build(): OntapVolumeAggregateConfigurationArgs =
        OntapVolumeAggregateConfigurationArgs(
            aggregates = aggregates,
            constituentsPerAggregate = constituentsPerAggregate,
            totalConstituents = totalConstituents,
        )
}
