@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of the valid types. If you set it to `INFINITE`, the files are retained forever. If you set it to `UNSPECIFIED`, the files are retained until you set an explicit retention period. Valid values: `SECONDS`, `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `INFINITE`, `UNSPECIFIED`.
 * @property value The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
 */
public data class OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs(
    public val type: Output<String>? = null,
    public val `value`: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs =
        com.pulumi.aws.fsx.inputs.OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs.builder()
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs].
 */
@PulumiTagMarker
public class OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<Int>? = null

    /**
     * @param value The type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of the valid types. If you set it to `INFINITE`, the files are retained forever. If you set it to `UNSPECIFIED`, the files are retained until you set an explicit retention period. Valid values: `SECONDS`, `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `INFINITE`, `UNSPECIFIED`.
     */
    @JvmName("tsjeaftpkyvlssyn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
     */
    @JvmName("gpdysqsypnojikms")
    public suspend fun `value`(`value`: Output<Int>) {
        this.`value` = value
    }

    /**
     * @param value The type of time for the retention period of an FSx for ONTAP SnapLock volume. Set it to one of the valid types. If you set it to `INFINITE`, the files are retained forever. If you set it to `UNSPECIFIED`, the files are retained until you set an explicit retention period. Valid values: `SECONDS`, `MINUTES`, `HOURS`, `DAYS`, `MONTHS`, `YEARS`, `INFINITE`, `UNSPECIFIED`.
     */
    @JvmName("lxullobajwfysnfm")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The amount of time for the autocommit period of a file in an FSx for ONTAP SnapLock volume.
     */
    @JvmName("xqyiyktxoyciprnh")
    public suspend fun `value`(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs =
        OntapVolumeSnaplockConfigurationRetentionPeriodMaximumRetentionArgs(
            type = type,
            `value` = `value`,
        )
}
