@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property copyTagsToSnapshots A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
 * @property dataCompressionType Method used to compress the data on the volume. Valid values are `LZ4`, `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
 * @property nfsExports NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block for details.
 * @property readOnly specifies whether the volume is read-only. Default is false.
 * @property recordSizeKib Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
 * @property userAndGroupQuotas Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block for details.
 */
public data class OpenZfsFileSystemRootVolumeConfigurationArgs(
    public val copyTagsToSnapshots: Output<Boolean>? = null,
    public val dataCompressionType: Output<String>? = null,
    public val nfsExports: Output<OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs>? = null,
    public val readOnly: Output<Boolean>? = null,
    public val recordSizeKib: Output<Int>? = null,
    public val userAndGroupQuotas: Output<List<OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationArgs =
        com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationArgs.builder()
            .copyTagsToSnapshots(copyTagsToSnapshots?.applyValue({ args0 -> args0 }))
            .dataCompressionType(dataCompressionType?.applyValue({ args0 -> args0 }))
            .nfsExports(nfsExports?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 }))
            .recordSizeKib(recordSizeKib?.applyValue({ args0 -> args0 }))
            .userAndGroupQuotas(
                userAndGroupQuotas?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [OpenZfsFileSystemRootVolumeConfigurationArgs].
 */
@PulumiTagMarker
public class OpenZfsFileSystemRootVolumeConfigurationArgsBuilder internal constructor() {
    private var copyTagsToSnapshots: Output<Boolean>? = null

    private var dataCompressionType: Output<String>? = null

    private var nfsExports: Output<OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs>? = null

    private var readOnly: Output<Boolean>? = null

    private var recordSizeKib: Output<Int>? = null

    private var userAndGroupQuotas:
        Output<List<OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs>>? = null

    /**
     * @param value A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     */
    @JvmName("bmuosgbddgqnsruh")
    public suspend fun copyTagsToSnapshots(`value`: Output<Boolean>) {
        this.copyTagsToSnapshots = value
    }

    /**
     * @param value Method used to compress the data on the volume. Valid values are `LZ4`, `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
     */
    @JvmName("nctanrrifwyoerll")
    public suspend fun dataCompressionType(`value`: Output<String>) {
        this.dataCompressionType = value
    }

    /**
     * @param value NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block for details.
     */
    @JvmName("adfsucgthtfhgolg")
    public suspend fun nfsExports(`value`: Output<OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs>) {
        this.nfsExports = value
    }

    /**
     * @param value specifies whether the volume is read-only. Default is false.
     */
    @JvmName("rqwqhbiqpnbpprdw")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
     */
    @JvmName("fuyrgbsonexyfvtt")
    public suspend fun recordSizeKib(`value`: Output<Int>) {
        this.recordSizeKib = value
    }

    /**
     * @param value Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block for details.
     */
    @JvmName("oleqbjaaugkddmbn")
    public suspend fun userAndGroupQuotas(`value`: Output<List<OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs>>) {
        this.userAndGroupQuotas = value
    }

    @JvmName("ggnvsrpolfffpwvx")
    public suspend fun userAndGroupQuotas(vararg values: Output<OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs>) {
        this.userAndGroupQuotas = Output.all(values.asList())
    }

    /**
     * @param values Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block for details.
     */
    @JvmName("gwgfggbvqtgjrpnu")
    public suspend fun userAndGroupQuotas(values: List<Output<OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs>>) {
        this.userAndGroupQuotas = Output.all(values)
    }

    /**
     * @param value A boolean flag indicating whether tags for the file system should be copied to snapshots. The default value is false.
     */
    @JvmName("bsfojnmlduihwrio")
    public suspend fun copyTagsToSnapshots(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.copyTagsToSnapshots = mapped
    }

    /**
     * @param value Method used to compress the data on the volume. Valid values are `LZ4`, `NONE` or `ZSTD`. Child volumes that don't specify compression option will inherit from parent volume. This option on file system applies to the root volume.
     */
    @JvmName("vrapeonjuhrcuoio")
    public suspend fun dataCompressionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataCompressionType = mapped
    }

    /**
     * @param value NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block for details.
     */
    @JvmName("xxkxhsjbvmrbcjru")
    public suspend fun nfsExports(`value`: OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nfsExports = mapped
    }

    /**
     * @param argument NFS export configuration for the root volume. Exactly 1 item. See `nfs_exports` Block for details.
     */
    @JvmName("foesnsltrjmxnmdj")
    public suspend fun nfsExports(argument: suspend OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgsBuilder.() -> Unit) {
        val toBeMapped = OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nfsExports = mapped
    }

    /**
     * @param value specifies whether the volume is read-only. Default is false.
     */
    @JvmName("sobcbvlppfcbdjge")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    /**
     * @param value Specifies the record size of an OpenZFS root volume, in kibibytes (KiB). Valid values are `4`, `8`, `16`, `32`, `64`, `128`, `256`, `512`, or `1024` KiB. The default is `128` KiB.
     */
    @JvmName("yqmyxghvkcmywqeb")
    public suspend fun recordSizeKib(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recordSizeKib = mapped
    }

    /**
     * @param value Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block for details.
     */
    @JvmName("lfnryowtllfvibmi")
    public suspend fun userAndGroupQuotas(`value`: List<OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAndGroupQuotas = mapped
    }

    /**
     * @param argument Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block for details.
     */
    @JvmName("kxnlfeuxvmimpcxu")
    public suspend fun userAndGroupQuotas(argument: List<suspend OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userAndGroupQuotas = mapped
    }

    /**
     * @param argument Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block for details.
     */
    @JvmName("vfinqbunexfnawgj")
    public suspend fun userAndGroupQuotas(vararg argument: suspend OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userAndGroupQuotas = mapped
    }

    /**
     * @param argument Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block for details.
     */
    @JvmName("ahgcyqvvvmowryej")
    public suspend fun userAndGroupQuotas(argument: suspend OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.userAndGroupQuotas = mapped
    }

    /**
     * @param values Specify how much storage users or groups can use on the volume. Maximum of 100 items. See `user_and_group_quotas` Block for details.
     */
    @JvmName("alxmebsphvpakiyf")
    public suspend fun userAndGroupQuotas(vararg values: OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAndGroupQuotas = mapped
    }

    internal fun build(): OpenZfsFileSystemRootVolumeConfigurationArgs =
        OpenZfsFileSystemRootVolumeConfigurationArgs(
            copyTagsToSnapshots = copyTagsToSnapshots,
            dataCompressionType = dataCompressionType,
            nfsExports = nfsExports,
            readOnly = readOnly,
            recordSizeKib = recordSizeKib,
            userAndGroupQuotas = userAndGroupQuotas,
        )
}
