@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clientConfigurations A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block for details.
 */
public data class OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs(
    public val clientConfigurations: Output<List<OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs =
        com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs.builder()
            .clientConfigurations(
                clientConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs].
 */
@PulumiTagMarker
public class OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgsBuilder internal constructor() {
    private var clientConfigurations:
        Output<List<OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs>>? =
        null

    /**
     * @param value A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block for details.
     */
    @JvmName("eipnqalspguameqd")
    public suspend fun clientConfigurations(`value`: Output<List<OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs>>) {
        this.clientConfigurations = value
    }

    @JvmName("kryjifxtuvbkhdls")
    public suspend fun clientConfigurations(vararg values: Output<OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs>) {
        this.clientConfigurations = Output.all(values.asList())
    }

    /**
     * @param values A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block for details.
     */
    @JvmName("ogvgtdoenxrkexkq")
    public suspend fun clientConfigurations(values: List<Output<OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs>>) {
        this.clientConfigurations = Output.all(values)
    }

    /**
     * @param value A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block for details.
     */
    @JvmName("nsfvlbixfiidvdsf")
    public suspend fun clientConfigurations(`value`: List<OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientConfigurations = mapped
    }

    /**
     * @param argument A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block for details.
     */
    @JvmName("mqrvlnnryeesvqqm")
    public suspend fun clientConfigurations(argument: List<suspend OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clientConfigurations = mapped
    }

    /**
     * @param argument A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block for details.
     */
    @JvmName("ahvvauwsxpvhgslj")
    public suspend fun clientConfigurations(vararg argument: suspend OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.clientConfigurations = mapped
    }

    /**
     * @param argument A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block for details.
     */
    @JvmName("txhjfronaphoseta")
    public suspend fun clientConfigurations(argument: suspend OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.clientConfigurations = mapped
    }

    /**
     * @param values A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block for details.
     */
    @JvmName("uillwwiioncnxefs")
    public suspend fun clientConfigurations(vararg values: OpenZfsFileSystemRootVolumeConfigurationNfsExportsClientConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientConfigurations = mapped
    }

    internal fun build(): OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs =
        OpenZfsFileSystemRootVolumeConfigurationNfsExportsArgs(
            clientConfigurations = clientConfigurations ?: throw
                PulumiNullFieldException("clientConfigurations"),
        )
}
