@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The ID of the user or group. Valid values between `0` and `2147483647`
 * @property storageCapacityQuotaGib The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
 * @property type A value that specifies whether the quota applies to a user or group. Valid values are `USER` or `GROUP`.
 */
public data class OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs(
    public val id: Output<Int>,
    public val storageCapacityQuotaGib: Output<Int>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs =
        com.pulumi.aws.fsx.inputs.OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .storageCapacityQuotaGib(storageCapacityQuotaGib.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs].
 */
@PulumiTagMarker
public class OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgsBuilder internal constructor() {
    private var id: Output<Int>? = null

    private var storageCapacityQuotaGib: Output<Int>? = null

    private var type: Output<String>? = null

    /**
     * @param value The ID of the user or group. Valid values between `0` and `2147483647`
     */
    @JvmName("gvcbltnyhbldmmfy")
    public suspend fun id(`value`: Output<Int>) {
        this.id = value
    }

    /**
     * @param value The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
     */
    @JvmName("adslilavrdwrklnf")
    public suspend fun storageCapacityQuotaGib(`value`: Output<Int>) {
        this.storageCapacityQuotaGib = value
    }

    /**
     * @param value A value that specifies whether the quota applies to a user or group. Valid values are `USER` or `GROUP`.
     */
    @JvmName("qlyggpycycvybyls")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The ID of the user or group. Valid values between `0` and `2147483647`
     */
    @JvmName("mqkqbqyymjvmmieo")
    public suspend fun id(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The amount of storage that the user or group can use in gibibytes (GiB). Valid values between `0` and `2147483647`
     */
    @JvmName("idmulhqlxicmhmfx")
    public suspend fun storageCapacityQuotaGib(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageCapacityQuotaGib = mapped
    }

    /**
     * @param value A value that specifies whether the quota applies to a user or group. Valid values are `USER` or `GROUP`.
     */
    @JvmName("wkbcixivbrugcfjx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs =
        OpenZfsFileSystemRootVolumeConfigurationUserAndGroupQuotaArgs(
            id = id ?: throw PulumiNullFieldException("id"),
            storageCapacityQuotaGib = storageCapacityQuotaGib ?: throw
                PulumiNullFieldException("storageCapacityQuotaGib"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
