@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OpenZfsVolumeNfsExportsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clientConfigurations A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
 */
public data class OpenZfsVolumeNfsExportsArgs(
    public val clientConfigurations: Output<List<OpenZfsVolumeNfsExportsClientConfigurationArgs>>,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.OpenZfsVolumeNfsExportsArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OpenZfsVolumeNfsExportsArgs =
        com.pulumi.aws.fsx.inputs.OpenZfsVolumeNfsExportsArgs.builder()
            .clientConfigurations(
                clientConfigurations.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [OpenZfsVolumeNfsExportsArgs].
 */
@PulumiTagMarker
public class OpenZfsVolumeNfsExportsArgsBuilder internal constructor() {
    private var clientConfigurations: Output<List<OpenZfsVolumeNfsExportsClientConfigurationArgs>>? =
        null

    /**
     * @param value A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
     */
    @JvmName("mgcdswchvjyuogsf")
    public suspend fun clientConfigurations(`value`: Output<List<OpenZfsVolumeNfsExportsClientConfigurationArgs>>) {
        this.clientConfigurations = value
    }

    @JvmName("srsuwoptullmobuk")
    public suspend fun clientConfigurations(vararg values: Output<OpenZfsVolumeNfsExportsClientConfigurationArgs>) {
        this.clientConfigurations = Output.all(values.asList())
    }

    /**
     * @param values A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
     */
    @JvmName("xmxlflvgxsvhdbrt")
    public suspend fun clientConfigurations(values: List<Output<OpenZfsVolumeNfsExportsClientConfigurationArgs>>) {
        this.clientConfigurations = Output.all(values)
    }

    /**
     * @param value A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
     */
    @JvmName("isxrffqjhkqvcyyi")
    public suspend fun clientConfigurations(`value`: List<OpenZfsVolumeNfsExportsClientConfigurationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientConfigurations = mapped
    }

    /**
     * @param argument A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
     */
    @JvmName("lanaqmcahmfjiayy")
    public suspend fun clientConfigurations(argument: List<suspend OpenZfsVolumeNfsExportsClientConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            OpenZfsVolumeNfsExportsClientConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.clientConfigurations = mapped
    }

    /**
     * @param argument A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
     */
    @JvmName("xdfqksseeiiqpjyp")
    public suspend fun clientConfigurations(vararg argument: suspend OpenZfsVolumeNfsExportsClientConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            OpenZfsVolumeNfsExportsClientConfigurationArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.clientConfigurations = mapped
    }

    /**
     * @param argument A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
     */
    @JvmName("ximonhdayrvijrwg")
    public suspend fun clientConfigurations(argument: suspend OpenZfsVolumeNfsExportsClientConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            OpenZfsVolumeNfsExportsClientConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.clientConfigurations = mapped
    }

    /**
     * @param values A list of configuration objects that contain the client and options for mounting the OpenZFS file system. Maximum of 25 items. See `client_configurations` Block below for details.
     */
    @JvmName("ahahspogbxdrfulf")
    public suspend fun clientConfigurations(vararg values: OpenZfsVolumeNfsExportsClientConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientConfigurations = mapped
    }

    internal fun build(): OpenZfsVolumeNfsExportsArgs = OpenZfsVolumeNfsExportsArgs(
        clientConfigurations = clientConfigurations ?: throw
            PulumiNullFieldException("clientConfigurations"),
    )
}
