@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.OpenZfsVolumeNfsExportsClientConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clients A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
 * @property options The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
 */
public data class OpenZfsVolumeNfsExportsClientConfigurationArgs(
    public val clients: Output<String>,
    public val options: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.OpenZfsVolumeNfsExportsClientConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.OpenZfsVolumeNfsExportsClientConfigurationArgs =
        com.pulumi.aws.fsx.inputs.OpenZfsVolumeNfsExportsClientConfigurationArgs.builder()
            .clients(clients.applyValue({ args0 -> args0 }))
            .options(options.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [OpenZfsVolumeNfsExportsClientConfigurationArgs].
 */
@PulumiTagMarker
public class OpenZfsVolumeNfsExportsClientConfigurationArgsBuilder internal constructor() {
    private var clients: Output<String>? = null

    private var options: Output<List<String>>? = null

    /**
     * @param value A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
     */
    @JvmName("ncvyvkqhgsivylqn")
    public suspend fun clients(`value`: Output<String>) {
        this.clients = value
    }

    /**
     * @param value The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
     */
    @JvmName("wxgeokxprycettmo")
    public suspend fun options(`value`: Output<List<String>>) {
        this.options = value
    }

    @JvmName("nbnykjwtpbdbdcmo")
    public suspend fun options(vararg values: Output<String>) {
        this.options = Output.all(values.asList())
    }

    /**
     * @param values The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
     */
    @JvmName("wgpoifrvemqctckl")
    public suspend fun options(values: List<Output<String>>) {
        this.options = Output.all(values)
    }

    /**
     * @param value A value that specifies who can mount the file system. You can provide a wildcard character (*), an IP address (0.0.0.0), or a CIDR address (192.0.2.0/24. By default, Amazon FSx uses the wildcard character when specifying the client.
     */
    @JvmName("kdmtwogohtwjdjsf")
    public suspend fun clients(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clients = mapped
    }

    /**
     * @param value The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
     */
    @JvmName("bbjigrkvskgbimnn")
    public suspend fun options(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.options = mapped
    }

    /**
     * @param values The options to use when mounting the file system. Maximum of 20 items. See the [Linix NFS exports man page](https://linux.die.net/man/5/exports) for more information. `crossmount` and `sync` are used by default.
     */
    @JvmName("ncxeagwiweddfloj")
    public suspend fun options(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.options = mapped
    }

    internal fun build(): OpenZfsVolumeNfsExportsClientConfigurationArgs =
        OpenZfsVolumeNfsExportsClientConfigurationArgs(
            clients = clients ?: throw PulumiNullFieldException("clients"),
            options = options ?: throw PulumiNullFieldException("options"),
        )
}
