@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.inputs

import com.pulumi.aws.fsx.inputs.WindowsFileSystemSelfManagedActiveDirectoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dnsIps A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
 * @property domainName The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
 * @property fileSystemAdministratorsGroup The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
 * @property organizationalUnitDistinguishedName The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
 * @property password The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
 * @property username The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
 */
public data class WindowsFileSystemSelfManagedActiveDirectoryArgs(
    public val dnsIps: Output<List<String>>,
    public val domainName: Output<String>,
    public val fileSystemAdministratorsGroup: Output<String>? = null,
    public val organizationalUnitDistinguishedName: Output<String>? = null,
    public val password: Output<String>,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.fsx.inputs.WindowsFileSystemSelfManagedActiveDirectoryArgs> {
    override fun toJava(): com.pulumi.aws.fsx.inputs.WindowsFileSystemSelfManagedActiveDirectoryArgs =
        com.pulumi.aws.fsx.inputs.WindowsFileSystemSelfManagedActiveDirectoryArgs.builder()
            .dnsIps(dnsIps.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .fileSystemAdministratorsGroup(fileSystemAdministratorsGroup?.applyValue({ args0 -> args0 }))
            .organizationalUnitDistinguishedName(
                organizationalUnitDistinguishedName?.applyValue({ args0 ->
                    args0
                }),
            )
            .password(password.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [WindowsFileSystemSelfManagedActiveDirectoryArgs].
 */
@PulumiTagMarker
public class WindowsFileSystemSelfManagedActiveDirectoryArgsBuilder internal constructor() {
    private var dnsIps: Output<List<String>>? = null

    private var domainName: Output<String>? = null

    private var fileSystemAdministratorsGroup: Output<String>? = null

    private var organizationalUnitDistinguishedName: Output<String>? = null

    private var password: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
     */
    @JvmName("hxrhiwodhrkpwkrs")
    public suspend fun dnsIps(`value`: Output<List<String>>) {
        this.dnsIps = value
    }

    @JvmName("raabryutswheujar")
    public suspend fun dnsIps(vararg values: Output<String>) {
        this.dnsIps = Output.all(values.asList())
    }

    /**
     * @param values A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
     */
    @JvmName("ufakfrkrtgnxlkvi")
    public suspend fun dnsIps(values: List<Output<String>>) {
        this.dnsIps = Output.all(values)
    }

    /**
     * @param value The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
     */
    @JvmName("pkqnpxaoypkbqwsu")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
     */
    @JvmName("wndrspccdteeaemd")
    public suspend fun fileSystemAdministratorsGroup(`value`: Output<String>) {
        this.fileSystemAdministratorsGroup = value
    }

    /**
     * @param value The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
     */
    @JvmName("anjctvudkjewuefh")
    public suspend fun organizationalUnitDistinguishedName(`value`: Output<String>) {
        this.organizationalUnitDistinguishedName = value
    }

    /**
     * @param value The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
     */
    @JvmName("vvmqpdynbuwtpmum")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
     */
    @JvmName("aeftijdctlmusbig")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
     */
    @JvmName("ierrxlvygvhokkvq")
    public suspend fun dnsIps(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsIps = mapped
    }

    /**
     * @param values A list of up to two IP addresses of DNS servers or domain controllers in the self-managed AD directory. The IP addresses need to be either in the same VPC CIDR range as the file system or in the private IP version 4 (IPv4) address ranges as specified in [RFC 1918](https://tools.ietf.org/html/rfc1918).
     */
    @JvmName("fwtmygkglyydtqfi")
    public suspend fun dnsIps(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsIps = mapped
    }

    /**
     * @param value The fully qualified domain name of the self-managed AD directory. For example, `corp.example.com`.
     */
    @JvmName("hfgmbrelyhwpimbj")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The name of the domain group whose members are granted administrative privileges for the file system. Administrative privileges include taking ownership of files and folders, and setting audit controls (audit ACLs) on files and folders. The group that you specify must already exist in your domain. Defaults to `Domain Admins`.
     */
    @JvmName("skcgeirhekgcvhjm")
    public suspend fun fileSystemAdministratorsGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemAdministratorsGroup = mapped
    }

    /**
     * @param value The fully qualified distinguished name of the organizational unit within your self-managed AD directory that the Windows File Server instance will join. For example, `OU=FSx,DC=yourdomain,DC=corp,DC=com`. Only accepts OU as the direct parent of the file system. If none is provided, the FSx file system is created in the default location of your self-managed AD directory. To learn more, see [RFC 2253](https://tools.ietf.org/html/rfc2253).
     */
    @JvmName("harbfnodwxhltqva")
    public suspend fun organizationalUnitDistinguishedName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnitDistinguishedName = mapped
    }

    /**
     * @param value The password for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
     */
    @JvmName("uwaeofjfdmjwepfu")
    public suspend fun password(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The user name for the service account on your self-managed AD domain that Amazon FSx will use to join to your AD domain.
     */
    @JvmName("tihfamisrnbckhdo")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): WindowsFileSystemSelfManagedActiveDirectoryArgs =
        WindowsFileSystemSelfManagedActiveDirectoryArgs(
            dnsIps = dnsIps ?: throw PulumiNullFieldException("dnsIps"),
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            fileSystemAdministratorsGroup = fileSystemAdministratorsGroup,
            organizationalUnitDistinguishedName = organizationalUnitDistinguishedName,
            password = password ?: throw PulumiNullFieldException("password"),
            username = username ?: throw PulumiNullFieldException("username"),
        )
}
