@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dnsIps A list of up to 2 IP addresses of DNS servers used to resolve the NFS file system domain name. The provided IP addresses can either be the IP addresses of a DNS forwarder or resolver that the customer manages and runs inside the customer VPC, or the IP addresses of the on-premises DNS servers.
 * @property version The version of the NFS (Network File System) protocol of the NFS data repository. The only supported value is NFS3, which indicates that the data repository must support the NFSv3 protocol. The only supported value is `NFS3`.
 */
public data class FileCacheDataRepositoryAssociationNf(
    public val dnsIps: List<String>? = null,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.FileCacheDataRepositoryAssociationNf): FileCacheDataRepositoryAssociationNf = FileCacheDataRepositoryAssociationNf(
            dnsIps = javaType.dnsIps().map({ args0 -> args0 }),
            version = javaType.version(),
        )
    }
}
