@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property iops The total number of SSD IOPS provisioned for the file system.
 * @property mode Specifies whether the file system is using the `AUTOMATIC` setting of SSD IOPS of 3 IOPS per GB of storage capacity, or if it using a `USER_PROVISIONED` value.
 */
public data class GetOntapFileSystemDiskIopsConfiguration(
    public val iops: Int,
    public val mode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetOntapFileSystemDiskIopsConfiguration): GetOntapFileSystemDiskIopsConfiguration = GetOntapFileSystemDiskIopsConfiguration(
            iops = javaType.iops(),
            mode = javaType.mode(),
        )
    }
}
