@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getOntapFileSystem.
 * @property arn Amazon Resource Name of the file system.
 * @property automaticBackupRetentionDays The number of days to retain automatic backups.
 * @property dailyAutomaticBackupStartTime The preferred time (in `HH:MM` format) to take daily automatic backups, in the UTC time zone.
 * @property deploymentType The file system deployment type.
 * @property diskIopsConfigurations The SSD IOPS configuration for the Amazon FSx for NetApp ONTAP file system, specifying the number of provisioned IOPS and the provision mode. See Disk IOPS Below.
 * @property dnsName DNS name for the file system.
 * @property endpointIpAddressRange (Multi-AZ only) Specifies the IP address range in which the endpoints to access your file system exist.
 * @property endpoints The Management and Intercluster FileSystemEndpoints that are used to access data or to manage the file system using the NetApp ONTAP CLI, REST API, or NetApp SnapMirror. See FileSystemEndpoints below.
 * @property haPairs The number of HA pairs for the file system.
 * @property id Identifier of the file system (e.g. `fs-12345678`).
 * @property kmsKeyId ARN for the KMS Key to encrypt the file system at rest.
 * @property networkInterfaceIds The IDs of the elastic network interfaces from which a specific file system is accessible.
 * @property ownerId AWS account identifier that created the file system.
 * @property preferredSubnetId Specifies the subnet in which you want the preferred file server to be located.
 * @property routeTableIds (Multi-AZ only) The VPC route tables in which your file system's endpoints exist.
 * @property storageCapacity The storage capacity of the file system in gibibytes (GiB).
 * @property storageType The type of storage the file system is using. If set to `SSD`, the file system uses solid state drive storage. If set to `HDD`, the file system uses hard disk drive storage.
 * @property subnetIds Specifies the IDs of the subnets that the file system is accessible from. For the MULTI_AZ_1 file system deployment type, there are two subnet IDs, one for the preferred file server and one for the standby file server. The preferred file server subnet identified in the `preferred_subnet_id` property.
 * @property tags The tags associated with the file system.
 * @property throughputCapacity The sustained throughput of an Amazon FSx file system in Megabytes per second (MBps). If the file system uses multiple HA pairs this will equal throuthput_capacity_per_ha_pair x ha_pairs
 * @property throughputCapacityPerHaPair The sustained throughput of each HA pair for an Amazon FSx file system in Megabytes per second (MBps).
 * @property vpcId The ID of the primary virtual private cloud (VPC) for the file system.
 * @property weeklyMaintenanceStartTime The preferred start time (in `D:HH:MM` format) to perform weekly maintenance, in the UTC time zone.
 */
public data class GetOntapFileSystemResult(
    public val arn: String,
    public val automaticBackupRetentionDays: Int,
    public val dailyAutomaticBackupStartTime: String,
    public val deploymentType: String,
    public val diskIopsConfigurations: List<GetOntapFileSystemDiskIopsConfiguration>,
    public val dnsName: String,
    public val endpointIpAddressRange: String,
    public val endpoints: List<GetOntapFileSystemEndpoint>,
    public val haPairs: Int,
    public val id: String,
    public val kmsKeyId: String,
    public val networkInterfaceIds: List<String>,
    public val ownerId: String,
    public val preferredSubnetId: String,
    public val routeTableIds: List<String>,
    public val storageCapacity: Int,
    public val storageType: String,
    public val subnetIds: List<String>,
    public val tags: Map<String, String>,
    public val throughputCapacity: Int,
    public val throughputCapacityPerHaPair: Int,
    public val vpcId: String,
    public val weeklyMaintenanceStartTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetOntapFileSystemResult): GetOntapFileSystemResult = GetOntapFileSystemResult(
            arn = javaType.arn(),
            automaticBackupRetentionDays = javaType.automaticBackupRetentionDays(),
            dailyAutomaticBackupStartTime = javaType.dailyAutomaticBackupStartTime(),
            deploymentType = javaType.deploymentType(),
            diskIopsConfigurations = javaType.diskIopsConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapFileSystemDiskIopsConfiguration.Companion.toKotlin(args0)
                })
            }),
            dnsName = javaType.dnsName(),
            endpointIpAddressRange = javaType.endpointIpAddressRange(),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOntapFileSystemEndpoint.Companion.toKotlin(args0)
                })
            }),
            haPairs = javaType.haPairs(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            networkInterfaceIds = javaType.networkInterfaceIds().map({ args0 -> args0 }),
            ownerId = javaType.ownerId(),
            preferredSubnetId = javaType.preferredSubnetId(),
            routeTableIds = javaType.routeTableIds().map({ args0 -> args0 }),
            storageCapacity = javaType.storageCapacity(),
            storageType = javaType.storageType(),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            throughputCapacity = javaType.throughputCapacity(),
            throughputCapacityPerHaPair = javaType.throughputCapacityPerHaPair(),
            vpcId = javaType.vpcId(),
            weeklyMaintenanceStartTime = javaType.weeklyMaintenanceStartTime(),
        )
    }
}
