@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property netbiosName The NetBIOS name of the AD computer object to which the SVM is joined.
 * @property selfManagedActiveDirectoryConfigurations
 */
public data class GetOntapStorageVirtualMachineActiveDirectoryConfiguration(
    public val netbiosName: String,
    public val selfManagedActiveDirectoryConfigurations: List<GetOntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetOntapStorageVirtualMachineActiveDirectoryConfiguration): GetOntapStorageVirtualMachineActiveDirectoryConfiguration =
            GetOntapStorageVirtualMachineActiveDirectoryConfiguration(
                netbiosName = javaType.netbiosName(),
                selfManagedActiveDirectoryConfigurations = javaType.selfManagedActiveDirectoryConfigurations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.fsx.kotlin.outputs.GetOntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
