@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getOpenZfsSnapshot.
 * @property arn Amazon Resource Name of the snapshot.
 * @property creationTime Time that the resource was created.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property mostRecent
 * @property name Name of the snapshot.
 * @property snapshotId ID of the snapshot.
 * @property snapshotIds
 * @property tags List of Tag values, with a maximum of 50 elements.
 * @property volumeId ID of the volume that the snapshot is of.
 */
public data class GetOpenZfsSnapshotResult(
    public val arn: String,
    public val creationTime: String,
    public val filters: List<GetOpenZfsSnapshotFilter>? = null,
    public val id: String,
    public val mostRecent: Boolean? = null,
    public val name: String? = null,
    public val snapshotId: String,
    public val snapshotIds: List<String>? = null,
    public val tags: Map<String, String>,
    public val volumeId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.GetOpenZfsSnapshotResult): GetOpenZfsSnapshotResult = GetOpenZfsSnapshotResult(
            arn = javaType.arn(),
            creationTime = javaType.creationTime(),
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.GetOpenZfsSnapshotFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            snapshotId = javaType.snapshotId(),
            snapshotIds = javaType.snapshotIds().map({ args0 -> args0 }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            volumeId = javaType.volumeId(),
        )
    }
}
