@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property iops Amount of IOPS provisioned for metadata. This parameter should only be used when the mode is set to `USER_PROVISIONED`. Valid Values are `1500`,`3000`,`6000` and `12000` through `192000` in increments of `12000`.
 * @property mode Mode for the metadata configuration of the file system. Valid values are `AUTOMATIC`, and `USER_PROVISIONED`.
 * !> **WARNING:** Updating the value of `iops` from a higher to a lower value will force a recreation of the resource. Any data on the file system will be lost when recreating.
 */
public data class LustreFileSystemMetadataConfiguration(
    public val iops: Int? = null,
    public val mode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.LustreFileSystemMetadataConfiguration): LustreFileSystemMetadataConfiguration = LustreFileSystemMetadataConfiguration(
            iops = javaType.iops().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
