@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property interclusters An endpoint for managing your file system by setting up NetApp SnapMirror with other ONTAP systems. See Endpoint.
 * @property managements An endpoint for managing your file system using the NetApp ONTAP CLI and NetApp ONTAP API. See Endpoint.
 */
public data class OntapFileSystemEndpoint(
    public val interclusters: List<OntapFileSystemEndpointIntercluster>? = null,
    public val managements: List<OntapFileSystemEndpointManagement>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapFileSystemEndpoint): OntapFileSystemEndpoint = OntapFileSystemEndpoint(
            interclusters = javaType.interclusters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.OntapFileSystemEndpointIntercluster.Companion.toKotlin(args0)
                })
            }),
            managements = javaType.managements().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.fsx.kotlin.outputs.OntapFileSystemEndpointManagement.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
