@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.fsx.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property netbiosName The NetBIOS name of the Active Directory computer object that will be created for your SVM. This is often the same as the SVM name but can be different. AWS limits to 15 characters because of standard NetBIOS naming limits.
 * @property selfManagedActiveDirectoryConfiguration
 */
public data class OntapStorageVirtualMachineActiveDirectoryConfiguration(
    public val netbiosName: String? = null,
    public val selfManagedActiveDirectoryConfiguration: OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.fsx.outputs.OntapStorageVirtualMachineActiveDirectoryConfiguration): OntapStorageVirtualMachineActiveDirectoryConfiguration =
            OntapStorageVirtualMachineActiveDirectoryConfiguration(
                netbiosName = javaType.netbiosName().map({ args0 -> args0 }).orElse(null),
                selfManagedActiveDirectoryConfiguration = javaType.selfManagedActiveDirectoryConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.fsx.kotlin.outputs.OntapStorageVirtualMachineActiveDirectoryConfigurationSelfManagedActiveDirectoryConfiguration.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
